/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.LinkNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public abstract class InlineLinkNode
extends LinkNode {
    protected BasedSequence textOpeningMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence textClosingMarker = BasedSequence.NULL;
    protected BasedSequence linkOpeningMarker = BasedSequence.NULL;
    protected BasedSequence linkClosingMarker = BasedSequence.NULL;

    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.textOpeningMarker, this.text, this.textClosingMarker, this.linkOpeningMarker, this.urlOpeningMarker, this.url, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker, this.linkClosingMarker};
    }

    @NotNull
    public BasedSequence[] getSegmentsForChars() {
        return new BasedSequence[]{this.textOpeningMarker, this.text, this.textClosingMarker, this.linkOpeningMarker, this.urlOpeningMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker, this.linkClosingMarker};
    }

    public void getAstExtra(@NotNull StringBuilder out) {
        InlineLinkNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.textOpeningMarker, (BasedSequence)this.text, (BasedSequence)this.textClosingMarker, (String)"text");
        InlineLinkNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.linkOpeningMarker, (String)"linkOpen");
        InlineLinkNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.urlOpeningMarker, (BasedSequence)this.url, (BasedSequence)this.urlClosingMarker, (String)"url");
        if (this.pageRef.isNotNull()) {
            InlineLinkNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.pageRef, (String)"pageRef");
        }
        if (this.anchorMarker.isNotNull()) {
            InlineLinkNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorMarker, (String)"anchorMarker");
        }
        if (this.anchorRef.isNotNull()) {
            InlineLinkNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorRef, (String)"anchorRef");
        }
        InlineLinkNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.titleOpeningMarker, (BasedSequence)this.title, (BasedSequence)this.titleClosingMarker, (String)"title");
        InlineLinkNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.linkClosingMarker, (String)"linkClose");
    }

    public InlineLinkNode() {
    }

    public InlineLinkNode(BasedSequence chars) {
        super(chars);
    }

    public InlineLinkNode(BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence linkOpeningMarker, BasedSequence url, BasedSequence titleOpeningMarker, BasedSequence title, BasedSequence titleClosingMarker, BasedSequence linkClosingMarker) {
        this.textOpeningMarker = textOpeningMarker;
        this.text = (BasedSequence)text.trim();
        this.textClosingMarker = textClosingMarker;
        this.linkOpeningMarker = linkOpeningMarker;
        this.url = url;
        this.titleOpeningMarker = titleOpeningMarker;
        this.title = title;
        this.titleClosingMarker = titleClosingMarker;
        this.linkClosingMarker = linkClosingMarker;
    }

    public InlineLinkNode(BasedSequence chars, BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence linkOpeningMarker, BasedSequence url, BasedSequence titleOpeningMarker, BasedSequence title, BasedSequence titleClosingMarker, BasedSequence linkClosingMarker) {
        super(chars);
        this.textOpeningMarker = textOpeningMarker;
        this.text = (BasedSequence)text.trim();
        this.textClosingMarker = textClosingMarker;
        this.linkOpeningMarker = linkOpeningMarker;
        this.url = url;
        this.titleOpeningMarker = titleOpeningMarker;
        this.title = title;
        this.titleClosingMarker = titleClosingMarker;
        this.linkClosingMarker = linkClosingMarker;
    }

    public InlineLinkNode(BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence linkOpeningMarker, BasedSequence url, BasedSequence linkClosingMarker) {
        this.textOpeningMarker = textOpeningMarker;
        this.text = (BasedSequence)text.trim();
        this.textClosingMarker = textClosingMarker;
        this.linkOpeningMarker = linkOpeningMarker;
        this.url = url;
        this.linkClosingMarker = linkClosingMarker;
    }

    public InlineLinkNode(BasedSequence chars, BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence linkOpeningMarker, BasedSequence url, BasedSequence linkClosingMarker) {
        super(chars);
        this.textOpeningMarker = textOpeningMarker;
        this.text = (BasedSequence)text.trim();
        this.textClosingMarker = textClosingMarker;
        this.linkOpeningMarker = linkOpeningMarker;
        this.url = url;
        this.linkClosingMarker = linkClosingMarker;
    }

    public void setUrl(BasedSequence linkOpeningMarker, BasedSequence url, BasedSequence linkClosingMarker) {
        this.linkOpeningMarker = linkOpeningMarker;
        this.setUrlChars(url);
        this.linkClosingMarker = linkClosingMarker;
    }

    public abstract void setTextChars(BasedSequence var1);

    public BasedSequence getText() {
        return this.text;
    }

    public BasedSequence getTextOpeningMarker() {
        return this.textOpeningMarker;
    }

    public void setTextOpeningMarker(BasedSequence textOpeningMarker) {
        this.textOpeningMarker = textOpeningMarker;
    }

    public void setText(BasedSequence text) {
        this.text = (BasedSequence)text.trim();
    }

    public BasedSequence getTextClosingMarker() {
        return this.textClosingMarker;
    }

    public void setTextClosingMarker(BasedSequence textClosingMarker) {
        this.textClosingMarker = textClosingMarker;
    }

    public BasedSequence getLinkOpeningMarker() {
        return this.linkOpeningMarker;
    }

    public void setLinkOpeningMarker(BasedSequence linkOpeningMarker) {
        this.linkOpeningMarker = linkOpeningMarker;
    }

    public BasedSequence getLinkClosingMarker() {
        return this.linkClosingMarker;
    }

    public void setLinkClosingMarker(BasedSequence linkClosingMarker) {
        this.linkClosingMarker = linkClosingMarker;
    }

    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.text + ", url=" + this.url + ", title=" + this.title;
    }
}

