/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNoShortCircuitNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TestConstraintNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class DMLModStatementNode
extends DMLStatementNode {
    protected FromVTI targetVTI;
    protected TableName targetTableName;
    protected ResultColumnList resultColumnList;
    protected int lockMode;
    protected FKInfo[] fkInfo;
    protected TriggerInfo triggerInfo;
    TableDescriptor targetTableDescriptor;
    public IndexRowGenerator[] indicesToMaintain;
    public long[] indexConglomerateNumbers;
    public String[] indexNames;
    protected ConstraintDescriptorList relevantCdl;
    protected TriggerDescriptorList relevantTriggers;
    private boolean requiresDeferredProcessing;
    private int statementType;
    private boolean bound;
    private ValueNode checkConstraints;
    protected String[] fkSchemaNames;
    protected String[] fkTableNames;
    protected int[] fkRefActions;
    protected ColumnDescriptorList[] fkColDescriptors;
    protected long[] fkIndexConglomNumbers;
    protected boolean isDependentTable;
    protected int[][] fkColArrays;
    protected TableName synonymTableName;
    protected MatchingClauseNode matchingClause;
    Set<String> dependentTables;

    DMLModStatementNode(ResultSetNode resultSet, MatchingClauseNode matchingClause, ContextManager cm) {
        super(resultSet, cm);
        this.matchingClause = matchingClause;
        this.statementType = this.getStatementType();
    }

    DMLModStatementNode(ResultSetNode resultSet, MatchingClauseNode matchingClause, int statementType, ContextManager cm) {
        super(resultSet, cm);
        this.matchingClause = matchingClause;
        this.statementType = statementType;
    }

    public boolean inMatchingClause() {
        return this.matchingClause != null;
    }

    void setTarget(QueryTreeNode targetName) {
        if (targetName instanceof TableName) {
            this.targetTableName = (TableName)targetName;
        } else {
            if (!(targetName instanceof FromVTI)) {
                SanityManager.THROWASSERT((String)("targetName expected to be FromVTI, not " + targetName.getClass().getName()));
            }
            this.targetVTI = (FromVTI)targetName;
            this.targetVTI.setTarget();
        }
    }

    protected void generateCodeForTemporaryTable(ActivationClassBuilder acb) throws StandardException {
        if (this.targetTableDescriptor != null && this.targetTableDescriptor.getTableType() == 3 && this.targetTableDescriptor.isOnRollbackDeleteRows()) {
            MethodBuilder mb = acb.getExecuteMethod();
            mb.pushThis();
            mb.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
            mb.push(this.targetTableDescriptor.getName());
            mb.callMethod((short)185, null, "markTempTableAsModifiedInUnitOfWork", "void", 1);
            mb.endStatement();
        }
    }

    void verifyTargetTable() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null) {
            SchemaDescriptor sdtc = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
            this.targetTableDescriptor = this.getTableDescriptor(this.targetTableName.getTableName(), sdtc);
            if (this.targetTableDescriptor == null) {
                TableName synonymTab = this.resolveTableToSynonym(this.targetTableName);
                if (synonymTab == null) {
                    throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.targetTableName});
                }
                this.synonymTableName = this.targetTableName;
                this.targetTableName = synonymTab;
                sdtc = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
                this.targetTableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sdtc);
                if (this.targetTableDescriptor == null) {
                    throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.targetTableName});
                }
            }
            this.targetTableName.setSchemaName(sdtc.getSchemaName());
            switch (this.targetTableDescriptor.getTableType()) {
                case 2: {
                    throw StandardException.newException((String)"42Y24", (Object[])new Object[]{this.targetTableName});
                }
                case 1: 
                case 5: {
                    throw StandardException.newException((String)"42Y25", (Object[])new Object[]{this.targetTableName});
                }
            }
            this.targetTableDescriptor = this.lockTableForCompilation(this.targetTableDescriptor);
            this.getCompilerContext().createDependency(this.targetTableDescriptor);
        } else {
            FromList dummyFromList = new FromList(this.getContextManager());
            this.targetVTI = (FromVTI)this.targetVTI.bindNonVTITables(dataDictionary, dummyFromList);
            this.targetVTI = (FromVTI)this.targetVTI.bindVTITables(dummyFromList);
        }
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    SchemaDescriptor getSchemaDescriptor() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
        return sd;
    }

    static int[] getReadColMap(int column_map_length, FormatableBitSet readColsBitSet) {
        if (readColsBitSet == null) {
            return null;
        }
        int partial_col_cnt = 0;
        int[] column_map = new int[column_map_length];
        int readColsBitSetSize = readColsBitSet.size();
        for (int base_index = 0; base_index < column_map.length; ++base_index) {
            column_map[base_index] = readColsBitSetSize > base_index && readColsBitSet.get(base_index + 1) ? partial_col_cnt++ : -1;
        }
        return column_map;
    }

    protected void getResultColumnList() throws StandardException {
        if (this.targetVTI == null) {
            this.getResultColumnList(null);
        } else {
            this.resultColumnList = this.targetVTI.getResultColumns();
        }
    }

    protected FromBaseTable getResultColumnList(ResultColumnList inputRcl) throws StandardException {
        FromBaseTable fbt = new FromBaseTable(this.synonymTableName != null ? this.synonymTableName : this.targetTableName, null, null, null, this.getContextManager());
        if (this.inMatchingClause()) {
            fbt.setMergeTableID(2);
        }
        fbt.bindNonVTITables(this.getDataDictionary(), new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getResultColumnList(fbt, inputRcl);
        return fbt;
    }

    private void getResultColumnList(FromBaseTable fromBaseTable, ResultColumnList inputRcl) throws StandardException {
        if (inputRcl == null) {
            this.resultColumnList = fromBaseTable.getAllResultColumns(null);
            this.resultColumnList.bindResultColumnsByPosition(this.targetTableDescriptor);
        } else {
            this.resultColumnList = fromBaseTable.getResultColumnsForList(null, inputRcl, fromBaseTable.getTableNameField());
            this.resultColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseAndBindGenerationClauses(DataDictionary dataDictionary, TableDescriptor targetTableDescriptor, ResultColumnList sourceRCL, ResultColumnList targetRCL, boolean forUpdate, ResultSetNode updateResultSet) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int count = targetRCL.size();
        for (int i = 0; i < count; ++i) {
            ResultColumn rc = (ResultColumn)targetRCL.elementAt(i);
            if (forUpdate && !rc.updated() || !rc.hasGenerationClause()) continue;
            ColumnDescriptor colDesc = rc.getTableColumnDescriptor();
            DataTypeDescriptor dtd = colDesc.getType();
            DefaultInfo di = colDesc.getDefaultInfo();
            ValueNode generationClause = this.parseGenerationClause(di.getDefaultText(), targetTableDescriptor);
            generationClause = new CastNode(generationClause, dtd, this.getContextManager());
            ((CastNode)generationClause).setAssignmentSemantics();
            compilerContext.pushCompilationSchema(this.getSchemaDescriptor(di.getOriginalCurrentSchema(), false));
            try {
                DMLModStatementNode.bindRowScopedExpression(this.getOptimizerFactory(), this.getContextManager(), targetTableDescriptor, sourceRCL, generationClause);
            }
            finally {
                compilerContext.popCompilationSchema();
            }
            ResultColumn newRC = new ResultColumn(generationClause.getTypeServices(), generationClause, this.getContextManager());
            newRC.setVirtualColumnId(i + 1);
            newRC.setColumnDescriptor(targetTableDescriptor, colDesc);
            targetRCL.setElementAt(newRC, i);
            if (!forUpdate) continue;
            for (int j = 0; j < sourceRCL.size(); ++j) {
                if (rc != sourceRCL.elementAt(j)) continue;
                newRC.setName(rc.getName());
                newRC.setResultSetNumber(updateResultSet.getResultSetNumber());
                sourceRCL.setElementAt(newRC, j);
            }
        }
    }

    public ValueNode parseGenerationClause(String clauseText, TableDescriptor td) throws StandardException {
        CursorNode cn;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        String select = "SELECT " + clauseText + " FROM " + td.getQualifiedName();
        CompilerContext newCC = lcc.pushCompilerContext();
        Parser p = newCC.getParser();
        Visitable qt = p.parseStatement(select);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof SelectNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof SelectNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode clauseTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return clauseTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueNode bindConstraints(DataDictionary dataDictionary, OptimizerFactory optimizerFactory, TableDescriptor targetTableDescriptor, Dependent dependent, ResultColumnList sourceRCL, int[] changedColumnIds, FormatableBitSet readColsBitSet, boolean includeTriggers, boolean[] hasDeferrableCheckConstraints) throws StandardException {
        block7: {
            this.bound = true;
            if (this.targetVTI != null) {
                return null;
            }
            CompilerContext compilerContext = this.getCompilerContext();
            compilerContext.pushCurrentPrivType(-1);
            try {
                this.getAllRelevantConstraints(dataDictionary, targetTableDescriptor, changedColumnIds);
                this.createConstraintDependencies(dataDictionary, this.relevantCdl, dependent);
                this.generateFKInfo(this.relevantCdl, dataDictionary, targetTableDescriptor, readColsBitSet);
                this.getAllRelevantTriggers(dataDictionary, targetTableDescriptor, changedColumnIds, includeTriggers);
                this.createTriggerDependencies(this.relevantTriggers, dependent);
                this.generateTriggerInfo(this.relevantTriggers);
                this.checkConstraints = this.generateCheckTree(this.relevantCdl, targetTableDescriptor, hasDeferrableCheckConstraints);
                if (this.checkConstraints == null) break block7;
                SchemaDescriptor originalCurrentSchema = targetTableDescriptor.getSchemaDescriptor();
                compilerContext.pushCompilationSchema(originalCurrentSchema);
                try {
                    DMLModStatementNode.bindRowScopedExpression(optimizerFactory, this.getContextManager(), targetTableDescriptor, sourceRCL, this.checkConstraints);
                }
                finally {
                    compilerContext.popCompilationSchema();
                }
            }
            finally {
                compilerContext.popCurrentPrivType();
            }
        }
        return this.checkConstraints;
    }

    static void bindRowScopedExpression(OptimizerFactory optimizerFactory, ContextManager cm, TableDescriptor targetTableDescriptor, ResultColumnList sourceRCL, ValueNode expression) throws StandardException {
        TableName targetTableName = DMLModStatementNode.makeTableName(cm, targetTableDescriptor.getSchemaName(), targetTableDescriptor.getName());
        FromList fakeFromList = new FromList(optimizerFactory.doJoinOrderOptimization(), cm);
        FromBaseTable table = new FromBaseTable(targetTableName, null, sourceRCL, null, cm);
        table.setTableNumber(0);
        fakeFromList.addFromTable(table);
        expression.bindExpression(fakeFromList, null, null);
    }

    protected boolean hasCheckConstraints(DataDictionary dd, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        if (cdl == null) {
            return false;
        }
        ConstraintDescriptorList ccCDL = cdl.getSubList(4);
        return ccCDL.size() > 0;
    }

    protected boolean hasGenerationClauses(TableDescriptor td) throws StandardException {
        ColumnDescriptorList list = td.getGeneratedColumns();
        return list.size() > 0;
    }

    private ValueNode generateCheckTree(ConstraintDescriptorList cdl, TableDescriptor td, boolean[] hasDeferrable) throws StandardException {
        ConstraintDescriptorList ccCDL = cdl.getSubList(4);
        int ccCDLSize = ccCDL.size();
        OperatorNode checkTree = null;
        for (ConstraintDescriptor cd : ccCDL) {
            if (!cd.deferrable()) continue;
            hasDeferrable[0] = true;
            break;
        }
        for (int index = 0; index < ccCDLSize; ++index) {
            ConstraintDescriptor cd;
            cd = ccCDL.elementAt(index);
            String constraintText = cd.getConstraintText();
            ValueNode oneConstraint = this.parseCheckConstraint(constraintText, td);
            TestConstraintNode tcn = new TestConstraintNode(oneConstraint, "23513", td.getQualifiedName(), cd, this.getContextManager());
            checkTree = checkTree == null ? tcn : (hasDeferrable[0] ? new AndNoShortCircuitNode(tcn, checkTree, this.getContextManager()) : new AndNode(tcn, checkTree, this.getContextManager()));
        }
        return checkTree;
    }

    private void generateFKInfo(ConstraintDescriptorList cdl, DataDictionary dd, TableDescriptor td, FormatableBitSet readColsBitSet) throws StandardException {
        int size;
        ArrayList<FKInfo> fkList = new ArrayList<FKInfo>();
        ConstraintDescriptorList activeList = dd.getActiveConstraintDescriptors(cdl);
        int[] rowMap = this.getRowMap(readColsBitSet, td);
        ArrayList<String> refSchemaNames = new ArrayList<String>(1);
        ArrayList<String> refTableNames = new ArrayList<String>(1);
        ArrayList<Long> refIndexConglomNum = new ArrayList<Long>(1);
        ArrayList<Integer> refActions = new ArrayList<Integer>(1);
        ArrayList<ColumnDescriptorList> refColDescriptors = new ArrayList<ColumnDescriptorList>(1);
        ArrayList<int[]> fkColMap = new ArrayList<int[]>(1);
        int activeSize = activeList.size();
        for (int index = 0; index < activeSize; ++index) {
            int[] raRules;
            boolean[] isSelfReferencingFK;
            String[] fkNames;
            long[] conglomNumbers;
            UUID[] fkIds;
            boolean[] deferrable;
            UUID[] uuids;
            ReferencedKeyConstraintDescriptor refcd;
            int type;
            ConstraintDescriptor cd = activeList.elementAt(index);
            if (cd instanceof ForeignKeyConstraintDescriptor) {
                type = 1;
                refcd = ((ForeignKeyConstraintDescriptor)cd).getReferencedConstraint();
                uuids = new UUID[1];
                deferrable = new boolean[1];
                fkIds = new UUID[1];
                conglomNumbers = new long[1];
                fkNames = new String[1];
                isSelfReferencingFK = new boolean[1];
                raRules = new int[1];
                this.fkSetupArrays(dd, (ForeignKeyConstraintDescriptor)cd, 0, uuids, conglomNumbers, fkNames, isSelfReferencingFK, raRules, deferrable, fkIds);
                fkNames[0] = cd.getConstraintName();
            } else {
                if (!(cd instanceof ReferencedKeyConstraintDescriptor)) continue;
                refcd = (ReferencedKeyConstraintDescriptor)cd;
                type = 2;
                ConstraintDescriptorList fkcdl = dd.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(1));
                int size2 = fkcdl.size();
                if (size2 == 0) continue;
                uuids = new UUID[size2];
                deferrable = new boolean[size2];
                fkIds = new UUID[size2];
                fkNames = new String[size2];
                conglomNumbers = new long[size2];
                isSelfReferencingFK = new boolean[size2];
                raRules = new int[size2];
                int[] colArray = this.remapReferencedColumns(cd, rowMap);
                for (int inner = 0; inner < size2; ++inner) {
                    ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)fkcdl.elementAt(inner);
                    this.fkSetupArrays(dd, fkcd, inner, uuids, conglomNumbers, fkNames, isSelfReferencingFK, raRules, deferrable, fkIds);
                    if (raRules[inner] != 0 && raRules[inner] != 3) continue;
                    TableDescriptor fktd = fkcd.getTableDescriptor();
                    refSchemaNames.add(fktd.getSchemaName());
                    refTableNames.add(fktd.getName());
                    refActions.add(raRules[inner]);
                    int[] refColumns = fkcd.getReferencedColumns();
                    ColumnDescriptorList coldl = fktd.getColumnDescriptorList();
                    ColumnDescriptorList releventColDes = new ColumnDescriptorList();
                    for (int i = 0; i < refColumns.length; ++i) {
                        ColumnDescriptor cold = coldl.elementAt(refColumns[i] - 1);
                        releventColDes.add(cold);
                    }
                    refColDescriptors.add(releventColDes);
                    refIndexConglomNum.add(conglomNumbers[inner]);
                    fkColMap.add(colArray);
                }
            }
            TableDescriptor pktd = refcd.getTableDescriptor();
            UUID pkIndexId = refcd.getIndexId();
            ConglomerateDescriptor pkIndexConglom = pktd.getConglomerateDescriptor(pkIndexId);
            TableDescriptor refTd = cd.getTableDescriptor();
            fkList.add(new FKInfo(fkNames, cd.getSchemaDescriptor().getSchemaName(), refTd.getName(), this.statementType, type, pkIndexId, pkIndexConglom.getConglomerateNumber(), refcd.getUUID(), refcd.deferrable(), uuids, conglomNumbers, isSelfReferencingFK, this.remapReferencedColumns(cd, rowMap), dd.getRowLocationTemplate(this.getLanguageConnectionContext(), refTd), raRules, deferrable, fkIds));
        }
        if (!fkList.isEmpty()) {
            this.fkInfo = fkList.toArray(new FKInfo[fkList.size()]);
        }
        if ((size = refActions.size()) > 0) {
            this.fkTableNames = new String[size];
            this.fkSchemaNames = new String[size];
            this.fkRefActions = new int[size];
            this.fkColDescriptors = new ColumnDescriptorList[size];
            this.fkIndexConglomNumbers = new long[size];
            this.fkColArrays = new int[size][];
            for (int i = 0; i < size; ++i) {
                this.fkTableNames[i] = (String)refTableNames.get(i);
                this.fkSchemaNames[i] = (String)refSchemaNames.get(i);
                this.fkRefActions[i] = (Integer)refActions.get(i);
                this.fkColDescriptors[i] = (ColumnDescriptorList)refColDescriptors.get(i);
                this.fkIndexConglomNumbers[i] = (Long)refIndexConglomNum.get(i);
                this.fkColArrays[i] = (int[])fkColMap.get(i);
            }
        }
    }

    private void fkSetupArrays(DataDictionary dd, ForeignKeyConstraintDescriptor fkcd, int index, UUID[] uuids, long[] conglomNumbers, String[] fkNames, boolean[] isSelfReferencingFK, int[] raRules, boolean[] isDeferrable, UUID[] fkIds) throws StandardException {
        fkNames[index] = fkcd.getConstraintName();
        uuids[index] = fkcd.getIndexId();
        isDeferrable[index] = fkcd.deferrable();
        fkIds[index] = fkcd.getUUID();
        conglomNumbers[index] = fkcd.getIndexConglomerateDescriptor(dd).getConglomerateNumber();
        isSelfReferencingFK[index] = fkcd.isSelfReferencingFK();
        if (this.statementType == 4) {
            raRules[index] = fkcd.getRaDeleteRule();
        } else if (this.statementType == 3) {
            raRules[index] = fkcd.getRaUpdateRule();
        }
    }

    private void generateTriggerInfo(TriggerDescriptorList triggerList) {
        if (triggerList != null && !triggerList.isEmpty()) {
            this.triggerInfo = new TriggerInfo(triggerList);
        }
    }

    FKInfo[] getFKInfo() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access FKInfo before binding");
        return this.fkInfo;
    }

    TriggerInfo getTriggerInfo() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access TriggerInfo before binding");
        return this.triggerInfo;
    }

    ValueNode getCheckConstraints() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access FKInfo before binding");
        return this.checkConstraints;
    }

    private void createTriggerDependencies(TriggerDescriptorList tdl, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        for (TriggerDescriptor td : tdl) {
            if (dependent == null) {
                compilerContext.createDependency(td);
                continue;
            }
            compilerContext.createDependency(dependent, td);
        }
    }

    protected TriggerDescriptorList getAllRelevantTriggers(DataDictionary dd, TableDescriptor td, int[] changedColumnIds, boolean includeTriggers) throws StandardException {
        if (this.relevantTriggers != null) {
            return this.relevantTriggers;
        }
        this.relevantTriggers = new TriggerDescriptorList();
        if (!includeTriggers) {
            return this.relevantTriggers;
        }
        td.getAllRelevantTriggers(this.statementType, changedColumnIds, this.relevantTriggers);
        this.adjustDeferredFlag(this.relevantTriggers.size() > 0);
        return this.relevantTriggers;
    }

    protected void adjustDeferredFlag(boolean adjustment) {
        if (!this.requiresDeferredProcessing) {
            this.requiresDeferredProcessing = adjustment;
        }
    }

    private void createConstraintDependencies(DataDictionary dd, ConstraintDescriptorList cdl, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (dependent == null) {
                compilerContext.createDependency(cd);
            } else {
                compilerContext.createDependency(dependent, cd);
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                ConstraintDescriptorList fkcdl = dd.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(1));
                int fklSize = fkcdl.size();
                for (int inner = 0; inner < fklSize; ++inner) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(inner);
                    if (dependent == null) {
                        compilerContext.createDependency(fkcd);
                        compilerContext.createDependency(fkcd.getTableDescriptor());
                        continue;
                    }
                    compilerContext.createDependency(dependent, fkcd);
                    compilerContext.createDependency(dependent, fkcd.getTableDescriptor());
                }
                continue;
            }
            if (!(cd instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cd;
            if (dependent == null) {
                compilerContext.createDependency(fkcd.getReferencedConstraint().getTableDescriptor());
                continue;
            }
            compilerContext.createDependency(dependent, fkcd.getReferencedConstraint().getTableDescriptor());
        }
    }

    protected ConstraintDescriptorList getAllRelevantConstraints(DataDictionary dd, TableDescriptor td, int[] changedColumnIds) throws StandardException {
        if (this.relevantCdl != null) {
            return this.relevantCdl;
        }
        boolean[] needsDeferredProcessing = new boolean[1];
        this.relevantCdl = new ConstraintDescriptorList();
        needsDeferredProcessing[0] = this.requiresDeferredProcessing;
        td.getAllRelevantConstraints(this.statementType, changedColumnIds, needsDeferredProcessing, this.relevantCdl);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return this.relevantCdl;
    }

    boolean requiresDeferredProcessing() {
        return this.requiresDeferredProcessing;
    }

    public ValueNode parseCheckConstraint(String checkConstraintText, TableDescriptor td) throws StandardException {
        CursorNode cn;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        String select = "SELECT * FROM " + td.getQualifiedName() + " WHERE " + checkConstraintText;
        CompilerContext newCC = lcc.pushCompilerContext();
        Parser p = newCC.getParser();
        Visitable qt = p.parseStatement(select);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof SelectNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof SelectNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode checkTree = ((SelectNode)((CursorNode)qt).getResultSetNode()).getWhereClause();
        lcc.popCompilerContext(newCC);
        return checkTree;
    }

    public void generateCheckConstraints(ValueNode checkConstraints, ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        if (checkConstraints == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = this.generateCheckConstraints(checkConstraints, ecb);
            ecb.pushMethodReference(mb, userExprFun);
        }
    }

    public MethodBuilder generateCheckConstraints(ValueNode checkConstraints, ExpressionClassBuilder ecb) throws StandardException {
        MethodBuilder userExprFun = ecb.newUserExprFun();
        checkConstraints.generateExpression(ecb, userExprFun);
        userExprFun.methodReturn();
        userExprFun.complete();
        return userExprFun;
    }

    public void generateGenerationClauses(ResultColumnList rcl, int resultSetNumber, boolean isUpdate, ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        boolean hasGenerationClauses = false;
        for (ResultColumn rc : rcl) {
            if (!rc.hasGenerationClause()) continue;
            hasGenerationClauses = true;
            break;
        }
        if (!hasGenerationClauses) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = this.generateGenerationClauses(rcl, resultSetNumber, isUpdate, ecb);
            ecb.pushMethodReference(mb, userExprFun);
        }
    }

    private MethodBuilder generateGenerationClauses(ResultColumnList rcl, int rsNumber, boolean isUpdate, ExpressionClassBuilder ecb) throws StandardException {
        MethodBuilder userExprFun = ecb.newUserExprFun();
        userExprFun.pushThis();
        userExprFun.push(rsNumber);
        userExprFun.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getCurrentRow", "org.apache.derby.iapi.sql.Row", 1);
        int size = rcl.size();
        int startColumn = 0;
        if (isUpdate) {
            startColumn = size - 1;
            startColumn /= 2;
        }
        for (int i = startColumn; i < size; ++i) {
            ResultColumn rc = (ResultColumn)rcl.elementAt(i);
            if (!rc.hasGenerationClause()) continue;
            userExprFun.dup();
            userExprFun.push(i + 1);
            if (this.inMatchingClause()) {
                CollectNodesVisitor<ColumnReference> getCRs = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                rc.accept(getCRs);
                for (ColumnReference cr : getCRs.getList()) {
                    cr.getSource().setResultSetNumber(rsNumber);
                }
            }
            rc.generateExpression(ecb, userExprFun);
            userExprFun.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        userExprFun.methodReturn();
        userExprFun.complete();
        return userExprFun;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        if (!this.inMatchingClause()) {
            super.optimizeStatement();
        } else if (this instanceof UpdateNode) {
            this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        }
        this.lockMode = 6;
    }

    protected void getAffectedIndexes(TableDescriptor td, ResultColumnList updatedColumns, FormatableBitSet colBitSet) throws StandardException {
        ArrayList<ConglomerateDescriptor> conglomerates = new ArrayList<ConglomerateDescriptor>();
        DMLModStatementNode.getXAffectedIndexes(td, updatedColumns, colBitSet, conglomerates);
        this.markAffectedIndexes(conglomerates);
    }

    static void getXAffectedIndexes(TableDescriptor baseTable, ResultColumnList updatedColumns, FormatableBitSet colBitSet, List<ConglomerateDescriptor> conglomerates) throws StandardException {
        ConglomerateDescriptor[] cds = baseTable.getConglomerateDescriptors();
        long[] distinctConglomNums = new long[cds.length - 1];
        int distinctCount = 0;
        for (int index = 0; index < cds.length; ++index) {
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || updatedColumns != null && !updatedColumns.updateOverlaps(cd.getIndexDescriptor().baseColumnPositions())) continue;
            if (conglomerates != null) {
                int i;
                for (i = 0; i < distinctCount && distinctConglomNums[i] != cd.getConglomerateNumber(); ++i) {
                }
                if (i == distinctCount) {
                    distinctConglomNums[distinctCount++] = cd.getConglomerateNumber();
                    conglomerates.add(cd);
                }
            }
            IndexRowGenerator ixd = cd.getIndexDescriptor();
            int[] cols = ixd.baseColumnPositions();
            if (colBitSet == null) continue;
            for (int i = 0; i < cols.length; ++i) {
                colBitSet.set(cols[i]);
            }
        }
    }

    protected void markAffectedIndexes(List<ConglomerateDescriptor> affectedConglomerates) throws StandardException {
        int indexCount = affectedConglomerates.size();
        CompilerContext cc = this.getCompilerContext();
        this.indicesToMaintain = new IndexRowGenerator[indexCount];
        this.indexConglomerateNumbers = new long[indexCount];
        this.indexNames = new String[indexCount];
        for (int ictr = 0; ictr < indexCount; ++ictr) {
            ConglomerateDescriptor cd = affectedConglomerates.get(ictr);
            this.indicesToMaintain[ictr] = cd.getIndexDescriptor();
            this.indexConglomerateNumbers[ictr] = cd.getConglomerateNumber();
            this.indexNames[ictr] = cd.isConstraint() ? null : cd.getConglomerateName();
            cc.createDependency(cd);
        }
    }

    @Override
    String statementToString() {
        return "DML MOD";
    }

    private int[] remapReferencedColumns(ConstraintDescriptor cd, int[] rowMap) {
        int[] oldCols = cd.getReferencedColumns();
        if (rowMap == null) {
            return oldCols;
        }
        int[] newCols = new int[oldCols.length];
        for (int i = 0; i < oldCols.length; ++i) {
            newCols[i] = rowMap[oldCols[i]];
            SanityManager.ASSERT((newCols[i] != 0 ? 1 : 0) != 0, (String)("attempt to map a column " + oldCols[i] + " which is not in our new column map.  Something is wrong with the logic to do partial reads for an update stmt"));
        }
        return newCols;
    }

    private int[] getRowMap(FormatableBitSet bitSet, TableDescriptor td) throws StandardException {
        if (bitSet == null) {
            return null;
        }
        int size = td.getMaxColumnID();
        int[] iArray = new int[size + 1];
        int j = 1;
        for (int i = 1; i <= size; ++i) {
            if (!bitSet.get(i)) continue;
            iArray[i] = j++;
        }
        return iArray;
    }

    @Override
    void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.resultSet.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    void normalizeSynonymColumns(ResultColumnList rcl, TableName targetTableName) throws StandardException {
        if (this.synonymTableName == null) {
            return;
        }
        String synTableName = this.synonymTableName.getTableName();
        for (ResultColumn rc : rcl) {
            String crTableName;
            ColumnReference reference = rc.getReference();
            if (reference == null || (crTableName = reference.getTableName()) == null) continue;
            if (synTableName.equals(crTableName)) {
                reference.setQualifiedTableName(targetTableName);
                continue;
            }
            throw StandardException.newException((String)"42X55", (Object[])new Object[]{synTableName, crTableName});
        }
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
        if (this.resultColumnList != null) {
            this.printLabel(depth, "resultColumnList: ");
            this.resultColumnList.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.targetTableName != null) {
            this.targetTableName = (TableName)this.targetTableName.accept(v);
        }
        if (this.synonymTableName != null) {
            this.synonymTableName = (TableName)this.synonymTableName.accept(v);
        }
    }
}

