/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::Namespace"})
public class XmlNamespace
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private Attr attr;
    private transient IRubyObject prefixRuby;
    private transient IRubyObject hrefRuby;
    private String prefix;
    private String href;

    public XmlNamespace(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    XmlNamespace(Ruby ruby, Attr attr, String string, String string2, IRubyObject iRubyObject) {
        this(ruby, attr, string, null, string2, null, iRubyObject);
    }

    private XmlNamespace(Ruby ruby, Attr attr, String string, IRubyObject iRubyObject, String string2, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        super(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Namespace"));
        this.attr = attr;
        this.prefix = string;
        this.href = string2;
        this.prefixRuby = iRubyObject;
        this.hrefRuby = iRubyObject2;
        this.setInstanceVariable("@document", iRubyObject3);
    }

    public Node getNode() {
        return this.attr;
    }

    public String getPrefix() {
        return this.prefix;
    }

    boolean hasPrefix(String string) {
        return string == null ? this.prefix == null : string.equals(this.prefix);
    }

    public String getHref() {
        return this.href;
    }

    public static XmlNamespace createFromAttr(Ruby ruby, Attr attr) {
        String string = NokogiriHelpers.getLocalNameForNamespace(attr.getName(), null);
        IRubyObject iRubyObject = string == null ? ruby.getNil() : null;
        String string2 = attr.getValue();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, attr.getOwnerDocument());
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string, string2);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        xmlNamespace = new XmlNamespace(ruby, attr, string, iRubyObject, string2, null, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace, attr.getOwnerElement());
        return xmlNamespace;
    }

    static XmlNamespace createImpl(Node node, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, String string2) {
        Ruby ruby = iRubyObject.getRuntime();
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, document);
        assert (xmlDocument.getNamespaceCache().get(string, string2) == null);
        String string3 = "xmlns";
        if (string != null && !string.isEmpty()) {
            string3 = string3 + ':' + string;
        }
        Attr attr = document.createAttribute(string3);
        attr.setNodeValue(string2);
        XmlNamespace xmlNamespace = new XmlNamespace(ruby, attr, string, iRubyObject, string2, iRubyObject2, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace, node);
        return xmlNamespace;
    }

    public static XmlNamespace createDefaultNamespace(Ruby ruby, Node node) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, node.getOwnerDocument());
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string, string2);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        xmlNamespace = new XmlNamespace(ruby, (Attr)node, string, string2, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace, node);
        return xmlNamespace;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this.prefix == null && this.href == null;
    }

    @JRubyMethod
    public IRubyObject href(ThreadContext threadContext) {
        if (this.hrefRuby == null) {
            if (this.href == null) {
                this.hrefRuby = threadContext.nil;
                return this.hrefRuby;
            }
            this.hrefRuby = threadContext.runtime.newString(this.href);
            return this.hrefRuby;
        }
        return this.hrefRuby;
    }

    @JRubyMethod
    public IRubyObject prefix(ThreadContext threadContext) {
        if (this.prefixRuby == null) {
            if (this.prefix == null) {
                this.prefixRuby = threadContext.nil;
                return this.prefixRuby;
            }
            this.prefixRuby = threadContext.runtime.newString(this.prefix);
            return this.prefixRuby;
        }
        return this.prefixRuby;
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        String string;
        String string2 = this.prefix;
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.href) == null) {
            string = "";
        }
        String string3 = ' ' + string2 + '=' + '\"' + string + '\"';
        saveContextVisitor.enter(string3);
        saveContextVisitor.leave(string3);
    }
}

