/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultTlsDHGroupVerifier
implements TlsDHGroupVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    private static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dHGroup) {
        DEFAULT_GROUPS.addElement(dHGroup);
    }

    public DefaultTlsDHGroupVerifier() {
        this(2048);
    }

    public DefaultTlsDHGroupVerifier(int n) {
        this(DEFAULT_GROUPS, n);
    }

    public DefaultTlsDHGroupVerifier(Vector vector, int n) {
        this.groups = new Vector(vector);
        this.minimumPrimeBits = n;
    }

    @Override
    public boolean accept(DHGroup dHGroup) {
        return this.checkMinimumPrimeBits(dHGroup) && this.checkGroup(dHGroup);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup dHGroup, DHGroup dHGroup2) {
        return dHGroup == dHGroup2 || this.areParametersEqual(dHGroup.getP(), dHGroup2.getP()) && this.areParametersEqual(dHGroup.getG(), dHGroup2.getG());
    }

    protected boolean areParametersEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger == bigInteger2 || bigInteger.equals(bigInteger2);
    }

    protected boolean checkGroup(DHGroup dHGroup) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dHGroup, (DHGroup)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(DHGroup dHGroup) {
        return dHGroup.getP().bitLength() >= this.getMinimumPrimeBits();
    }

    static {
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
    }
}

