/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class SetSchemaNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    SetSchemaNode(String schemaName, int type, ContextManager cm) {
        super(cm);
        this.name = schemaName;
        this.type = type;
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.type == 1 ? "schemaName: \nUSER\n" : (this.type == 2 ? "schemaName: \n?\n" : "schemaName: \n" + this.name + "\n"));
    }

    @Override
    String statementToString() {
        return "SET SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetSchemaConstantAction(this.name, this.type);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.type == 2) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getMiscResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        List<ParameterNode> parameterList = this.getCompilerContext().getParameterList();
        SanityManager.ASSERT((parameterList != null && parameterList.size() == 1 ? 1 : 0) != 0);
        ParameterNode.generateParameterValueSet(acb, 1, parameterList);
    }

    @Override
    int activationKind() {
        if (this.type == 2) {
            return 2;
        }
        return 0;
    }
}

