/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.mac;

import java.io.DataInput;
import java.io.IOException;

public class ResourceReference {
    private int id;
    private short nameOffset;
    private short attributes;
    private int dataOffset;
    private int handle;
    private String name;

    ResourceReference(DataInput dataInput) throws IOException {
        this.id = dataInput.readUnsignedShort();
        this.nameOffset = dataInput.readShort();
        this.attributes = (short)dataInput.readUnsignedByte();
        this.dataOffset = dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedShort();
        this.handle = dataInput.readInt();
    }

    void readName(DataInput dataInput) throws IOException {
        if (this.nameOffset > -1) {
            int n = dataInput.readUnsignedByte();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            this.name = new String(byArray);
        }
    }

    public int getId() {
        return this.id;
    }

    public short getNameOffset() {
        return this.nameOffset;
    }

    public short getAttributes() {
        return this.attributes;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getHandle() {
        return this.handle;
    }

    public String getName() {
        return this.name;
    }
}

