/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.FreeColDialog;

public final class SaveDialog
extends FreeColDialog<File> {
    private static final File cancelFile = new File(".");

    public SaveDialog(FreeColClient freeColClient, JFrame frame, File directory, FileFilter[] fileFilters, String defaultName) {
        super(freeColClient, frame);
        JFileChooser fileChooser = new JFileChooser(directory);
        if (fileFilters.length > 0) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setDialogType(1);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setSelectedFile(new File(defaultName));
        fileChooser.addActionListener(ae -> this.setValue("ApproveSelection".equals(ae.getActionCommand()) ? fileChooser.getSelectedFile() : cancelFile));
        List c = SaveDialog.choices();
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, fileChooser, null, c);
    }

    @Override
    public File getResponse() {
        if (this.responded()) {
            File value = (File)this.getValue();
            return value == cancelFile ? null : value;
        }
        return null;
    }
}

