/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.CellTower;
import org.traccar.model.Command;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class RfTrackProtocolDecoder
extends BaseHttpProtocolDecoder {
    public RfTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.content().toString(StandardCharsets.US_ASCII), false);
        Map params = decoder.parameters();
        Position position = new Position(this.getProtocolName());
        Network network = new Network();
        for (Map.Entry entry : params.entrySet()) {
            block35: for (String value : (List)entry.getValue()) {
                switch ((String)entry.getKey()) {
                    case "i": {
                        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                        if (deviceSession == null) {
                            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                            return null;
                        }
                        position.setDeviceId(deviceSession.getDeviceId());
                        break;
                    }
                    case "v": {
                        position.set("versionFw", value);
                        break;
                    }
                    case "t": {
                        position.setDeviceTime(new Date(Long.parseLong(value)));
                        break;
                    }
                    case "bat": {
                        int battery = Integer.parseInt(value);
                        position.set("batteryLevel", battery & 0xFF);
                        position.set("plugStatus", battery >> 8 & 0xF);
                        position.set("charge", (battery >> 12 & 0xF) == 1);
                        break;
                    }
                    case "id": {
                        position.set("braceletId", value);
                        break;
                    }
                    case "rc": {
                        int braceletCode = Integer.parseInt(value);
                        position.set("braceletCode", braceletCode & 0xFFFF);
                        position.set("braceletStatus", braceletCode >> 16);
                        break;
                    }
                    case "idt": {
                        long braceletTime = Long.parseLong(value);
                        position.set("lastHeartbeat", (braceletTime >> 45) * 10L);
                        position.set("lastPaired", (braceletTime >> 30 & 0xFFFFL) * 10L);
                        position.set("lastUnpaired", (braceletTime >> 15 & 0xFFFFL) * 10L);
                        break;
                    }
                    case "mt": {
                        int vibrationTime = Integer.parseInt(value);
                        position.set("vibrationDevice", (vibrationTime & Short.MAX_VALUE) * 10);
                        position.set("vibrationBracelet", (vibrationTime >> 15) * 10);
                        break;
                    }
                    case "gps": {
                        JsonObject location = Json.createReader((Reader)new StringReader(value)).readObject();
                        position.setValid(true);
                        position.setAccuracy(location.getJsonNumber("a").doubleValue());
                        position.setLongitude(location.getJsonNumber("x").doubleValue());
                        position.setLatitude(location.getJsonNumber("y").doubleValue());
                        position.setAltitude(location.getJsonNumber("z").doubleValue());
                        position.setFixTime(new Date(location.getJsonNumber("t").longValue()));
                        break;
                    }
                    case "gsm": {
                        JsonObject cellInfo = Json.createReader((Reader)new StringReader(value)).readObject();
                        int mcc = cellInfo.getInt("c");
                        int mnc = cellInfo.getInt("n");
                        JsonArray cells = cellInfo.getJsonArray("b");
                        for (int i = 0; i < cells.size(); ++i) {
                            JsonObject cell = cells.getJsonObject(i);
                            network.addCellTower(CellTower.from(mcc, mnc, cell.getInt("l"), cell.getInt("c"), cell.getInt("b")));
                        }
                        continue block35;
                    }
                    case "dbm": {
                        position.set("rssi", Integer.parseInt(value));
                        break;
                    }
                    case "bar": {
                        position.set("pressure", Double.parseDouble(value));
                        break;
                    }
                    case "cob": {
                        position.set("pressureChanges", value);
                        break;
                    }
                    case "wifi": {
                        JsonArray wifiInfo = Json.createReader((Reader)new StringReader(value)).readArray();
                        for (int i = 0; i < wifiInfo.size(); ++i) {
                            JsonObject wifi = wifiInfo.getJsonObject(i);
                            network.addWifiAccessPoint(WifiAccessPoint.from(wifi.getString("m").replace('-', ':'), wifi.getInt("l")));
                        }
                        continue block35;
                    }
                    case "u_ids": {
                        position.set("unpairedIds", value);
                        break;
                    }
                }
            }
        }
        if (position.getFixTime() == null) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        String response = "{}";
        for (Command command : this.getCommandsManager().readQueuedCommands(position.getDeviceId(), 1)) {
            response = command.getString("data");
        }
        this.sendResponse(channel, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.UTF_8));
        return position;
    }
}

