/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.gax.paging.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.OidcProviderConfig;
import com.google.firebase.auth.ProviderConfig;
import com.google.firebase.auth.SamlProviderConfig;
import com.google.firebase.auth.internal.ListOidcProviderConfigsResponse;
import com.google.firebase.auth.internal.ListProviderConfigsResponse;
import com.google.firebase.auth.internal.ListSamlProviderConfigsResponse;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ListProviderConfigsPage<T extends ProviderConfig>
implements Page<T> {
    static final String END_OF_LIST = "";
    private final ListProviderConfigsResponse<T> currentBatch;
    private final ProviderConfigSource<T> source;
    private final int maxResults;

    private ListProviderConfigsPage(@NonNull ListProviderConfigsResponse<T> currentBatch, @NonNull ProviderConfigSource<T> source, int maxResults) {
        this.currentBatch = (ListProviderConfigsResponse)Preconditions.checkNotNull(currentBatch);
        this.source = (ProviderConfigSource)Preconditions.checkNotNull(source);
        this.maxResults = maxResults;
    }

    public boolean hasNextPage() {
        return !END_OF_LIST.equals(this.currentBatch.getPageToken());
    }

    @NonNull
    public String getNextPageToken() {
        return this.currentBatch.getPageToken();
    }

    @Nullable
    public ListProviderConfigsPage<T> getNextPage() {
        if (this.hasNextPage()) {
            Factory<T> factory = new Factory<T>(this.source, this.maxResults, this.currentBatch.getPageToken());
            try {
                return factory.create();
            }
            catch (FirebaseAuthException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @NonNull
    public Iterable<T> iterateAll() {
        return new ProviderConfigIterable(this);
    }

    @NonNull
    public Iterable<T> getValues() {
        return this.currentBatch.getProviderConfigs();
    }

    static class Factory<T extends ProviderConfig> {
        private final ProviderConfigSource<T> source;
        private final int maxResults;
        private final String pageToken;

        Factory(@NonNull ProviderConfigSource<T> source) {
            this(source, 100, null);
        }

        Factory(@NonNull ProviderConfigSource<T> source, int maxResults, @Nullable String pageToken) {
            Preconditions.checkArgument((maxResults > 0 && maxResults <= 100 ? 1 : 0) != 0, (String)"maxResults must be a positive integer that does not exceed %s", (int)100);
            Preconditions.checkArgument((!ListProviderConfigsPage.END_OF_LIST.equals(pageToken) ? 1 : 0) != 0, (Object)"invalid end of list page token");
            this.source = (ProviderConfigSource)Preconditions.checkNotNull(source, (Object)"source must not be null");
            this.maxResults = maxResults;
            this.pageToken = pageToken;
        }

        ListProviderConfigsPage<T> create() throws FirebaseAuthException {
            ListProviderConfigsResponse<T> batch = this.source.fetch(this.maxResults, this.pageToken);
            return new ListProviderConfigsPage(batch, this.source, this.maxResults);
        }
    }

    static class DefaultSamlProviderConfigSource
    implements ProviderConfigSource<SamlProviderConfig> {
        private final FirebaseUserManager userManager;

        DefaultSamlProviderConfigSource(FirebaseUserManager userManager) {
            this.userManager = (FirebaseUserManager)Preconditions.checkNotNull((Object)userManager, (Object)"User manager must not be null.");
        }

        public ListSamlProviderConfigsResponse fetch(int maxResults, String pageToken) throws FirebaseAuthException {
            return this.userManager.listSamlProviderConfigs(maxResults, pageToken);
        }
    }

    static class DefaultOidcProviderConfigSource
    implements ProviderConfigSource<OidcProviderConfig> {
        private final FirebaseUserManager userManager;

        DefaultOidcProviderConfigSource(FirebaseUserManager userManager) {
            this.userManager = (FirebaseUserManager)Preconditions.checkNotNull((Object)userManager, (Object)"User manager must not be null.");
        }

        public ListOidcProviderConfigsResponse fetch(int maxResults, String pageToken) throws FirebaseAuthException {
            return this.userManager.listOidcProviderConfigs(maxResults, pageToken);
        }
    }

    static interface ProviderConfigSource<T extends ProviderConfig> {
        @NonNull
        public ListProviderConfigsResponse<T> fetch(int var1, String var2) throws FirebaseAuthException;
    }

    private static class ProviderConfigIterable<T extends ProviderConfig>
    implements Iterable<T> {
        private final ListProviderConfigsPage<T> startingPage;

        ProviderConfigIterable(@NonNull ListProviderConfigsPage<T> startingPage) {
            this.startingPage = (ListProviderConfigsPage)Preconditions.checkNotNull(startingPage, (Object)"starting page must not be null");
        }

        @Override
        @NonNull
        public Iterator<T> iterator() {
            return new ProviderConfigIterator(this.startingPage);
        }

        private static class ProviderConfigIterator<T extends ProviderConfig>
        implements Iterator<T> {
            private ListProviderConfigsPage<T> currentPage;
            private List<T> batch;
            private int index = 0;

            private ProviderConfigIterator(ListProviderConfigsPage<T> startingPage) {
                this.setCurrentPage(startingPage);
            }

            @Override
            public boolean hasNext() {
                if (this.index == this.batch.size()) {
                    if (this.currentPage.hasNextPage()) {
                        this.setCurrentPage((ListProviderConfigsPage<T>)this.currentPage.getNextPage());
                    } else {
                        return false;
                    }
                }
                return this.index < this.batch.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (T)((ProviderConfig)this.batch.get(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation not supported");
            }

            private void setCurrentPage(ListProviderConfigsPage<T> page) {
                this.currentPage = (ListProviderConfigsPage)Preconditions.checkNotNull(page);
                this.batch = ImmutableList.copyOf(page.getValues());
                this.index = 0;
            }
        }
    }
}

