/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Locale;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.mpx.LocaleData;

final class LocaleUtility {
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{new Locale("EN"), new Locale("DE"), new Locale("FR"), new Locale("IT"), new Locale("PT"), new Locale("SV"), new Locale("ZH"), new Locale("ES"), new Locale("RU")};

    private LocaleUtility() {
    }

    public static void setLocale(ProjectProperties projectProperties, Locale locale) {
        projectProperties.setMpxDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        projectProperties.setMpxProgramName(LocaleData.getString(locale, "PROGRAM_NAME"));
        projectProperties.setMpxCodePage((CodePage)((Object)LocaleData.getObject(locale, "CODE_PAGE")));
        projectProperties.setCurrencySymbol(LocaleData.getString(locale, "CURRENCY_SYMBOL"));
        projectProperties.setSymbolPosition((CurrencySymbolPosition)LocaleData.getObject(locale, "CURRENCY_SYMBOL_POSITION"));
        projectProperties.setCurrencyDigits(LocaleData.getInteger(locale, "CURRENCY_DIGITS"));
        projectProperties.setThousandsSeparator(LocaleData.getChar(locale, "CURRENCY_THOUSANDS_SEPARATOR"));
        projectProperties.setDecimalSeparator(LocaleData.getChar(locale, "CURRENCY_DECIMAL_SEPARATOR"));
        projectProperties.setDateOrder((DateOrder)LocaleData.getObject(locale, "DATE_ORDER"));
        projectProperties.setTimeFormat((ProjectTimeFormat)LocaleData.getObject(locale, "TIME_FORMAT"));
        projectProperties.setDefaultStartTime(DateHelper.getTimeFromMinutesPastMidnight(LocaleData.getInteger(locale, "DEFAULT_START_TIME")));
        projectProperties.setDateSeparator(LocaleData.getChar(locale, "DATE_SEPARATOR"));
        projectProperties.setTimeSeparator(LocaleData.getChar(locale, "TIME_SEPARATOR"));
        projectProperties.setAMText(LocaleData.getString(locale, "AM_TEXT"));
        projectProperties.setPMText(LocaleData.getString(locale, "PM_TEXT"));
        projectProperties.setDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        projectProperties.setBarTextDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }
}

