/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public class GradleAnnotationProcessorQueryImpl
implements AnnotationProcessingQueryImplementation {
    private static final SpecificationVersion VER16 = new SpecificationVersion("1.6");
    final Map<GradleJavaSourceSet, AnnotationProcessingQuery.Result> cache = new WeakHashMap<GradleJavaSourceSet, AnnotationProcessingQuery.Result>();
    final Project project;

    public GradleAnnotationProcessorQueryImpl(Project project) {
        this.project = project;
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        GradleJavaProject gjp;
        GradleJavaSourceSet ss;
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
        AnnotationProcessingQuery.Result ret = null;
        if (this.isJava16orLater(sourceLevel) && (ss = (gjp = GradleJavaProject.get(this.project)).containingSourceSet(FileUtil.toFile((FileObject)file))) != null && (ret = this.cache.get(ss)) == null) {
            ret = new GradleSourceSetResult(ss);
            this.cache.put(ss, ret);
        }
        return ret;
    }

    private boolean isJava16orLater(String sourceLevel) {
        return sourceLevel != null ? new SpecificationVersion(sourceLevel).compareTo(VER16) >= 0 : true;
    }

    private static class GradleSourceSetResult
    implements AnnotationProcessingQuery.Result {
        URL outputDir = null;
        List<String> annotationProcessors = null;
        boolean enabled = true;

        GradleSourceSetResult(GradleJavaSourceSet ss) {
            for (File dir : ss.getGeneratedSourcesDirs()) {
                if (!dir.getPath().contains("annotationProcessor")) continue;
                try {
                    this.outputDir = dir.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            Iterator<String> compilerArgs = ss.getCompilerArgs(GradleJavaSourceSet.SourceType.JAVA).iterator();
            while (compilerArgs.hasNext()) {
                String arg = compilerArgs.next();
                if ("-proc:none".equals(arg)) {
                    this.enabled = false;
                }
                if (!"-processor".equals(arg) || !compilerArgs.hasNext()) continue;
                if (this.annotationProcessors == null) {
                    this.annotationProcessors = new LinkedList<String>();
                }
                String[] processors = compilerArgs.next().split(",");
                this.annotationProcessors.addAll(Arrays.asList(processors));
            }
        }

        public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
            return this.enabled ? EnumSet.allOf(AnnotationProcessingQuery.Trigger.class) : EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
        }

        public Iterable<? extends String> annotationProcessorsToRun() {
            return this.annotationProcessors;
        }

        public URL sourceOutputDirectory() {
            return this.outputDir;
        }

        public Map<? extends String, ? extends String> processorOptions() {
            return Collections.emptyMap();
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

