/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.gradle.tooling.GradleConnector;
import org.netbeans.api.project.Project;

public final class GradleConnectorManager {
    private final Map<Project, GradleConnector> projectConnector = new WeakHashMap<Project, GradleConnector>();
    private final List<GradleConnector> connectors = new ArrayList<GradleConnector>();
    private static final GradleConnectorManager INSTANCE = new GradleConnectorManager();
    private static final Logger LOG = Logger.getLogger(GradleConnectorManager.class.getName());

    private GradleConnectorManager() {
    }

    public static GradleConnectorManager getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleConnector getConnector(Project prj) {
        List<GradleConnector> list = this.connectors;
        synchronized (list) {
            GradleConnector ret = this.projectConnector.computeIfAbsent(prj, p -> {
                GradleConnector conn = GradleConnector.newConnector();
                this.connectors.add(conn);
                return conn;
            });
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAll() {
        LOG.info("Disconnecting from Gradle Daemons.");
        List<GradleConnector> list = this.connectors;
        synchronized (list) {
            this.projectConnector.clear();
            this.connectors.forEach(GradleConnector::disconnect);
            this.connectors.clear();
        }
        LOG.info("Disconnecting from Gradle Daemons. Done.");
    }

    public static class DisconnectGradle
    implements Runnable {
        @Override
        public void run() {
            GradleConnectorManager.getDefault().disconnectAll();
        }
    }
}

