/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextExpression;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class CallNode
extends LexicalContextExpression {
    private final Expression function;
    private final List<Expression> args;
    private static final int IS_NEW = 1;
    private static final int IS_EVAL = 2;
    private final int flags;
    private final int lineNumber;
    private final boolean optional;

    public CallNode(int lineNumber, long token, int finish, Expression function, List<Expression> args, boolean isNew) {
        this(lineNumber, token, finish, function, args, isNew, false);
    }

    public CallNode(int lineNumber, long token, int finish, Expression function, List<Expression> args, boolean isNew, boolean optional) {
        super(token, finish);
        this.function = function;
        this.args = args;
        this.flags = isNew ? 1 : 0;
        this.lineNumber = lineNumber;
        this.optional = optional;
    }

    private CallNode(CallNode callNode, Expression function, List<Expression> args, int flags, boolean optional) {
        super(callNode);
        this.lineNumber = callNode.lineNumber;
        this.function = function;
        this.args = args;
        this.flags = flags;
        this.optional = optional;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        CallNode newCallNode;
        if (visitor.enterCallNode(this) && this != (newCallNode = (CallNode)visitor.leaveCallNode(this.setFunction((Expression)this.function.accept(visitor)).setArgs(Node.accept(visitor, this.args))))) {
            return Node.replaceInLexicalContext(lc, this, newCallNode);
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lc, TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterCallNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        StringBuilder fsb = new StringBuilder();
        this.function.toString(fsb, printType);
        sb.append((CharSequence)fsb);
        if (this.optional) {
            sb.append("?.");
        }
        sb.append('(');
        boolean first = true;
        for (Node node : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            node.toString(sb, printType);
        }
        sb.append(')');
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public CallNode setArgs(List<Expression> args) {
        if (this.args == args) {
            return this;
        }
        return new CallNode(this, this.function, args, this.flags, this.optional);
    }

    public boolean isEval() {
        return (this.flags & 2) != 0;
    }

    public CallNode setIsEval() {
        return this.setFlags(this.flags | 2);
    }

    public Expression getFunction() {
        return this.function;
    }

    public CallNode setFunction(Expression function) {
        if (this.function == function) {
            return this;
        }
        return new CallNode(this, function, this.args, this.flags, this.optional);
    }

    public boolean isNew() {
        return (this.flags & 1) != 0;
    }

    private CallNode setFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new CallNode(this, this.function, this.args, flags, this.optional);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public CallNode setOptional() {
        if (this.optional) {
            return this;
        }
        return new CallNode(this, this.function, this.args, this.flags, true);
    }
}

