/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.SemanticHighlighterBase;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightLayer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.loaders.DataObject;
import org.openide.util.Pair;

public class SemanticHighlighter
extends SemanticHighlighterBase {
    static SemanticHighlighterBase.ErrorDescriptionSetter ERROR_DESCRIPTION_SETTER = new SemanticHighlighterBase.ErrorDescriptionSetter(){

        public void setErrors(Document doc, List<ErrorDescription> errors, List<TreePathHandle> allUnusedImports) {
        }

        public void setHighlights(final Document doc, final Collection<Pair<int[], ColoringAttributes.Coloring>> highlights, final Map<int[], String> preText) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OffsetsBag bag = new OffsetsBag(doc);
                    for (Pair highlight : highlights) {
                        bag.addHighlight(((int[])highlight.first())[0], ((int[])highlight.first())[1], ColoringManager.getColoringImpl((ColoringAttributes.Coloring)highlight.second()));
                    }
                    SemanticHighlighter.getImportHighlightsBag(doc).setHighlights(bag);
                    OffsetsBag preTextBag = new OffsetsBag(doc);
                    for (Map.Entry e : preText.entrySet()) {
                        preTextBag.addHighlight(((int[])e.getKey())[0], ((int[])e.getKey())[1], AttributesUtilities.createImmutable((Object[])new Object[]{"virtual-text-prepend", e.getValue()}));
                    }
                    SemanticHighlighter.getPreTextBag(doc).setHighlights(preTextBag);
                }
            });
        }

        public void setColorings(final Document doc, final Map<Token, ColoringAttributes.Coloring> colorings) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Map<Token, ColoringAttributes.Coloring> oldColors = LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, doc).getColorings();
                    IdentityHashMap<Token, ColoringAttributes.Coloring> removedTokens = new IdentityHashMap<Token, ColoringAttributes.Coloring>(oldColors);
                    HashSet<Token> addedTokens = new HashSet<Token>();
                    for (Map.Entry entrySet : colorings.entrySet()) {
                        Token t = (Token)entrySet.getKey();
                        ColoringAttributes.Coloring oldColoring = (ColoringAttributes.Coloring)removedTokens.remove(t);
                        if (oldColoring != null && oldColoring.equals(entrySet.getValue())) continue;
                        addedTokens.add(t);
                    }
                    LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, doc).setColorings(colorings, addedTokens, removedTokens.keySet());
                }
            });
        }
    };
    private static final Object KEY_UNUSED_IMPORTS = new Object();
    private static final Object KEY_PRE_TEXT = new Object();

    protected boolean process(CompilationInfo info, Document doc) {
        long start = System.currentTimeMillis();
        boolean ret = this.process(info, doc, ERROR_DESCRIPTION_SETTER);
        Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.FINE, "Semantic {1} {0}", new Object[]{NbEditorUtilities.getFileObject((Document)doc), System.currentTimeMillis() - start});
        return ret;
    }

    static OffsetsBag getImportHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(KEY_UNUSED_IMPORTS);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(KEY_UNUSED_IMPORTS, bag);
            Object stream = doc.getProperty("stream");
            if (stream instanceof DataObject) {
                // empty if block
            }
        }
        return bag;
    }

    static OffsetsBag getPreTextBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(KEY_PRE_TEXT);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(KEY_PRE_TEXT, bag);
            Object stream = doc.getProperty("stream");
            if (stream instanceof DataObject) {
                // empty if block
            }
        }
        return bag;
    }
}

