/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.spi.AntEvent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.ant.debugger.AntDebuggerEngineProvider;
import org.netbeans.modules.ant.debugger.Bundle;
import org.netbeans.modules.ant.debugger.CallStackModel;
import org.netbeans.modules.ant.debugger.IOManager;
import org.netbeans.modules.ant.debugger.Task;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.modules.ant.debugger.VariablesModel;
import org.netbeans.modules.ant.debugger.WatchesModel;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.modules.ant.debugger.breakpoints.BreakpointModel;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.w3c.dom.Element;

public class AntDebugger
extends ActionsProviderSupport {
    private static final Logger logger = Logger.getLogger(AntDebugger.class.getName());
    private static RequestProcessor actionsRequestProcessor;
    private static RequestProcessor killRequestProcessor;
    private AntProjectCookie antCookie;
    private AntDebuggerEngineProvider engineProvider;
    private ContextProvider contextProvider;
    private ExecutorTask execTask;
    private final Object LOCK = new Object();
    private final Object LOCK_ACTIONS = new Object();
    private boolean actionRunning = false;
    private IOManager ioManager;
    private Object currentLine;
    private LinkedList callStackList = new LinkedList();
    private File currentFile;
    private String currentTargetName;
    private String currentTaskName;
    private int originatingIndex = -1;
    private volatile boolean suspended = false;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private VariablesModel variablesModel;
    private WatchesModel watchesModel;
    private BreakpointModel breakpointModel;
    private static final Set<Object> actions;
    private static final Set<Object> actionsToDisable;
    private AntEvent lastEvent;
    private Map watches = new HashMap();
    private Object lastAction;
    private String targetEndToStopAt = null;
    private String taskEndToStopAt = null;
    private File fileToStopAt = null;
    private volatile boolean doStop = true;
    private volatile boolean finished = false;
    private CallStackModel callStackModel;
    private Map<File, Map<String, TargetLister.Target>> nameToTargetByFiles = new HashMap<File, Map<String, TargetLister.Target>>();
    private Map<File, String> projectNamesByFiles = new HashMap<File, String>();
    private String[] variables = new String[0];

    public AntDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.antCookie = (AntProjectCookie)contextProvider.lookupFirst(null, AntProjectCookie.class);
        this.engineProvider = (AntDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        Iterator<Object> it = actions.iterator();
        while (it.hasNext()) {
            this.setEnabled(it.next(), true);
        }
        this.ioManager = new IOManager(this.antCookie.getFile().getName());
    }

    void setExecutor(ExecutorTask execTask) {
        this.execTask = execTask;
        if (execTask != null) {
            execTask.addTaskListener(new TaskListener(){

                public void taskFinished(org.openide.util.Task task) {
                    AntDebugger.this.finish();
                }
            });
        }
    }

    public Set getActions() {
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = true;
        }
        logger.log(Level.FINE, "AntDebugger.doAction({0}), is kill = {1}", new Object[]{action, action == ActionsManager.ACTION_KILL});
        if (action == ActionsManager.ACTION_KILL) {
            this.finish();
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.doContinue();
        } else {
            if (action == ActionsManager.ACTION_START) {
                return;
            }
            if (action == ActionsManager.ACTION_STEP_INTO || action == ActionsManager.ACTION_STEP_OUT || action == ActionsManager.ACTION_STEP_OVER) {
                this.doStep(action);
            }
        }
        object = this.LOCK_ACTIONS;
        synchronized (object) {
            if (this.actionRunning) {
                try {
                    this.LOCK_ACTIONS.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_KILL) {
            Class<AntDebugger> clazz = AntDebugger.class;
            synchronized (AntDebugger.class) {
                if (killRequestProcessor == null) {
                    killRequestProcessor = new RequestProcessor("Ant debugger finish RP", 1);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                killRequestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AntDebugger.this.doAction(action);
                        }
                        finally {
                            actionPerformedNotifier.run();
                        }
                    }
                });
                return;
            }
        }
        this.setDebugActionsEnabled(false);
        Class<AntDebugger> clazz = AntDebugger.class;
        synchronized (AntDebugger.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("Ant debugger actions RP", 1);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            actionsRequestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        AntDebugger.this.doAction(action);
                    }
                    finally {
                        actionPerformedNotifier.run();
                        AntDebugger.this.setDebugActionsEnabled(true);
                    }
                }
            });
            return;
        }
    }

    private void setDebugActionsEnabled(boolean enabled) {
        for (Object action : actionsToDisable) {
            this.setEnabled(action, enabled);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private void setSuspended(boolean suspended) {
        this.suspended = suspended;
        this.fireStateChanged(suspended);
    }

    private void fireStateChanged(boolean suspended) {
        for (StateListener sl : this.stateListeners) {
            sl.suspended(suspended);
        }
    }

    private void fireFinished() {
        for (StateListener sl : this.stateListeners) {
            sl.finished();
        }
    }

    void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    void taskStarted(AntEvent event) {
        if (this.finished) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AntDebugger.taskStarted({0})", event);
        }
        Object taskLine = Utils.getLine(event);
        this.callStackList.addFirst(new Task(event.getTaskStructure(), taskLine, event.getScriptLocation()));
        this.currentTaskName = event.getTaskStructure().getName();
        this.originatingIndex = 0;
        if (!this.ignoreFrame()) {
            this.elementStarted(event);
        }
    }

    private void elementStarted(AntEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AntDebugger.elementStarted({0}), doStop = {1}", new Object[]{event, this.doStop});
        }
        if (this.finished) {
            return;
        }
        if (!this.doStop) {
            if (!this.onBreakpoint()) {
                logger.fine(" Not on breakpoint, continuing...");
                return;
            }
            logger.fine(" Is on breakpoint.");
        }
        logger.fine("AntDebugger.elementStarted() stopping...");
        this.stopHere(event);
        logger.fine("AntDebugger.elementStarted() finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHere(AntEvent event) {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            this.lastEvent = event;
        }
        this.updateUI();
        this.currentFile = event.getScriptLocation();
        Set properties = event.getPropertyNames();
        this.variables = properties.toArray(new String[0]);
        this.fireVariables();
        this.fireWatches();
        this.fireBreakpoints();
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
        this.setSuspended(true);
        object = this.LOCK;
        synchronized (object) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "stopHere(): waiting in thread ''{0}'' ...", Thread.currentThread());
                }
                this.LOCK.wait();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "stopHere(): wait in thread ''{0}'' notified.", Thread.currentThread());
                }
            }
            catch (InterruptedException ex) {
                logger.fine("AntDebugger.stopHere() was interrupted.");
                Thread.currentThread().interrupt();
            }
        }
        if (!this.finished) {
            this.setSuspended(false);
        }
        object = this;
        synchronized (object) {
            this.lastEvent = null;
        }
    }

    void taskFinished(AntEvent event) {
        if (this.finished) {
            return;
        }
        if (this.callStackList.size() > 0) {
            this.callStackList.remove(0);
        } else {
            logger.log(Level.CONFIG, "Empty call stack when task {0} finished.", event.getTaskStructure().getName());
        }
        if (this.taskEndToStopAt != null && this.taskEndToStopAt.equals(event.getTaskStructure().getName()) && event.getScriptLocation().equals(this.fileToStopAt)) {
            if (this.targetEndToStopAt != null) {
                if (this.targetEndToStopAt.equals(event.getTargetName())) {
                    this.targetEndToStopAt = null;
                    this.taskEndToStopAt = null;
                    this.fileToStopAt = null;
                    this.doStop = true;
                }
            } else {
                this.taskEndToStopAt = null;
                this.fileToStopAt = null;
                this.doStop = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished(AntEvent event) {
        this.engineProvider.getDestructor().killEngine();
        this.ioManager.closeStream();
        Utils.unmarkCurrent();
        this.fireFinished();
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
    }

    void targetStarted(AntEvent event) {
        Object topFrame;
        LinkedList<TargetOriginating> originatingTargets;
        TargetLister.Target target;
        String targetName;
        block8: {
            block6: {
                String start;
                block10: {
                    block9: {
                        block7: {
                            if (this.finished) {
                                return;
                            }
                            targetName = event.getTargetName();
                            target = this.findTarget(targetName, event.getScriptLocation());
                            originatingTargets = null;
                            if (this.callStackList.size() <= 0) break block6;
                            topFrame = this.callStackList.get(0);
                            if (!(topFrame instanceof Task)) break block7;
                            Task t1 = (Task)topFrame;
                            String startingTargetName = t1.getTaskStructure().getAttribute("target");
                            if (startingTargetName == null || targetName.equals(startingTargetName)) break block8;
                            originatingTargets = this.findPath(event.getScriptLocation(), startingTargetName, targetName);
                            break block8;
                        }
                        if (!(topFrame instanceof TargetLister.Target)) break block9;
                        String start2 = ((TargetLister.Target)topFrame).getName();
                        LinkedList<TargetOriginating> path = this.findPath(event.getScriptLocation(), start2, targetName);
                        if (path == null) break block8;
                        this.callStackList.removeFirst();
                        originatingTargets = path;
                        break block8;
                    }
                    if (!(topFrame instanceof TargetOriginating)) break block8;
                    start = ((TargetOriginating)topFrame).getOriginatingTarget().getName();
                    if (!start.equals(targetName)) break block10;
                    this.callStackList.removeFirst();
                    --this.originatingIndex;
                    break block8;
                }
                LinkedList<TargetOriginating> path = this.findPath(event.getScriptLocation(), start, targetName);
                if (path == null) break block8;
                this.callStackList.removeFirst();
                originatingTargets = path;
                break block8;
            }
            for (String start : event.getSession().getOriginatingTargets()) {
                LinkedList<TargetOriginating> path;
                if (start.equals(targetName) || (path = this.findPath(event.getScriptLocation(), start, targetName)) == null) continue;
                originatingTargets = path;
                break;
            }
        }
        if (originatingTargets != null) {
            this.originatingIndex = originatingTargets.size();
            this.callStackList.addAll(0, originatingTargets);
        } else {
            this.originatingIndex = 0;
        }
        Object v0 = (topFrame = this.callStackList.size() > 0 ? this.callStackList.getFirst() : null);
        if (topFrame instanceof TargetOriginating && ((TargetOriginating)topFrame).getOriginatingTarget().getName().equals(targetName)) {
            this.callStackList.removeFirst();
            --this.originatingIndex;
        }
        if (target == null) {
            this.ioManager.println(Bundle.MSG_TargetNotFound(targetName, event.getScriptLocation()), null, true);
        }
        this.callStackList.addFirst(target);
        this.currentTargetName = targetName;
        this.currentTaskName = null;
        this.elementStarted(event);
    }

    void targetFinished(AntEvent event) {
        if (this.finished) {
            return;
        }
        if (this.callStackList.size() > 0) {
            this.callStackList.remove(0);
        } else {
            logger.log(Level.CONFIG, "Empty call stack when target {0} finished.", event.getTargetName());
        }
        if (this.targetEndToStopAt != null && this.targetEndToStopAt.equals(event.getTargetName()) && this.fileToStopAt.equals(event.getScriptLocation())) {
            this.targetEndToStopAt = null;
            this.taskEndToStopAt = null;
            this.fileToStopAt = null;
            this.doStop = true;
        }
        this.currentTargetName = null;
    }

    private Object getTopFrame() {
        Object topFrame = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (topFrame instanceof TargetOriginating) {
            topFrame = ((TargetOriginating)topFrame).getOriginatingTarget();
        }
        return topFrame;
    }

    private void updateUI() {
        String nextTargetName = null;
        Object topFrame = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (topFrame instanceof TargetOriginating) {
            TargetLister.Target nextTarget = ((TargetOriginating)topFrame).getDependentTarget();
            nextTargetName = nextTarget.getName();
            topFrame = ((TargetOriginating)topFrame).getOriginatingTarget();
        }
        this.currentLine = topFrame != null ? (topFrame instanceof Task ? ((Task)topFrame).getLine() : Utils.getLine((TargetLister.Target)topFrame, nextTargetName)) : null;
        if (this.currentLine != null) {
            this.updateOutputWindow(this.currentLine);
            Utils.markCurrent(this.currentLine);
        }
        this.getCallStackModel().fireChanges();
    }

    private void updateOutputWindow(Object currentLine) {
        Object topFrame = this.getTopFrame();
        if (topFrame instanceof Task) {
            Task task = (Task)topFrame;
            this.ioManager.println(task.getFile().getName() + ":" + (Utils.getLineNumber(currentLine) + 1) + ": Task " + this.getStackAsString(), currentLine);
        } else {
            TargetLister.Target target = (TargetLister.Target)topFrame;
            this.ioManager.println(target.getScript().getFile().getName() + ":" + (Utils.getLineNumber(currentLine) + 1) + ": Target " + this.getStackAsString(), currentLine);
        }
    }

    private String getStackAsString() {
        StringBuffer sb = new StringBuffer();
        int i = this.callStackList.size() - 1;
        sb.append(AntDebugger.getFrameName(this.callStackList.get(i--)));
        int end = Math.max(0, this.originatingIndex);
        while (i >= end) {
            sb.append('.').append(AntDebugger.getFrameName(this.callStackList.get(i--)));
        }
        return new String(sb);
    }

    private static String getFrameName(Object frame) {
        if (frame instanceof TargetOriginating) {
            frame = ((TargetOriginating)frame).getOriginatingTarget();
        }
        if (frame == null) {
            return "?";
        }
        return frame instanceof Task ? ((Task)frame).getTaskStructure().getName() : ((TargetLister.Target)frame).getName();
    }

    private boolean ignoreFrame() {
        String frameName;
        if (this.callStackList.size() <= 1) {
            return false;
        }
        return "import".equals(this.currentTaskName) && "antcall".equals(frameName = AntDebugger.getFrameName(this.callStackList.get(1)));
    }

    private boolean onBreakpoint() {
        Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
        int jj = ws.length;
        for (int j = 0; j < jj; ++j) {
            Object value = this.getVariableValue(ws[j].getExpression());
            if (value == null) {
                value = 0;
            }
            if (this.watches.containsKey(ws[j].getExpression()) && !this.watches.get(ws[j].getExpression()).equals(value)) {
                this.watches.put(ws[j].getExpression(), value);
                return true;
            }
            this.watches.put(ws[j].getExpression(), value);
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        jj = this.callStackList.size();
        if (jj >= 1) {
            Annotatable[] line;
            Object frame = this.callStackList.getFirst();
            if (frame instanceof TargetOriginating) {
                frame = ((TargetOriginating)frame).getOriginatingTarget();
            }
            if (frame == null) {
                line = null;
            } else {
                Object object = line = frame instanceof Task ? ((Task)frame).getLine() : Utils.getLine((TargetLister.Target)frame, null);
            }
            if (line != null) {
                line = new Annotatable[]{((Annotatable[])line)[0]};
            }
            int k = breakpoints.length;
            for (int i = 0; i < k; ++i) {
                if (!(breakpoints[i] instanceof AntBreakpoint) || !breakpoints[i].isEnabled() || !Utils.contains(line, ((AntBreakpoint)breakpoints[i]).getLine())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void doContinue() {
        Utils.unmarkCurrent();
        this.doStop = false;
        this.targetEndToStopAt = null;
        this.taskEndToStopAt = null;
        this.fileToStopAt = null;
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStep(Object action) {
        if (action == ActionsManager.ACTION_STEP_INTO) {
            if (this.originatingIndex > 0) {
                --this.originatingIndex;
                this.updateUI();
                Object object = this.LOCK_ACTIONS;
                synchronized (object) {
                    this.actionRunning = false;
                    this.LOCK_ACTIONS.notifyAll();
                }
                return;
            }
            this.doStop = true;
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            if (this.originatingIndex > 0) {
                Object frame = this.callStackList.get(this.originatingIndex);
                TargetLister.Target dep = ((TargetOriginating)frame).getDependentTarget();
                this.targetEndToStopAt = dep.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            } else {
                this.taskEndToStopAt = this.currentTaskName;
                this.targetEndToStopAt = this.currentTargetName;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            Object frame;
            if (this.originatingIndex > 1) {
                frame = this.callStackList.get(this.originatingIndex - 1);
                TargetLister.Target dep = ((TargetOriginating)frame).getDependentTarget();
                this.targetEndToStopAt = dep.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
            if (this.callStackList.size() > 1) {
                frame = this.callStackList.get(1);
                if (frame instanceof Task) {
                    this.taskEndToStopAt = ((Task)frame).getTaskStructure().getName();
                    for (int i = 2; i < this.callStackList.size(); ++i) {
                        frame = this.callStackList.get(i);
                        if (!(frame instanceof String)) continue;
                        this.targetEndToStopAt = ((TargetLister.Target)frame).getName();
                        break;
                    }
                } else {
                    this.targetEndToStopAt = frame instanceof TargetOriginating ? ((TargetOriginating)frame).getOriginatingTarget().getName() : ((TargetLister.Target)frame).getName();
                }
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else {
            throw new IllegalArgumentException(action.toString());
        }
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEngineStep() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        logger.fine("AntDebugger.finish()");
        if (this.finished) {
            logger.fine("finish(): already finished.");
            return;
        }
        if (this.execTask != null) {
            this.execTask.stop();
        }
        logger.fine("finish(): task stopped.");
        Utils.unmarkCurrent();
        this.doStop = false;
        this.finished = true;
        this.taskEndToStopAt = null;
        this.targetEndToStopAt = null;
        this.fileToStopAt = null;
        this.fireFinished();
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
        logger.fine("finish(): notify called.");
        this.buildFinished(null);
        logger.fine("finish() done, build finished.");
    }

    private CallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (CallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    Object[] getCallStack() {
        Object[] callStack = this.originatingIndex > 0 ? this.callStackList.subList(this.originatingIndex, this.callStackList.size()).toArray() : this.callStackList.toArray();
        for (int i = 0; i < callStack.length; ++i) {
            if (!(callStack[i] instanceof TargetOriginating)) continue;
            callStack[i] = ((TargetOriginating)callStack[i]).getOriginatingTarget();
        }
        return callStack;
    }

    private LinkedList<TargetOriginating> findPath(File file, String start, String end) {
        TargetLister.Target t = this.findTarget(start, file);
        if (t == null) {
            return null;
        }
        if (start.equals(end)) {
            LinkedList<TargetOriginating> ll = new LinkedList<TargetOriginating>();
            ll.addFirst(new TargetOriginating(null, t));
            return ll;
        }
        String depends = t.getElement().getAttribute("depends");
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String newStart = st.nextToken().trim();
            LinkedList<TargetOriginating> ll = this.findPath(file, newStart, end);
            if (ll == null) continue;
            TargetOriginating to = ll.getLast();
            if (to.getOriginatingTarget() == null) {
                to.setOriginatingTarget(t);
            } else {
                ll.addLast(new TargetOriginating(t, to.getOriginatingTarget()));
            }
            return ll;
        }
        return null;
    }

    private synchronized TargetLister.Target findTarget(String name, File file) {
        String projName;
        TargetLister.Target target;
        Map<String, TargetLister.Target> nameToTarget = this.nameToTargetByFiles.get(file);
        if (nameToTarget == null) {
            DataObject dob;
            nameToTarget = new HashMap<String, TargetLister.Target>();
            FileObject fo = FileUtil.toFileObject((File)file);
            try {
                dob = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException donfex) {
                throw new IllegalStateException(donfex.getLocalizedMessage());
            }
            AntProjectCookie ant = (AntProjectCookie)dob.getLookup().lookup(AntProjectCookie.class);
            if (ant != null) {
                Element proj = ant.getProjectElement();
                if (proj != null) {
                    String projName2 = proj.getAttribute("name");
                    this.projectNamesByFiles.put(file, projName2);
                }
                try {
                    Set targets = TargetLister.getTargets((AntProjectCookie)ant);
                    for (TargetLister.Target t : targets) {
                        nameToTarget.put(t.getName(), t);
                    }
                }
                catch (IOException iOException) {}
            } else {
                logger.log(Level.WARNING, "No ant cookie from {0}, fo = {1}", new Object[]{dob, fo});
            }
            this.nameToTargetByFiles.put(file, nameToTarget);
        }
        if ((target = nameToTarget.get(name)) == null && name.startsWith((projName = this.projectNamesByFiles.get(file)) + ".")) {
            name = name.substring(projName.length() + 1);
            target = nameToTarget.get(name);
        }
        return target;
    }

    synchronized void setVariablesModel(VariablesModel variablesModel) {
        this.variablesModel = variablesModel;
    }

    synchronized void setWatchesModel(WatchesModel watchesModel) {
        this.watchesModel = watchesModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVariables() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.variablesModel == null) {
                return;
            }
        }
        this.variablesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatches() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.watchesModel == null) {
                return;
            }
        }
        this.watchesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpoints() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.breakpointModel == null) {
                List bpNodeModels = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
                for (NodeModel model : bpNodeModels) {
                    if (!(model instanceof BreakpointModel)) continue;
                    this.breakpointModel = (BreakpointModel)model;
                    break;
                }
            }
        }
        this.breakpointModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String evaluate(String expression) {
        String value = this.getVariableValue(expression);
        if (value != null) {
            return value;
        }
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.lastEvent == null) {
                return null;
            }
            return this.lastEvent.evaluate(expression);
        }
    }

    String[] getVariables() {
        return this.variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getVariableValue(String variableName) {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.lastEvent == null) {
                return null;
            }
            return this.lastEvent.getProperty(variableName);
        }
    }

    static {
        actions = new HashSet<Object>();
        actionsToDisable = new HashSet<Object>();
        actions.add(ActionsManager.ACTION_KILL);
        actions.add(ActionsManager.ACTION_CONTINUE);
        actions.add(ActionsManager.ACTION_START);
        actions.add(ActionsManager.ACTION_STEP_INTO);
        actions.add(ActionsManager.ACTION_STEP_OVER);
        actions.add(ActionsManager.ACTION_STEP_OUT);
        actionsToDisable.addAll(actions);
        actionsToDisable.remove(ActionsManager.ACTION_KILL);
    }

    static interface StateListener {
        public void suspended(boolean var1);

        public void finished();
    }

    private static class TargetOriginating {
        private TargetLister.Target target;
        private TargetLister.Target dependent;

        TargetOriginating(TargetLister.Target target, TargetLister.Target dependent) {
            this.target = target;
            this.dependent = dependent;
        }

        TargetLister.Target getOriginatingTarget() {
            return this.target;
        }

        void setOriginatingTarget(TargetLister.Target target) {
            this.target = target;
        }

        TargetLister.Target getDependentTarget() {
            return this.dependent;
        }
    }
}

