/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.Parser;
import com.oracle.js.parser.ScriptEnvironment;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.FunctionNode;
import org.netbeans.api.lexer.Language;
import org.netbeans.modules.javascript2.editor.parser.JsErrorManager;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.parser.SanitizingParser;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsParser
extends SanitizingParser<JsParserResult> {
    private static final String SINGLETON_FUNCTION_START = "(function(){";
    private static final String SINGLETON_FUNCTION_END = "})();";
    private static final String SHEBANG_START = "#!";
    private static final String NODE = "node";
    private static final String IMPORT = "import ";
    private static final String EXPORT = "export ";

    public JsParser() {
        super((Language<JsTokenId>)JsTokenId.javascriptLanguage());
    }

    @Override
    protected String getDefaultScriptName() {
        return "javascript.js";
    }

    @Override
    protected JsParserResult parseSource(SanitizingParser.Context context, JsErrorManager errorManager) throws Exception {
        StringBuilder sb;
        Snapshot snapshot = context.getSnapshot();
        String name = context.getName();
        String text = context.getSource();
        int caretOffset = context.getCaretOffset();
        boolean isModule = context.isModule();
        String parsableText = text;
        if (parsableText.startsWith(SHEBANG_START)) {
            sb = new StringBuilder(parsableText);
            int index = parsableText.indexOf("\n");
            if (index < 0) {
                index = parsableText.length();
            }
            sb.delete(0, index);
            for (int i = 0; i < index; ++i) {
                sb.insert(i, ' ');
            }
            if (this.isNodeSource(text.substring(0, index), text)) {
                sb.delete(0, SINGLETON_FUNCTION_START.length());
                sb.insert(0, SINGLETON_FUNCTION_START);
                sb.append(SINGLETON_FUNCTION_END);
            }
            parsableText = sb.toString();
        }
        if (caretOffset > 0 && caretOffset < parsableText.length() && parsableText.charAt(caretOffset - 1) == '.' && parsableText.length() > caretOffset && Character.isWhitespace(parsableText.charAt(caretOffset))) {
            sb = new StringBuilder(parsableText);
            sb.delete(caretOffset - 1, caretOffset);
            sb.insert(caretOffset - 1, ' ');
            parsableText = sb.toString();
        }
        Source source = Source.sourceFor((String)name, (String)parsableText);
        errorManager.setLimit(0);
        ScriptEnvironment.Builder builder = ScriptEnvironment.builder();
        Parser parser = new Parser(builder.emptyStatements(true).ecmacriptEdition(Integer.MAX_VALUE).jsx(true).build(), source, (ErrorManager)errorManager);
        FunctionNode node = isModule ? parser.parseModule(name) : parser.parse();
        return new JsParserResult(snapshot, node);
    }

    @Override
    protected JsParserResult createErrorResult(Snapshot snapshot) {
        return new JsParserResult(snapshot, null);
    }

    @Override
    protected String getMimeType() {
        return "text/javascript";
    }

    private boolean isNodeSource(String firstLine, String text) {
        boolean hasCorretSheBang;
        boolean bl = hasCorretSheBang = firstLine.startsWith(SHEBANG_START) && firstLine.contains(NODE) && SINGLETON_FUNCTION_START.length() < firstLine.length();
        if (hasCorretSheBang) {
            int lineOffsetBegin = firstLine.length() + 1;
            int lineOffsetEnd = text.indexOf(10, lineOffsetBegin);
            while (lineOffsetEnd >= lineOffsetBegin) {
                String line = text.substring(lineOffsetBegin, lineOffsetEnd).trim();
                if (line.startsWith(IMPORT) || line.startsWith(EXPORT)) {
                    hasCorretSheBang = false;
                    break;
                }
                if (!line.isEmpty() && !line.startsWith("//") && !line.startsWith("*") && !line.startsWith("/*")) break;
                lineOffsetBegin = lineOffsetEnd + 1;
                lineOffsetEnd = text.indexOf(10, lineOffsetBegin);
            }
        }
        return hasCorretSheBang;
    }
}

