/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.EventCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.spi.editor.completion.CompletionItem;

public class EventCompleter
implements Completer,
Completer.Factory {
    private CompletionContext ctx;
    private FxInstance instance;
    private FxBean fxBean;
    private boolean moreItems;

    EventCompleter(CompletionContext ctx, FxInstance inst) {
        this.ctx = ctx;
        this.instance = inst;
        this.fxBean = inst.getDefinition();
    }

    public EventCompleter() {
    }

    private EventCompletionItem createItem(FxEvent e, boolean noInherit) {
        String cn = e.getEventClassName();
        int dot = cn.lastIndexOf(46);
        cn = cn.substring(dot + 1);
        EventCompletionItem item = new EventCompletionItem(cn, this.ctx.isAttribute(), this.ctx, e.getSymbol());
        item.setInherited(noInherit || this.fxBean.getDeclareadInfo().getEvent(e.getName()) != null);
        return item;
    }

    private void completeShallow(List<CompletionItem> result) {
        String prefix = this.ctx.getPrefix();
        HashSet<String> eventNames = new HashSet<String>();
        if (prefix.contains("on")) {
            eventNames.addAll(this.fxBean.getEventNames());
            if (this.fxBean.usesBuilder()) {
                eventNames.addAll(this.fxBean.getBuilder().getEventNames());
            }
        } else {
            eventNames.addAll(this.fxBean.getDeclareadInfo().getEventNames());
            if (this.fxBean.usesBuilder()) {
                eventNames.addAll(this.fxBean.getBuilder().getDeclareadInfo().getEventNames());
            }
            this.moreItems = true;
        }
        for (String s : eventNames) {
            FxEvent e = this.fxBean.getEvent(s);
            if (e == null && this.fxBean.usesBuilder()) {
                e = this.fxBean.getBuilder().getEvent(s);
            }
            if (e.isPropertyChange()) {
                this.moreItems = true;
                continue;
            }
            result.add(this.createItem(e, true));
        }
    }

    private void completeAllEvents(List<CompletionItem> result) {
        FxEvent e;
        for (String s : this.fxBean.getEventNames()) {
            e = this.fxBean.getEvent(s);
            result.add(this.createItem(e, true));
        }
        if (this.fxBean.usesBuilder()) {
            for (String s : this.fxBean.getBuilder().getEventNames()) {
                if (this.fxBean.getEventNames().contains(s)) continue;
                e = this.fxBean.getBuilder().getEvent(s);
                result.add(this.createItem(e, true));
            }
        }
    }

    @Override
    public List<? extends CompletionItem> complete() {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        if (this.ctx.getCompletionType() == 1) {
            this.completeShallow(result);
        } else {
            this.completeAllEvents(result);
        }
        return result;
    }

    @Override
    public boolean hasMoreItems() {
        return this.moreItems;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        switch (ctx.getType()) {
            case CHILD_ELEMENT: 
            case PROPERTY: 
            case PROPERTY_ELEMENT: {
                break;
            }
            default: {
                return null;
            }
        }
        FxNode n = ctx.getElementParent();
        if (n == null || n.getKind() != FxNode.Kind.Instance) {
            return null;
        }
        FxInstance inst = (FxInstance)n;
        if (inst.getDefinition() == null) {
            return null;
        }
        return new EventCompleter(ctx, inst);
    }
}

