/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;

public class JadeJsEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOGGER = Logger.getLogger(JadeJsEmbeddingProvider.class.getName());
    private static final String JS_MIME_TYPE = "text/javascript";
    private static final String SEMICOLON_EOL = ";\n";
    private static final String EOL = "\n";
    private static final String SCRIPT_TAG_NAME = "script";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JadeTokenId.jadeLanguage());
        if (ts == null) {
            LOGGER.log(Level.WARNING, "TokenHierarchy.tokenSequence(JadeTokenId.jadeLanguage()) == null for static immutable Jade TokenHierarchy!\nFile = ''{0}'' ;snapshot mimepath=''{1}''", new Object[]{snapshot.getSource().getFileObject().getPath(), snapshot.getMimePath()});
            return Collections.emptyList();
        }
        ts.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int len = 0;
        Token lastTag = null;
        Token lastMixing = null;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() == JadeTokenId.JAVASCRIPT) {
                if (from < 0) {
                    from = ts.offset();
                }
                len += token.length();
            } else {
                if (from >= 0) {
                    if (lastMixing != null) {
                        this.wrapAsFnParameter(snapshot, embeddings, lastMixing.text().toString(), from, len);
                    } else {
                        embeddings.add(snapshot.create(from, len, JS_MIME_TYPE));
                        this.addNewLine(snapshot, embeddings, from + len - 1);
                    }
                }
                from = -1;
                len = 0;
            }
            if (token.id() == JadeTokenId.TAG) {
                lastTag = token;
                lastMixing = null;
            }
            if (token.id() == JadeTokenId.MIXIN_NAME) {
                lastTag = null;
                lastMixing = token;
            }
            if (token.id() != JadeTokenId.PLAIN_TEXT_DELIMITER || lastTag == null || !SCRIPT_TAG_NAME.equalsIgnoreCase(lastTag.text().toString()) || !ts.moveNext()) continue;
            token = ts.token();
            while (token.id() == JadeTokenId.EOL && ts.moveNext()) {
                token = ts.token();
            }
            if (token.id() != JadeTokenId.PLAIN_TEXT && token.id() != JadeTokenId.JAVASCRIPT) continue;
            embeddings.add(snapshot.create(ts.offset(), token.length(), JS_MIME_TYPE));
        }
        if (from >= 0) {
            if (lastMixing != null) {
                this.wrapAsFnParameter(snapshot, embeddings, lastMixing.text().toString(), from, len);
            } else {
                embeddings.add(snapshot.create(from, len, JS_MIME_TYPE));
                this.addNewLine(snapshot, embeddings, from + len - 1);
            }
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    private void addNewLine(Snapshot snapshot, List<Embedding> embeddings, int origOffset) {
        int offset;
        CharSequence text = snapshot.getText();
        for (offset = origOffset; offset > 0 && Character.isWhitespace(text.charAt(offset)); --offset) {
        }
        if (offset > 0) {
            char ch = text.charAt(offset);
            if (ch == '{' || ch == '}' || ch == '[') {
                embeddings.add(snapshot.create((CharSequence)EOL, JS_MIME_TYPE));
            } else {
                embeddings.add(snapshot.create((CharSequence)SEMICOLON_EOL, JS_MIME_TYPE));
            }
        }
    }

    private void wrapAsFnParameter(Snapshot snapshot, List<Embedding> embeddings, String fnName, int from, int len) {
        embeddings.add(snapshot.create((CharSequence)(fnName + "("), JS_MIME_TYPE));
        embeddings.add(snapshot.create(from, len, JS_MIME_TYPE));
        embeddings.add(snapshot.create((CharSequence)");\n", JS_MIME_TYPE));
    }

    public int getPriority() {
        return 202;
    }

    public void cancel() {
    }
}

