/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.java.ui.ClassItem;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.elements.ElementNode;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class MoveClassPanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private final ListCellRenderer GROUP_CELL_RENDERER = new GroupCellRenderer();
    private final ListCellRenderer PROJECT_CELL_RENDERER = new ProjectCellRenderer();
    private final ListCellRenderer CLASS_CELL_RENDERER = new ClassListCellRenderer();
    private static final RequestProcessor RP = new RequestProcessor(MoveClassPanel.class.getName(), 1);
    private Project project;
    private ChangeListener parent;
    private FileObject fo;
    private SourceGroup[] groups;
    private String startPackage;
    private String newName;
    private String bypassLine;
    private final boolean toType;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JCheckBox bypassRefactoringCheckBox;
    private JLabel labelHeadLine;
    private JLabel labelLocation;
    private JLabel labelNewName;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JTextField newNameField;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;
    private JCheckBox typeCheckBox;
    private JComboBox typeCombobox;
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);

    public MoveClassPanel(ChangeListener parent, String startPackage, String headLine, String bypassLine, FileObject f, boolean disable, Vector nodes) {
        this(parent, startPackage, headLine, bypassLine, f, null, false);
        this.setCombosEnabled(!disable);
        JList list = new JList(nodes);
        list.setCellRenderer(new NodeRenderer());
        list.setVisibleRowCount(5);
        JScrollPane pane = new JScrollPane(list);
        this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)pane, "Center");
        JLabel listOf = new JLabel();
        Mnemonics.setLocalizedText((JLabel)listOf, (String)NbBundle.getMessage(MoveClassesUI.class, (String)"LBL_ListOfClasses"));
        this.bottomPanel.add((Component)listOf, "North");
        this.typeCheckBox.setVisible(false);
        this.typeCombobox.setVisible(false);
    }

    public MoveClassPanel(ChangeListener parent, String startPackage, String headLine, String bypassLine, FileObject f) {
        this(parent, startPackage, headLine, bypassLine, f, null, true);
    }

    public MoveClassPanel(ChangeListener parent, String startPackage, String headLine, String bypassLine, FileObject f, String newName, boolean toType) {
        this.fo = f;
        this.parent = parent;
        this.newName = newName;
        this.bypassLine = bypassLine;
        this.initComponents();
        this.setCombosEnabled(true);
        this.labelHeadLine.setText(headLine);
        this.rootComboBox.setRenderer(this.GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(this.PROJECT_CELL_RENDERER);
        this.typeCombobox.setRenderer(this.CLASS_CELL_RENDERER);
        Project fileOwner = this.fo != null ? FileOwnerQuery.getOwner((FileObject)this.fo) : null;
        this.project = fileOwner != null ? fileOwner : OpenProjects.getDefault().getOpenProjects()[0];
        this.startPackage = startPackage;
        if (newName != null) {
            this.labelHeadLine.setVisible(false);
        } else {
            this.labelNewName.setVisible(false);
            this.newNameField.setVisible(false);
        }
        this.toType = toType;
    }

    private String getBypassLine() {
        return this.bypassLine;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initValues(this.startPackage);
        if (this.newName != null) {
            FileObject fob;
            do {
                if ((fob = this.fo.getFileObject(this.newName + ".java")) == null) continue;
                this.newName = this.newName + "1";
            } while (fob != null);
            this.newNameField.setText(this.newName);
            this.newNameField.setSelectionStart(0);
            this.newNameField.setSelectionEnd(this.newNameField.getText().length());
        }
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        this.projectsComboBox.addActionListener(this);
        Component textField = this.packageComboBox.getEditor().getEditorComponent();
        if (textField instanceof JTextField) {
            ((JTextField)textField).getDocument().addDocumentListener(this);
        }
        this.newNameField.getDocument().addDocumentListener(this);
        this.initialized = true;
    }

    public void initValues(String preselectedFolder) {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(openProjects, new ProjectByDisplayNameComparator());
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectsComboBox.setModel(projectsModel);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        if (preselectedFolder != null) {
            this.packageComboBox.setSelectedItem(preselectedFolder);
        }
        this.updateClasses();
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.packageComboBox.isEditable() && this.packageComboBox.isEnabled()) {
            this.packageComboBox.requestFocusInWindow();
        } else {
            this.newNameField.requestFocusInWindow();
        }
        return true;
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName;
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.bypassRefactoringCheckBox = new JCheckBox();
        this.labelHeadLine = new JLabel();
        this.labelNewName = new JLabel();
        this.newNameField = new JTextField();
        this.typeCheckBox = new JCheckBox();
        this.typeCombobox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_projectsCombo"));
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rootCombo"));
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveClassPanel.class, (String)"MoveClassPanel.packageComboBox.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bypassRefactoringCheckBox, (String)this.getBypassLine());
        this.bypassRefactoringCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.bypassRefactoringCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.bypassRefactoringCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveClassPanel.this.bypassRefactoringCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.bypassRefactoringCheckBox, gridBagConstraints);
        this.bypassRefactoringCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveClassPanel.class, (String)"MoveClassPanel.updateReferencesCheckBox.AccessibleContext.accessibleDescription"));
        this.labelHeadLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 6, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelHeadLine, gridBagConstraints);
        this.labelNewName.setLabelFor(this.newNameField);
        Mnemonics.setLocalizedText((JLabel)this.labelNewName, (String)NbBundle.getMessage(MoveClassPanel.class, (String)"LBL_NewName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelNewName, gridBagConstraints);
        this.newNameField.setText(NbBundle.getMessage(MoveClassPanel.class, (String)"CopyClassPanel.newNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.newNameField, gridBagConstraints);
        this.newNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MoveClassPanel.class, (String)"CopyClassPanel.newNameTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.typeCheckBox, (String)"To Type:");
        this.typeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MoveClassPanel.this.typeCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.typeCheckBox, gridBagConstraints);
        this.typeCombobox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.typeCombobox, gridBagConstraints);
    }

    private void bypassRefactoringCheckBoxItemStateChanged(ItemEvent evt) {
        this.fireChange();
    }

    private void typeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.typeCheckBox.isSelected();
        if (selected) {
            int selectedIndex = this.packageComboBox.getSelectedIndex();
            if (selectedIndex < 0) {
                Component textField = this.packageComboBox.getEditor().getEditorComponent();
                if (textField instanceof JTextField) {
                    ((JTextField)textField).getDocument().removeDocumentListener(this);
                }
                this.packageComboBox.setSelectedIndex(0);
            }
            this.packageComboBox.setEditable(false);
        } else {
            Component textField = this.packageComboBox.getEditor().getEditorComponent();
            if (textField instanceof JTextField) {
                ((JTextField)textField).getDocument().addDocumentListener(this);
            }
            this.packageComboBox.setEditable(true);
        }
        this.typeCombobox.setEnabled(selected);
        this.fireChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.projectsComboBox == e.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateRoots();
            this.updatePackages();
            this.updateClasses();
        } else if (this.rootComboBox == e.getSource()) {
            this.updatePackages();
            this.updateClasses();
        } else if (this.packageComboBox == e.getSource()) {
            this.updateClasses();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    private void updatePackages() {
        SourceGroup g = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(g != null ? PackageView.createListView((SourceGroup)g) : new DefaultComboBoxModel());
    }

    private void updateClasses() {
        this.typeCombobox.setModel(new DefaultComboBoxModel<Object>(new Object[]{ElementNode.getWaitNode()}));
        RP.post(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel<Object> model;
                SourceGroup g = (SourceGroup)MoveClassPanel.this.rootComboBox.getSelectedItem();
                String packageName = MoveClassPanel.this.packageComboBox.getSelectedItem().toString();
                if (MoveClassPanel.this.packageComboBox.getSelectedIndex() > -1 && g != null && packageName != null) {
                    ClassPath compileCp;
                    String pathname = packageName.replace(".", "/");
                    FileObject fo = g.getRootFolder().getFileObject(pathname);
                    ClassPath bootCp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
                    if (bootCp == null) {
                        bootCp = EMPTY_PATH;
                    }
                    if ((compileCp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")) == null) {
                        compileCp = EMPTY_PATH;
                    }
                    ClassPath sourcePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                    ClasspathInfo info = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)sourcePath);
                    HashSet<1> searchScopeType = new HashSet<1>(1);
                    final Set<String> packageSet = Collections.singleton(packageName);
                    searchScopeType.add(new ClassIndex.SearchScopeType(){

                        public Set<? extends String> getPackages() {
                            return packageSet;
                        }

                        public boolean isSources() {
                            return true;
                        }

                        public boolean isDependencies() {
                            return false;
                        }
                    });
                    final Set result = info.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, searchScopeType);
                    if (result != null && !result.isEmpty()) {
                        JavaSource javaSource = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
                        final ArrayList items = new ArrayList(result.size());
                        try {
                            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                                private AtomicBoolean cancel = new AtomicBoolean();

                                public void cancel() {
                                    this.cancel.set(true);
                                }

                                public void run(CompilationController parameter) throws Exception {
                                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                                    for (ElementHandle elementHandle : result) {
                                        String fqn;
                                        TypeElement element = (TypeElement)elementHandle.resolve((CompilationInfo)parameter);
                                        if (element == null || (fqn = element.getQualifiedName().toString()).isEmpty()) continue;
                                        Icon icon = ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
                                        int packageNameLength = ((String)packageSet.iterator().next()).length();
                                        String className = packageNameLength > 0 && packageNameLength < fqn.length() ? fqn.substring(packageNameLength + 1) : fqn;
                                        ClassItem classItem = new ClassItem(className, icon, TreePathHandle.create((Element)element, (CompilationInfo)parameter));
                                        items.add(classItem);
                                    }
                                }
                            }, true);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        items.sort(new Comparator(){
                            private Comparator COLLATOR = Collator.getInstance();

                            public int compare(Object o1, Object o2) {
                                if (!(o1 instanceof ClassItem)) {
                                    return 1;
                                }
                                if (!(o2 instanceof ClassItem)) {
                                    return -1;
                                }
                                ClassItem p1 = (ClassItem)o1;
                                ClassItem p2 = (ClassItem)o2;
                                return this.COLLATOR.compare(p1.getDisplayName(), p2.getDisplayName());
                            }
                        });
                        model = new DefaultComboBoxModel<ClassItem>(items.toArray(new ClassItem[0]));
                    } else {
                        model = new DefaultComboBoxModel();
                    }
                } else {
                    model = new DefaultComboBoxModel();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MoveClassPanel.this.typeCombobox.setModel(model);
                        MoveClassPanel.this.fireChange();
                    }
                });
            }
        });
    }

    void setCombosEnabled(boolean enabled) {
        this.packageComboBox.setEnabled(enabled);
        this.rootComboBox.setEnabled(enabled);
        this.projectsComboBox.setEnabled(enabled);
        this.bypassRefactoringCheckBox.setVisible(!enabled);
        this.typeCheckBox.setVisible(this.toType && enabled);
        this.typeCombobox.setVisible(this.toType && enabled);
        this.setEnabled(enabled);
    }

    public boolean isRefactoringBypassRequired() {
        return this.bypassRefactoringCheckBox.isVisible() && this.bypassRefactoringCheckBox.isSelected();
    }

    public void setRefactoringBypassRequired(boolean needsByPass) {
        if (needsByPass) {
            this.bypassRefactoringCheckBox.setVisible(true);
        }
        this.bypassRefactoringCheckBox.setSelected(needsByPass);
        this.bypassRefactoringCheckBox.setEnabled(!needsByPass);
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("java");
        if (this.groups.length == 0) {
            this.groups = sources.getSourceGroups("generic");
        }
        int preselectedItem = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fo == null) continue;
            try {
                if (!this.groups[i].contains(this.fo)) continue;
                preselectedItem = i;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        if (this.groups.length > 0) {
            this.rootComboBox.setSelectedIndex(preselectedItem);
        }
    }

    public String getNewName() {
        return this.newNameField.getText();
    }

    public TreePathHandle getTargetClass() {
        Object selectedItem = this.typeCombobox.getSelectedItem();
        if (this.typeCheckBox.isSelected() && selectedItem instanceof ClassItem) {
            return ((ClassItem)selectedItem).getHandle();
        }
        return null;
    }

    public Component getComponent() {
        return this;
    }

    static class GroupCellRenderer
    extends BaseCellRenderer {
        GroupCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof SourceGroup) {
                SourceGroup g = (SourceGroup)value;
                this.setText(g.getDisplayName());
                this.setIcon(g.getIcon(false));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    static class ProjectCellRenderer
    extends BaseCellRenderer {
        ProjectCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.setText(pi.getDisplayName());
                this.setIcon(pi.getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    static final class ClassListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ClassListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof ClassItem) {
                ClassItem item = (ClassItem)value;
                this.setText(item.getDisplayName());
                this.setIcon(item.getIcon());
            } else if (value instanceof Node) {
                Node node = (Node)value;
                this.setText(node.getHtmlDisplayName());
                this.setIcon(ImageUtilities.image2Icon((Image)node.getIcon(1)));
            } else {
                String item = (String)value;
                this.setText(item);
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        ProjectByDisplayNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Project)) {
                return 1;
            }
            if (!(o2 instanceof Project)) {
                return -1;
            }
            Project p1 = (Project)o1;
            Project p2 = (Project)o2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

