/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.ui.ContextAnalyzer;
import org.netbeans.modules.refactoring.java.ui.InstantRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SyncDocumentRegion;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.instant.CompletionLayout;
import org.netbeans.modules.refactoring.java.ui.instant.InstantOption;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.spi.editor.document.UndoableEditWrapper;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class InstantRefactoringPerformer
implements DocumentListener,
KeyListener,
ProgressListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(InstantRefactoringPerformer.class.getName());
    private static final Set<InstantRefactoringPerformer> registry = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private CompletionLayout compl;
    private SyncDocumentRegion region;
    private int span;
    private Document doc;
    private JTextComponent target;
    private InstantRefactoringUI ui;
    private AttributeSet attribs = null;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private AttributeSet attribsSlave = null;
    private AttributeSet attribsSlaveLeft = null;
    private AttributeSet attribsSlaveRight = null;
    private AttributeSet attribsSlaveMiddle = null;
    private AttributeSet attribsSlaveAll = null;
    private static final String OKActionKey = "OK";
    private volatile boolean inSync;
    private static final RequestProcessor RP = new RequestProcessor(InstantRefactoringPerformer.class.getName(), 2, false, false);
    private static final AttributeSet defaultSyncedTextBlocksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.red});
    private JDialog dialog;
    private ProgressBar progressBar;
    private ProgressHandle progressHandle;
    private boolean isIndeterminate;

    public InstantRefactoringPerformer(final JTextComponent target, int caretOffset, InstantRefactoringUI ui) {
        InstantRefactoringPerformer.releaseAll();
        this.target = target;
        this.ui = ui;
        this.doc = target.getDocument();
        MutablePositionRegion mainRegion = null;
        ArrayList<MutablePositionRegion> regions = new ArrayList<MutablePositionRegion>(ui.getRegions().size());
        for (MutablePositionRegion current : ui.getRegions()) {
            if (InstantRefactoringPerformer.isIn(current, caretOffset)) {
                mainRegion = current;
                continue;
            }
            regions.add(current);
        }
        if (mainRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        regions.add(0, mainRegion);
        this.region = new SyncDocumentRegion(this.doc, regions);
        if (this.doc instanceof BaseDocument) {
            BaseDocument bdoc = (BaseDocument)this.doc;
            bdoc.addPostModificationDocumentListener((DocumentListener)this);
            UndoableWrapper wrapper = (UndoableWrapper)MimeLookup.getLookup((String)"text/x-java").lookup(UndoableWrapper.class);
            if (wrapper != null) {
                wrapper.setActive(true, this);
            }
            CancelInstantRenameUndoableEdit undo = new CancelInstantRenameUndoableEdit(this);
            for (UndoableEditListener l : bdoc.getUndoableEditListeners()) {
                l.undoableEditHappened(new UndoableEditEvent(this.doc, undo));
            }
        }
        target.addKeyListener(this);
        target.putClientProperty(InstantRefactoringPerformer.class, this);
        target.putClientProperty("NetBeansEditor.navigateBoundaries", mainRegion);
        this.requestRepaint();
        target.select(mainRegion.getStartOffset(), mainRegion.getEndOffset());
        this.span = this.region.getFirstRegionLength();
        this.compl = new CompletionLayout(this);
        this.compl.setEditorComponent(target);
        final KeyStroke OKKS = ui.getKeyStroke();
        target.getInputMap(1).put(OKKS, OKActionKey);
        AbstractAction OKAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (registry.contains(InstantRefactoringPerformer.this)) {
                    InstantRefactoringPerformer.this.doFullRefactoring();
                    target.getInputMap(1).remove(OKKS);
                    target.getActionMap().remove(InstantRefactoringPerformer.OKActionKey);
                } else {
                    target.getInputMap(1).remove(OKKS);
                    target.getActionMap().remove(InstantRefactoringPerformer.OKActionKey);
                }
            }
        };
        target.getActionMap().put(OKActionKey, OKAction);
        KeyStroke keyStroke = ui.getKeyStroke();
        this.compl.showCompletion(ui.getOptions(), caretOffset, Bundle.INFO_PressAgain(InstantRefactoringPerformer.getKeyStrokeAsText(keyStroke)));
        registry.add(this);
    }

    private void doFullRefactoring() {
        InstantRefactoringPerformer.releaseAll();
        final TopComponent activetc = TopComponent.getRegistry().getActivated();
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                ContextAnalyzer.SHOW.show(InstantRefactoringPerformer.this.ui.getRefactoringUI(), activetc);
            }
        };
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIUtilities.runWhenScanFinished(task, "Instant Refactoring");
                }
            });
        } else {
            UIUtilities.runWhenScanFinished(task, "Instant Refactoring");
        }
    }

    private static void releaseAll() {
        Iterator<InstantRefactoringPerformer> it = registry.iterator();
        while (it.hasNext()) {
            it.next().release(true);
            it.remove();
        }
    }

    private static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        if ((modifiers & 0x80) > 0) {
            sb.append("Ctrl+");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append("Alt+");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append("Shift+");
        }
        if ((modifiers & 0x100) > 0) {
            sb.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(org.openide.util.Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        sb.append('\'');
        return sb.toString();
    }

    private static boolean isIn(MutablePositionRegion region, int caretOffset) {
        return region.getStartOffset() <= caretOffset && caretOffset <= region.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        if (e.getOffset() < this.region.getFirstRegionStartOffset() || e.getOffset() + e.getLength() > this.region.getFirstRegionEndOffset()) {
            this.release(true);
            return;
        }
        this.inSync = true;
        this.region.sync();
        this.span = this.region.getFirstRegionLength();
        this.ui.updateInput(this.getRegionText(0));
        this.inSync = false;
        this.requestRepaint();
    }

    private String getRegionText(int regionIndex) {
        try {
            MutablePositionRegion r = this.region.getRegion(regionIndex);
            int offset = r.getStartOffset();
            int length = r.getEndOffset() - offset;
            return this.doc.getText(offset, length);
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        if (e.getLength() == 1) {
            if (e.getOffset() < this.region.getFirstRegionStartOffset() || e.getOffset() > this.region.getFirstRegionEndOffset()) {
                this.release(true);
                return;
            }
            if (e.getOffset() == this.region.getFirstRegionStartOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "e.getOffset()={0}", e.getOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionStartOffset()={0}", this.region.getFirstRegionStartOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionEndOffset()={0}", this.region.getFirstRegionEndOffset());
                    LOG.log(Level.FINE, "span= {0}", this.span);
                }
                this.release(true);
                return;
            }
            if (e.getOffset() == this.region.getFirstRegionEndOffset() && this.region.getFirstRegionLength() > 0 && this.region.getFirstRegionLength() == this.span) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "e.getOffset()={0}", e.getOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionStartOffset()={0}", this.region.getFirstRegionStartOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionEndOffset()={0}", this.region.getFirstRegionEndOffset());
                    LOG.log(Level.FINE, "span= {0}", this.span);
                }
                this.release(true);
                return;
            }
            if (e.getOffset() == this.region.getFirstRegionEndOffset() && e.getOffset() == this.region.getFirstRegionStartOffset() && this.region.getFirstRegionLength() == 0 && this.region.getFirstRegionLength() == this.span) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "e.getOffset()={0}", e.getOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionStartOffset()={0}", this.region.getFirstRegionStartOffset());
                    LOG.log(Level.FINE, "region.getFirstRegionEndOffset()={0}", this.region.getFirstRegionEndOffset());
                    LOG.log(Level.FINE, "span= {0}", this.span);
                }
                this.release(true);
                return;
            }
        } else {
            int removeSpan = e.getLength() + this.region.getFirstRegionLength();
            if (this.span < removeSpan) {
                this.release(true);
                return;
            }
        }
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.target);
        Boolean ovr = (Boolean)editorUI.getProperty((Object)"overwriteMode");
        if (this.doc.getProperty("doc-replace-selection-property") != null || ovr != null && ovr.booleanValue()) {
            return;
        }
        this.inSync = true;
        this.region.sync();
        this.span = this.region.getFirstRegionLength();
        this.inSync = false;
        this.requestRepaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getModifiers() == 0 || e.getKeyCode() == 10 && e.getModifiers() == 0) {
            this.release(e.getKeyCode() == 27);
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private synchronized void release(boolean cancel) {
        if (this.compl != null) {
            this.compl.hideCompletion();
            this.compl = null;
        }
        if (this.target == null) {
            return;
        }
        UndoableWrapper wrapper = (UndoableWrapper)MimeLookup.getLookup((String)"text/x-java").lookup(UndoableWrapper.class);
        if (wrapper != null) {
            wrapper.setActive(false, null);
            wrapper.close(true);
        }
        this.target.putClientProperty("NetBeansEditor.navigateBoundaries", null);
        this.target.putClientProperty(InstantRefactoringPerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).removePostModificationDocumentListener((DocumentListener)this);
        }
        this.target.removeKeyListener(this);
        this.target.getInputMap(1).remove(this.ui.getKeyStroke());
        this.target.getActionMap().remove(OKActionKey);
        this.target = null;
        this.region = null;
        this.attribs = null;
        this.requestRepaint();
        this.doc = null;
        if (!cancel) {
            DialogDescriptor descriptor = new DialogDescriptor((Object)new JPanel(), this.ui.getName(), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, null, 0, null, null);
            this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(descriptor);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    InstantRefactoringPerformer.this.dialog.setVisible(true);
                    if (InstantRefactoringPerformer.this.ui != null) {
                        InstantRefactoringPerformer.this.ui.getRefactoring().cancelRequest();
                    }
                    InstantRefactoringPerformer.this.dialog.dispose();
                    InstantRefactoringPerformer.this.dialog = null;
                }
            });
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RefactoringSession session = RefactoringSession.create((String)InstantRefactoringPerformer.this.ui.getName());
                    session.addProgressListener((ProgressListener)InstantRefactoringPerformer.this);
                    InstantRefactoringPerformer.this.ui.getRefactoring().addProgressListener((ProgressListener)InstantRefactoringPerformer.this);
                    InstantRefactoringPerformer.this.ui.getRefactoring().prepare(session);
                    if (InstantRefactoringPerformer.this.dialog != null && InstantRefactoringPerformer.this.dialog.isVisible()) {
                        InstantRefactoringPerformer.this.dialog.getContentPane().setEnabled(false);
                        try {
                            session.doRefactoring(true);
                        }
                        finally {
                            session.removeProgressListener((ProgressListener)InstantRefactoringPerformer.this);
                            InstantRefactoringPerformer.this.ui.getRefactoring().removeProgressListener((ProgressListener)InstantRefactoringPerformer.this);
                            InstantRefactoringPerformer.this.ui = null;
                            InstantRefactoringPerformer.this.dialog.setVisible(false);
                        }
                    }
                }
            });
        }
    }

    private void requestRepaint() {
        if (this.region == null) {
            OffsetsBag bag = InstantRefactoringPerformer.getHighlightsBag(this.doc);
            bag.clear();
        } else {
            if (this.attribs == null) {
                this.attribs = InstantRefactoringPerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext");
                Color foreground = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                Color background = (Color)this.attribs.getAttribute(StyleConstants.Background);
                this.attribsLeft = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, background, EditorStyleConstants.LeftBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
                this.attribsRight = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, background, EditorStyleConstants.RightBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
                this.attribsMiddle = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, background, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
                this.attribsAll = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, background, EditorStyleConstants.LeftBorderLineColor, foreground, EditorStyleConstants.RightBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
                this.attribsSlave = InstantRefactoringPerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext-slave");
                Color slaveForeground = (Color)this.attribsSlave.getAttribute(StyleConstants.Foreground);
                Color slaveBackground = (Color)this.attribsSlave.getAttribute(StyleConstants.Background);
                this.attribsSlaveLeft = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, slaveBackground, EditorStyleConstants.LeftBorderLineColor, slaveForeground, EditorStyleConstants.TopBorderLineColor, slaveForeground, EditorStyleConstants.BottomBorderLineColor, slaveForeground);
                this.attribsSlaveRight = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, slaveBackground, EditorStyleConstants.RightBorderLineColor, slaveForeground, EditorStyleConstants.TopBorderLineColor, slaveForeground, EditorStyleConstants.BottomBorderLineColor, slaveForeground);
                this.attribsSlaveMiddle = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, slaveBackground, EditorStyleConstants.TopBorderLineColor, slaveForeground, EditorStyleConstants.BottomBorderLineColor, slaveForeground);
                this.attribsSlaveAll = InstantRefactoringPerformer.createAttribs(StyleConstants.Background, slaveBackground, EditorStyleConstants.LeftBorderLineColor, slaveForeground, EditorStyleConstants.RightBorderLineColor, slaveForeground, EditorStyleConstants.TopBorderLineColor, slaveForeground, EditorStyleConstants.BottomBorderLineColor, slaveForeground);
            }
            OffsetsBag nue = new OffsetsBag(this.doc);
            for (int i = 0; i < this.region.getRegionCount(); ++i) {
                int startOffset = this.region.getRegion(i).getStartOffset();
                int endOffset = this.region.getRegion(i).getEndOffset();
                int size = this.region.getRegion(i).getLength();
                if (size == 1) {
                    nue.addHighlight(startOffset, endOffset, i == 0 ? this.attribsAll : this.attribsSlaveAll);
                    continue;
                }
                if (size <= 1) continue;
                nue.addHighlight(startOffset, startOffset + 1, i == 0 ? this.attribsLeft : this.attribsSlaveLeft);
                nue.addHighlight(endOffset - 1, endOffset, i == 0 ? this.attribsRight : this.attribsSlaveRight);
                if (size <= 2) continue;
                nue.addHighlight(startOffset + 1, endOffset - 1, i == 0 ? this.attribsMiddle : this.attribsSlaveMiddle);
            }
            OffsetsBag bag = InstantRefactoringPerformer.getHighlightsBag(this.doc);
            bag.setHighlights(nue);
        }
    }

    private static AttributeSet getSyncedTextBlocksHighlight(String name) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet as = fcs != null ? fcs.getFontColors(name) : null;
        return as == null ? defaultSyncedTextBlocksHighlight : as;
    }

    private static AttributeSet createAttribs(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = keyValuePairs.length / 2 - 1; i >= 0; --i) {
            Object attrKey = keyValuePairs[2 * i];
            Object attrValue = keyValuePairs[2 * i + 1];
            if (attrKey == null || attrValue == null) continue;
            list.add(attrKey);
            list.add(attrValue);
        }
        return AttributesUtilities.createImmutable((Object[])list.toArray());
    }

    public static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(InstantRefactoringPerformer.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(InstantRefactoringPerformer.class, bag);
            Object stream = doc.getProperty("stream");
            if (stream instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "Instant Rename Highlights Bag", new Object[]{((DataObject)stream).getPrimaryFile(), bag});
            }
        }
        return bag;
    }

    public void start(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InstantRefactoringPerformer.this.progressBar != null && InstantRefactoringPerformer.this.progressBar.isVisible()) {
                    LOG.log(Level.INFO, "{0} called start multiple times", event.getSource());
                    InstantRefactoringPerformer.this.stop(event);
                }
                InstantRefactoringPerformer.this.progressHandle = ProgressHandleFactory.createHandle((String)"");
                InstantRefactoringPerformer.this.progressBar = ProgressBar.create(InstantRefactoringPerformer.this.progressHandle);
                if (event.getCount() == -1) {
                    InstantRefactoringPerformer.this.isIndeterminate = true;
                    InstantRefactoringPerformer.this.progressHandle.start();
                    InstantRefactoringPerformer.this.progressHandle.switchToIndeterminate();
                } else {
                    InstantRefactoringPerformer.this.isIndeterminate = false;
                    InstantRefactoringPerformer.this.progressHandle.start(event.getCount());
                }
                InstantRefactoringPerformer.this.progressBar.setString(switch (event.getOperationType()) {
                    case 2 -> NbBundle.getMessage(InstantRefactoringPerformer.class, (String)"LBL_ParametersCheck");
                    case 3 -> NbBundle.getMessage(InstantRefactoringPerformer.class, (String)"LBL_Prepare");
                    case 1 -> NbBundle.getMessage(InstantRefactoringPerformer.class, (String)"LBL_PreCheck");
                    default -> NbBundle.getMessage(InstantRefactoringPerformer.class, (String)"LBL_Usages");
                });
                InstantRefactoringPerformer.this.dialog.getContentPane().add(InstantRefactoringPerformer.this.progressBar);
                InstantRefactoringPerformer.this.dialog.pack();
            }
        });
    }

    public void step(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (InstantRefactoringPerformer.this.progressHandle == null) {
                        return;
                    }
                    if (InstantRefactoringPerformer.this.isIndeterminate && event.getCount() > 0) {
                        InstantRefactoringPerformer.this.progressHandle.switchToDeterminate(event.getCount());
                        InstantRefactoringPerformer.this.isIndeterminate = false;
                    } else {
                        InstantRefactoringPerformer.this.progressHandle.progress(InstantRefactoringPerformer.this.isIndeterminate ? -2 : event.getCount());
                    }
                }
                catch (Throwable e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    public void stop(ProgressEvent event) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (InstantRefactoringPerformer.this.progressHandle == null) {
                    return;
                }
                InstantRefactoringPerformer.this.progressHandle.finish();
                InstantRefactoringPerformer.this.progressHandle = null;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Set<MutablePositionRegion> newChangePoints;
        if (!evt.getOldValue().equals(evt.getNewValue()) && evt.getSource() instanceof InstantOption && (newChangePoints = this.ui.optionChanged((InstantOption)evt.getSource())) != null) {
            MutablePositionRegion mainRegion = this.region.getRegion(0);
            if (!newChangePoints.contains(mainRegion)) {
                throw new IllegalArgumentException("MainRegion not part of the new change points.");
            }
            ArrayList<MutablePositionRegion> regions = new ArrayList<MutablePositionRegion>(newChangePoints.size());
            for (MutablePositionRegion current : newChangePoints) {
                if (current == mainRegion) continue;
                regions.add(current);
            }
            regions.add(0, mainRegion);
            this.inSync = true;
            this.region.updateRegions(regions);
            this.inSync = false;
            this.requestRepaint();
        }
    }

    public static class UndoableWrapper
    implements UndoableEditWrapper {
        private AtomicBoolean active = new AtomicBoolean(false);
        private Map<BaseDocument, UndoableEditDelegate> docToFirst = new HashMap<BaseDocument, UndoableEditDelegate>();
        private InstantRefactoringPerformer performer;

        public UndoableEdit wrap(UndoableEdit ed, Document doc) {
            if (!this.active.get()) {
                return ed;
            }
            if (doc.getProperty("stream") == null) {
                return ed;
            }
            UndoableEditDelegate current = new UndoableEditDelegate(ed, (BaseDocument)doc, this.performer);
            UndoableEditDelegate first = this.docToFirst.get(doc);
            if (first == null) {
                this.docToFirst.put((BaseDocument)doc, current);
            }
            return current;
        }

        public void setActive(boolean b, InstantRefactoringPerformer performer) {
            this.performer = performer;
            this.active.set(b);
        }

        public void close(boolean cancel) {
            for (UndoableEditDelegate first : this.docToFirst.values()) {
                first.end();
                if (!cancel) continue;
                first.undo();
                first.die();
            }
            this.docToFirst.clear();
        }

        public class UndoableEditDelegate
        implements UndoableEdit {
            private CloneableEditorSupport ces;
            private UndoableEdit delegate;
            private CompoundEdit inner;
            private InstantRefactoringPerformer performer;

            private UndoableEditDelegate(UndoableEdit ed, BaseDocument doc, InstantRefactoringPerformer performer) {
                DataObject dob = (DataObject)doc.getProperty((Object)"stream");
                this.ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
                this.inner = new CompoundEdit();
                this.inner.addEdit(ed);
                this.delegate = ed;
                this.performer = performer;
            }

            @Override
            public void undo() throws CannotUndoException {
                this.inner.undo();
            }

            @Override
            public boolean canUndo() {
                return this.inner.canUndo();
            }

            @Override
            public void redo() throws CannotRedoException {
                this.inner.redo();
            }

            @Override
            public boolean canRedo() {
                return this.inner.canRedo();
            }

            @Override
            public void die() {
                this.inner.die();
            }

            @Override
            public boolean addEdit(UndoableEdit ue) {
                if (ue instanceof List) {
                    boolean refatoringEditOnly;
                    List listEdit = (List)((Object)ue);
                    UndoableEdit topEdit = (UndoableEdit)listEdit.get(listEdit.size() - 1);
                    boolean bl = refatoringEditOnly = listEdit.size() == 2;
                    if (refatoringEditOnly && topEdit instanceof UndoableEditDelegate) {
                        this.inner.addEdit((UndoableEdit)listEdit.get(0));
                        return true;
                    }
                    return false;
                }
                return false;
            }

            public UndoableEdit unwrap() {
                return this.delegate;
            }

            @Override
            public boolean replaceEdit(UndoableEdit ue) {
                return this.inner.replaceEdit(ue);
            }

            @Override
            public boolean isSignificant() {
                return this.inner.isSignificant();
            }

            @Override
            public String getPresentationName() {
                return "Rename";
            }

            @Override
            public String getUndoPresentationName() {
                return "Undo Rename";
            }

            @Override
            public String getRedoPresentationName() {
                return "Redo Rename";
            }

            private void end() {
                this.inner.end();
            }
        }
    }

    private static class CancelInstantRenameUndoableEdit
    extends AbstractUndoableEdit {
        private final Reference<InstantRefactoringPerformer> performer;

        public CancelInstantRenameUndoableEdit(InstantRefactoringPerformer performer) {
            this.performer = new WeakReference<InstantRefactoringPerformer>(performer);
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            InstantRefactoringPerformer perf = this.performer.get();
            if (perf != null) {
                perf.release(true);
            }
        }
    }

    public static class RenameDeletedTextInterceptor
    implements DeletedTextInterceptor {
        public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
            Object getObject = context.getComponent().getClientProperty(InstantRefactoringPerformer.class);
            if (getObject instanceof InstantRefactoringPerformer) {
                InstantRefactoringPerformer instantRenamePerformer = (InstantRefactoringPerformer)getObject;
                MutablePositionRegion region = instantRenamePerformer.region.getRegion(0);
                return context.isBackwardDelete() && region.getStartOffset() == context.getOffset() || !context.isBackwardDelete() && region.getEndOffset() == context.getOffset();
            }
            return false;
        }

        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        }

        public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        }

        public void cancelled(DeletedTextInterceptor.Context context) {
        }

        public static class Factory
        implements DeletedTextInterceptor.Factory {
            public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
                return new RenameDeletedTextInterceptor();
            }
        }
    }

    public static class AllRefactoringsPluginFactory
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            return new RefactoringPluginImpl();
        }

        private static final class RefactoringPluginImpl
        implements RefactoringPlugin {
            private RefactoringPluginImpl() {
            }

            public Problem preCheck() {
                return null;
            }

            public Problem checkParameters() {
                return null;
            }

            public Problem fastCheckParameters() {
                return null;
            }

            public void cancelRequest() {
            }

            public Problem prepare(RefactoringElementsBag refactoringElements) {
                refactoringElements.getSession().addProgressListener(new ProgressListener(){

                    public void start(ProgressEvent event) {
                        InstantRefactoringPerformer[] performers;
                        for (InstantRefactoringPerformer p : performers = registry.toArray(new InstantRefactoringPerformer[0])) {
                            p.inSync = true;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (InstantRefactoringPerformer p : performers) {
                                    p.release(true);
                                }
                            }
                        });
                    }

                    public void step(ProgressEvent event) {
                    }

                    public void stop(ProgressEvent event) {
                    }
                });
                return null;
            }
        }
    }

    private static class ProgressBar
    extends JPanel {
        private JLabel label;

        private static ProgressBar create(ProgressHandle handle) {
            ProgressBar instance = new ProgressBar();
            instance.setLayout(new BorderLayout());
            instance.label = new JLabel(" ");
            instance.label.setBorder(new EmptyBorder(0, 0, 2, 0));
            instance.add((Component)instance.label, "North");
            JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
            instance.add((Component)progress, "Center");
            return instance;
        }

        public void setString(String value) {
            this.label.setText(value);
        }

        private ProgressBar() {
        }
    }
}

