/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.nbparser;

import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.netbeans.modules.css.lib.nbparser.ProgressingFailedException;

public class ProgressingTokenStream
implements TokenStream {
    private final int maxReadCalls;
    private final TokenStream backingStream;
    private int highestReachedIndex = 0;
    private int readCalls = 0;

    public ProgressingTokenStream(int maxReadCalls, TokenStream backingStream) {
        this.maxReadCalls = maxReadCalls;
        this.backingStream = backingStream;
    }

    public Token LT(int k) {
        Token t = this.backingStream.LT(k);
        this.limitReadCalls(t);
        return t;
    }

    public Token get(int i) {
        Token t = this.backingStream.get(i);
        this.limitReadCalls(t);
        return t;
    }

    private void limitReadCalls(Token t) throws RuntimeException {
        int index = t.getTokenIndex();
        if (index > this.highestReachedIndex) {
            this.highestReachedIndex = index;
            this.readCalls = 0;
        }
        ++this.readCalls;
        if (this.readCalls > this.maxReadCalls) {
            throw new ProgressingFailedException("Excessive read calls");
        }
    }

    public int range() {
        return this.backingStream.range();
    }

    public TokenSource getTokenSource() {
        return this.backingStream.getTokenSource();
    }

    public String toString(int i, int i1) {
        return this.backingStream.toString(i, i1);
    }

    public String toString(Token token, Token token1) {
        return this.backingStream.toString(token, token1);
    }

    public void consume() {
        this.backingStream.consume();
    }

    public int LA(int i) {
        return this.backingStream.LA(i);
    }

    public int mark() {
        return this.backingStream.mark();
    }

    public int index() {
        return this.backingStream.index();
    }

    public void rewind(int i) {
        this.backingStream.rewind(i);
    }

    public void rewind() {
        this.backingStream.rewind();
    }

    public void release(int i) {
        this.backingStream.release(i);
    }

    public void seek(int i) {
        this.backingStream.seek(i);
    }

    public int size() {
        return this.backingStream.size();
    }

    public String getSourceName() {
        return this.backingStream.getSourceName();
    }
}

