/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.util.StructMap;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class RecordedXMLReader
extends XMLReaderBase {
    protected static final QName EMPTY_QNAME = new QName("fooqname");
    int frameIndex = 0;
    List frames = new ArrayList();
    ReaderFrame currentFrame;
    NamespaceSupport originalNamespaces;
    NamespaceSupport namespaceSupport;
    boolean lastRetWasEnd;

    public RecordedXMLReader(XMLReader reader, NamespaceSupport namespaces) {
        this.originalNamespaces = new NamespaceSupport(namespaces);
        this.namespaceSupport = new NamespaceSupport(namespaces);
        this.lastRetWasEnd = false;
        int targetElementId = reader.getElementId();
        while (reader.getState() != 2 || reader.getElementId() != targetElementId) {
            this.recordFrame(reader);
            reader.next();
        }
        this.recordFrame(reader);
        this.setFrame(0);
    }

    protected void recordFrame(XMLReader reader) {
        AttributeFrame attributeFrame = null;
        switch (reader.getState()) {
            case 1: {
                attributeFrame = new AttributeFrame(reader.getAttributes());
            }
            case 2: {
                this.addFrame(new ReaderFrame(reader.getState(), reader.getElementId(), reader.getLineNumber(), reader.getName(), attributeFrame));
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.addFrame(new ReaderFrame(reader.getState(), reader.getElementId(), reader.getLineNumber(), reader.getValue()));
            }
        }
    }

    protected void addFrame(ReaderFrame frame) {
        this.frames.add(frame);
    }

    protected ReaderFrame getFrame(int index) {
        return (ReaderFrame)this.frames.get(index);
    }

    protected void setFrame(int index) {
        this.currentFrame = this.getFrame(index);
        this.frameIndex = index;
    }

    protected void nextFrame() {
        this.setFrame(this.frameIndex + 1);
    }

    public void reset() {
        this.frameIndex = 0;
        this.lastRetWasEnd = false;
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public int getState() {
        return this.currentFrame.state;
    }

    @Override
    public QName getName() {
        return this.currentFrame.name;
    }

    @Override
    public String getURI() {
        return this.getName().getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public Attributes getAttributes() {
        return this.currentFrame.attributes;
    }

    @Override
    public String getValue() {
        return this.currentFrame.value;
    }

    @Override
    public int getElementId() {
        return this.currentFrame.elementId;
    }

    @Override
    public int getLineNumber() {
        return this.currentFrame.lineNumber;
    }

    @Override
    public String getURI(String prefix) {
        return this.namespaceSupport.getURI(prefix);
    }

    @Override
    public Iterator getPrefixes() {
        return this.namespaceSupport.getPrefixes();
    }

    @Override
    public int next() {
        if (this.frameIndex + 1 >= this.frames.size() - 1) {
            return 5;
        }
        this.nextFrame();
        int ret = this.getState();
        if (this.lastRetWasEnd) {
            this.namespaceSupport.popContext();
            this.lastRetWasEnd = false;
        }
        if (ret == 1) {
            this.namespaceSupport.pushContext();
            Attributes attributes = this.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.isNamespaceDeclaration(i)) continue;
                String prefix = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                this.namespaceSupport.declarePrefix(prefix, value);
            }
        } else if (ret == 2) {
            this.lastRetWasEnd = true;
        }
        return ret;
    }

    @Override
    public XMLReader recordElement() {
        return new RecordedXMLReader(this, this.namespaceSupport);
    }

    @Override
    public void skipElement(int elementId) {
        while (this.currentFrame.state != 5 && (this.currentFrame.state != 2 || this.currentFrame.elementId != elementId)) {
            if (this.next() != 5) continue;
            return;
        }
    }

    static class AttributeFrame
    implements Attributes {
        private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
        StructMap recordedAttributes = new StructMap();
        List qnames = null;
        List qnameLocalParts = null;
        List values = null;

        AttributeFrame(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.recordedAttributes.put(attributes.getName(i), attributes.getValue(i));
            }
        }

        List getQNames() {
            if (this.qnames == null) {
                this.qnames = (List)this.recordedAttributes.keys();
            }
            return this.qnames;
        }

        List getQNameLocalParts() {
            ArrayList tempQNames = new ArrayList();
            if (this.qnames == null) {
                this.qnames = (List)this.recordedAttributes.keys();
            }
            if (this.qnameLocalParts == null) {
                this.qnameLocalParts = new ArrayList();
            }
            for (int i = 0; i < this.qnames.size(); ++i) {
                QName qname = (QName)this.qnames.get(i);
                this.qnameLocalParts.add(qname.getLocalPart());
            }
            return this.qnameLocalParts;
        }

        List getValues() {
            if (this.values == null) {
                this.values = (List)this.recordedAttributes.values();
            }
            return this.values;
        }

        @Override
        public int getIndex(QName name) {
            List qnames = this.getQNames();
            for (int i = 0; i < qnames.size(); ++i) {
                if (!qnames.get(i).equals(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            List qnames = this.getQNames();
            for (int i = 0; i < qnames.size(); ++i) {
                QName qname = (QName)qnames.get(i);
                if (!qname.getNamespaceURI().equals(uri) || !qname.getLocalPart().equals(localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String localName) {
            List qnames = this.getQNames();
            for (int i = 0; i < qnames.size(); ++i) {
                QName qname = (QName)qnames.get(i);
                if (!qname.getLocalPart().equals(localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.recordedAttributes.size();
        }

        @Override
        public String getLocalName(int index) {
            return this.getName(index).getLocalPart();
        }

        @Override
        public QName getName(int index) {
            List qnames = this.getQNames();
            return (QName)qnames.get(index);
        }

        @Override
        public String getPrefix(int index) {
            QName qname = this.getName(index);
            return XmlUtil.getPrefix(qname.getNamespaceURI());
        }

        @Override
        public String getURI(int index) {
            return this.getName(index).getNamespaceURI();
        }

        @Override
        public String getValue(int index) {
            if (index == -1) {
                return null;
            }
            List values = this.getValues();
            return (String)values.get(index);
        }

        @Override
        public String getValue(QName name) {
            return this.getValue(this.getIndex(name));
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        @Override
        public String getValue(String localName) {
            return this.getValue(this.getIndex(localName));
        }

        @Override
        public boolean isNamespaceDeclaration(int index) {
            return this.getURI(index) == XMLNS_NAMESPACE_URI;
        }
    }

    static class ReaderFrame {
        QName name;
        int state;
        Attributes attributes;
        String value;
        int elementId;
        int lineNumber;

        ReaderFrame(int state) {
            this.state = state;
            this.name = EMPTY_QNAME;
            this.attributes = null;
            this.value = null;
            this.elementId = -1;
            this.lineNumber = 0;
        }

        ReaderFrame(int state, int elementId, int lineNumber) {
            this(state);
            this.elementId = elementId;
            this.lineNumber = lineNumber;
        }

        ReaderFrame(int state, int elementId, int lineNumber, QName name, Attributes attributes) {
            this(state, elementId, lineNumber);
            this.name = name;
            this.attributes = attributes;
        }

        ReaderFrame(int state, int elementId, int lineNumber, String value) {
            this(state, elementId, lineNumber);
            this.value = value;
        }
    }
}

