/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ExportImageDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="destinationType")
@JsonFilter(value="explicitlySetFilter")
public final class ExportImageViaObjectStorageUriDetails
extends ExportImageDetails {
    @JsonProperty(value="destinationUri")
    private final String destinationUri;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExportImageViaObjectStorageUriDetails(ExportImageDetails.ExportFormat exportFormat, String destinationUri) {
        super(exportFormat);
        this.destinationUri = destinationUri;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportImageViaObjectStorageUriDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", destinationUri=").append(String.valueOf(this.destinationUri));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportImageViaObjectStorageUriDetails)) {
            return false;
        }
        ExportImageViaObjectStorageUriDetails other = (ExportImageViaObjectStorageUriDetails)((Object)o);
        return Objects.equals(this.destinationUri, other.destinationUri) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.destinationUri == null ? 43 : this.destinationUri.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exportFormat")
        private ExportImageDetails.ExportFormat exportFormat;
        @JsonProperty(value="destinationUri")
        private String destinationUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exportFormat(ExportImageDetails.ExportFormat exportFormat) {
            this.exportFormat = exportFormat;
            this.__explicitlySet__.add("exportFormat");
            return this;
        }

        public Builder destinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
            this.__explicitlySet__.add("destinationUri");
            return this;
        }

        public ExportImageViaObjectStorageUriDetails build() {
            ExportImageViaObjectStorageUriDetails model = new ExportImageViaObjectStorageUriDetails(this.exportFormat, this.destinationUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportImageViaObjectStorageUriDetails model) {
            if (model.wasPropertyExplicitlySet("exportFormat")) {
                this.exportFormat(model.getExportFormat());
            }
            if (model.wasPropertyExplicitlySet("destinationUri")) {
                this.destinationUri(model.getDestinationUri());
            }
            return this;
        }
    }
}

