/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstancePoolPlacementPrimarySubnet;
import com.oracle.bmc.core.model.InstancePoolPlacementSecondaryVnicSubnet;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClusterNetworkPlacementConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="placementConstraint")
    private final PlacementConstraint placementConstraint;
    @JsonProperty(value="primarySubnetId")
    private final String primarySubnetId;
    @JsonProperty(value="primaryVnicSubnets")
    private final InstancePoolPlacementPrimarySubnet primaryVnicSubnets;
    @JsonProperty(value="secondaryVnicSubnets")
    private final List<InstancePoolPlacementSecondaryVnicSubnet> secondaryVnicSubnets;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "placementConstraint", "primarySubnetId", "primaryVnicSubnets", "secondaryVnicSubnets"})
    public ClusterNetworkPlacementConfigurationDetails(String availabilityDomain, PlacementConstraint placementConstraint, String primarySubnetId, InstancePoolPlacementPrimarySubnet primaryVnicSubnets, List<InstancePoolPlacementSecondaryVnicSubnet> secondaryVnicSubnets) {
        this.availabilityDomain = availabilityDomain;
        this.placementConstraint = placementConstraint;
        this.primarySubnetId = primarySubnetId;
        this.primaryVnicSubnets = primaryVnicSubnets;
        this.secondaryVnicSubnets = secondaryVnicSubnets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public PlacementConstraint getPlacementConstraint() {
        return this.placementConstraint;
    }

    public String getPrimarySubnetId() {
        return this.primarySubnetId;
    }

    public InstancePoolPlacementPrimarySubnet getPrimaryVnicSubnets() {
        return this.primaryVnicSubnets;
    }

    public List<InstancePoolPlacementSecondaryVnicSubnet> getSecondaryVnicSubnets() {
        return this.secondaryVnicSubnets;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterNetworkPlacementConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", placementConstraint=").append(String.valueOf((Object)this.placementConstraint));
        sb.append(", primarySubnetId=").append(String.valueOf(this.primarySubnetId));
        sb.append(", primaryVnicSubnets=").append(String.valueOf((Object)this.primaryVnicSubnets));
        sb.append(", secondaryVnicSubnets=").append(String.valueOf(this.secondaryVnicSubnets));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterNetworkPlacementConfigurationDetails)) {
            return false;
        }
        ClusterNetworkPlacementConfigurationDetails other = (ClusterNetworkPlacementConfigurationDetails)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.placementConstraint, (Object)other.placementConstraint) && Objects.equals(this.primarySubnetId, other.primarySubnetId) && Objects.equals((Object)this.primaryVnicSubnets, (Object)other.primaryVnicSubnets) && Objects.equals(this.secondaryVnicSubnets, other.secondaryVnicSubnets) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.placementConstraint == null ? 43 : this.placementConstraint.hashCode());
        result = result * 59 + (this.primarySubnetId == null ? 43 : this.primarySubnetId.hashCode());
        result = result * 59 + (this.primaryVnicSubnets == null ? 43 : this.primaryVnicSubnets.hashCode());
        result = result * 59 + (this.secondaryVnicSubnets == null ? 43 : this.secondaryVnicSubnets.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PlacementConstraint implements BmcEnum
    {
        SingleTier("SINGLE_TIER"),
        SingleBlock("SINGLE_BLOCK"),
        PackedDistributionMultiBlock("PACKED_DISTRIBUTION_MULTI_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlacementConstraint> map;

        private PlacementConstraint(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlacementConstraint create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlacementConstraint', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlacementConstraint.class);
            map = new HashMap<String, PlacementConstraint>();
            for (PlacementConstraint v : PlacementConstraint.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="placementConstraint")
        private PlacementConstraint placementConstraint;
        @JsonProperty(value="primarySubnetId")
        private String primarySubnetId;
        @JsonProperty(value="primaryVnicSubnets")
        private InstancePoolPlacementPrimarySubnet primaryVnicSubnets;
        @JsonProperty(value="secondaryVnicSubnets")
        private List<InstancePoolPlacementSecondaryVnicSubnet> secondaryVnicSubnets;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder placementConstraint(PlacementConstraint placementConstraint) {
            this.placementConstraint = placementConstraint;
            this.__explicitlySet__.add("placementConstraint");
            return this;
        }

        public Builder primarySubnetId(String primarySubnetId) {
            this.primarySubnetId = primarySubnetId;
            this.__explicitlySet__.add("primarySubnetId");
            return this;
        }

        public Builder primaryVnicSubnets(InstancePoolPlacementPrimarySubnet primaryVnicSubnets) {
            this.primaryVnicSubnets = primaryVnicSubnets;
            this.__explicitlySet__.add("primaryVnicSubnets");
            return this;
        }

        public Builder secondaryVnicSubnets(List<InstancePoolPlacementSecondaryVnicSubnet> secondaryVnicSubnets) {
            this.secondaryVnicSubnets = secondaryVnicSubnets;
            this.__explicitlySet__.add("secondaryVnicSubnets");
            return this;
        }

        public ClusterNetworkPlacementConfigurationDetails build() {
            ClusterNetworkPlacementConfigurationDetails model = new ClusterNetworkPlacementConfigurationDetails(this.availabilityDomain, this.placementConstraint, this.primarySubnetId, this.primaryVnicSubnets, this.secondaryVnicSubnets);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterNetworkPlacementConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("placementConstraint")) {
                this.placementConstraint(model.getPlacementConstraint());
            }
            if (model.wasPropertyExplicitlySet("primarySubnetId")) {
                this.primarySubnetId(model.getPrimarySubnetId());
            }
            if (model.wasPropertyExplicitlySet("primaryVnicSubnets")) {
                this.primaryVnicSubnets(model.getPrimaryVnicSubnets());
            }
            if (model.wasPropertyExplicitlySet("secondaryVnicSubnets")) {
                this.secondaryVnicSubnets(model.getSecondaryVnicSubnets());
            }
            return this;
        }
    }
}

