/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.RawParameterizedSqlStatement;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.storage.jpa.JpaHashUtils;

public class FederatedUserAttributeTextColumnMigration
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        if (this.database instanceof MySQLDatabase) {
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT t.ID, t.VALUE  FROM " + this.getTableName("FED_USER_ATTRIBUTE") + " t  WHERE LENGTH(t.VALUE) > 2024");
                 ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    String id = resultSet.getString(1);
                    String value = resultSet.getString(2);
                    if (value.length() <= 2024) continue;
                    this.statements.add(new RawParameterizedSqlStatement("UPDATE " + this.getTableName("FED_USER_ATTRIBUTE") + " SET VALUE = null, LONG_VALUE_HASH = ?, LONG_VALUE_HASH_LOWER_CASE = ?, LONG_VALUE = ? WHERE ID = ?", new Object[]{JpaHashUtils.hashForAttributeValue(value), JpaHashUtils.hashForAttributeValueLowerCase(value), value, id}));
                }
            }
            catch (Exception e) {
                throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
            }
        }
    }

    @Override
    protected String getTaskId() {
        return "Leave only single offline session per user and client";
    }
}

