/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.loader.ast.internal.AbstractCollectionBatchLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionBatchLoaderArrayParam
extends AbstractCollectionBatchLoader
implements SqlArrayMultiKeyLoader {
    private final Class<?> keyDomainType;
    private final SqlTypedMapping arraySqlTypedMapping;
    private final JdbcParameter jdbcParameter;
    private final SelectStatement sqlSelect;
    private final JdbcOperationQuerySelect jdbcSelectOperation;

    public CollectionBatchLoaderArrayParam(int domainBatchSize, LoadQueryInfluencers loadQueryInfluencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        super(domainBatchSize, loadQueryInfluencers, attributeMapping, sessionFactory);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Batch fetching enabled for collection '%s' using ARRAY strategy with batch size %s", (Object)attributeMapping.getNavigableRole().getFullPath(), (Object)domainBatchSize);
        }
        ForeignKeyDescriptor keyDescriptor = this.getLoadable().getKeyDescriptor();
        SelectableMapping selectable = keyDescriptor.getSelectable(0);
        JdbcMapping jdbcMapping = selectable.getJdbcMapping();
        Class<?> jdbcJavaTypeClass = jdbcMapping.getJdbcJavaType().getJavaTypeClass();
        this.keyDomainType = this.getKeyType(keyDescriptor.getKeyPart());
        this.arraySqlTypedMapping = new SqlTypedMappingImpl(selectable.getColumnDefinition(), selectable.getLength(), selectable.getPrecision(), selectable.getScale(), selectable.getTemporalPrecision(), MultiKeyLoadHelper.resolveArrayJdbcMapping(jdbcMapping, jdbcJavaTypeClass, this.getSessionFactory()));
        this.jdbcParameter = new SqlTypedMappingJdbcParameter(this.arraySqlTypedMapping);
        this.sqlSelect = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), keyDescriptor.getKeyPart(), this.getInfluencers(), new LockOptions(), this.jdbcParameter, this.getSessionFactory());
        QuerySpec querySpec = this.sqlSelect.getQueryPart().getFirstQuerySpec();
        TableGroup tableGroup = querySpec.getFromClause().getRoots().get(0);
        attributeMapping.applySoftDeleteRestrictions(tableGroup, querySpec::applyPredicate);
        this.jdbcSelectOperation = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), this.sqlSelect).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public PersistentCollection<?> load(Object keyBeingLoaded, SharedSessionContractImplementor session) {
        ForeignKeyDescriptor keyDescriptor = this.getLoadable().getKeyDescriptor();
        if (keyDescriptor.isEmbedded() || keyDescriptor.getKeyPart().getSingleJdbcMapping().getValueConverter() != null) {
            assert (keyDescriptor.getJdbcTypeCount() == 1);
            return this.loadWithConversion(keyBeingLoaded, session, keyDescriptor);
        }
        return super.load(keyBeingLoaded, session);
    }

    @AllowReflection
    private PersistentCollection<?> loadWithConversion(Object keyBeingLoaded, SharedSessionContractImplementor session, ForeignKeyDescriptor keyDescriptor) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.trace((Object)("Batch fetching collection: " + MessageHelper.collectionInfoString(this.getLoadable(), keyBeingLoaded)));
        }
        int length = this.getDomainBatchSize();
        Object[] keysToInitialize = (Object[])Array.newInstance(this.jdbcParameter.getExpressionType().getSingleJdbcMapping().getJdbcJavaType().getJavaTypeClass().getComponentType(), length);
        Object[] domainKeys = (Object[])Array.newInstance(this.keyDomainType, length);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(length, (index, key) -> keyDescriptor.forEachJdbcValue(key, (i, value, jdbcMapping) -> {
            keysToInitialize[index] = value;
            domainKeys[index] = key;
        }, session), keyBeingLoaded, this.getLoadable());
        Object[] keys = MultiKeyLoadHelper.trimIdBatch(length, keysToInitialize);
        if (MultiKeyLoadHelper.hasSingleId(keys)) {
            return this.singleKeyLoader.load(keyBeingLoaded, session);
        }
        this.initializeKeys(keyBeingLoaded, keys, session);
        for (Object initializedKey : domainKeys) {
            if (initializedKey == null) continue;
            this.finishInitializingKey(initializedKey, session);
        }
        CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), keyBeingLoaded);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    @Override
    void initializeKeys(Object key, Object[] keysToInitialize, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Collection keys to initialize via batch fetching (%s) %s", (Object)MessageHelper.collectionInfoString(this.getLoadable(), key), (Object)keysToInitialize);
        }
        assert (this.jdbcSelectOperation != null);
        assert (this.jdbcParameter != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(this.jdbcParameter, new JdbcParameterBindingImpl(this.arraySqlTypedMapping.getJdbcMapping(), keysToInitialize));
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), this.sqlSelect, JdbcParametersList.singleton(this.jdbcParameter), jdbcParameterBindings);
        session.getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelectOperation, jdbcParameterBindings, new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
    }

    @Override
    void finishInitializingKeys(Object[] keys, SharedSessionContractImplementor session) {
        for (Object initializedKey : keys) {
            this.finishInitializingKey(initializedKey, session);
        }
    }

    @Override
    Object[] resolveKeysToInitialize(Object keyBeingLoaded, SharedSessionContractImplementor session) {
        assert (!this.getLoadable().getKeyDescriptor().isEmbedded() && this.getLoadable().getKeyDescriptor().getKeyPart().getSingleJdbcMapping().getValueConverter() == null) : "Should use loadWithConversion() instead";
        return super.resolveKeysToInitialize(keyBeingLoaded, session);
    }
}

