/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.deployment;

import org.jboss.logging.Logger;
import org.keycloak.deployment.DeployedConfigurationsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class DeployedConfigurationsManager {
    private static final Logger log = Logger.getLogger(DeployedConfigurationsManager.class);
    private final KeycloakSession session;

    public DeployedConfigurationsManager(KeycloakSession session) {
        this.session = session;
    }

    public void registerDeployedAuthenticatorConfig(AuthenticatorConfigModel model) {
        log.debugf("Register deployed authenticator config: %s", (Object)model.getId());
        ((DeployedConfigurationsProvider)this.session.getProvider(DeployedConfigurationsProvider.class)).registerDeployedAuthenticatorConfig(model);
    }

    public AuthenticatorConfigModel getDeployedAuthenticatorConfig(String configId) {
        return ((DeployedConfigurationsProvider)this.session.getProvider(DeployedConfigurationsProvider.class)).getDeployedAuthenticatorConfigs().filter(config -> configId.equals(config.getId())).findFirst().orElse(null);
    }

    public AuthenticatorConfigModel getAuthenticatorConfig(RealmModel realm, String configId) {
        AuthenticatorConfigModel cfgModel = this.getDeployedAuthenticatorConfig(configId);
        if (cfgModel != null) {
            log.tracef("Found deployed configuration by id: %s", (Object)configId);
            return cfgModel;
        }
        return realm.getAuthenticatorConfigById(configId);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(RealmModel realm, String alias) {
        if (alias == null) {
            return null;
        }
        AuthenticatorConfigModel cfgModel = ((DeployedConfigurationsProvider)this.session.getProvider(DeployedConfigurationsProvider.class)).getDeployedAuthenticatorConfigs().filter(config -> alias.equals(config.getAlias())).findFirst().orElse(null);
        if (cfgModel != null) {
            log.debugf("Found deployed configuration by alias: %s", (Object)alias);
            return cfgModel;
        }
        return realm.getAuthenticatorConfigByAlias(alias);
    }
}

