/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.util.Map;
import java.util.Objects;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.authsession.RootAuthenticationSessionUpdater;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.transaction.AuthenticationSessionChangeLogTransaction;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RemoteInfinispanAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private final KeycloakSession session;
    private final AuthenticationSessionChangeLogTransaction transaction;
    private final int authSessionsLimit;

    public RemoteInfinispanAuthenticationSessionProvider(KeycloakSession session, int authSessionsLimit, AuthenticationSessionChangeLogTransaction transaction) {
        this.session = Objects.requireNonNull(session);
        this.authSessionsLimit = authSessionsLimit;
        this.transaction = Objects.requireNonNull(transaction);
    }

    public void close() {
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        return this.createRootAuthenticationSession(realm, KeycloakModelUtils.generateId());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        RootAuthenticationSessionEntity entity = new RootAuthenticationSessionEntity(id);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        RootAuthenticationSessionUpdater updater = (RootAuthenticationSessionUpdater)this.transaction.create(id, entity);
        updater.initialize(this.session, realm, this.authSessionsLimit);
        return updater;
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        RootAuthenticationSessionUpdater updater = (RootAuthenticationSessionUpdater)this.transaction.get(authenticationSessionId);
        if (updater != null) {
            updater.initialize(this.session, realm, this.authSessionsLimit);
        }
        return updater;
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        this.transaction.remove(authenticationSession.getId());
    }

    public void removeAllExpired() {
    }

    public void removeExpired(RealmModel realm) {
    }

    public void onRealmRemoved(RealmModel realm) {
        this.transaction.removeByRealmId(realm.getId());
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).notify("AUTHENTICATION_SESSION_EVENTS", (ClusterEvent)AuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }
}

