/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBJarResource;
import com.ca.directory.jxplorer.JXplorer;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipException;

public class JXResourceLoader {
    protected HashSet unknownResources = new HashSet();
    protected CBJarResource[] resourceFiles = null;
    protected static boolean debug = false;

    public JXResourceLoader() {
        boolean bl = debug = JXplorer.getProperty("debuglevel", "0").compareTo("7") >= 0;
        if (debug) {
            System.out.println("Started JXResourceLoader");
        }
    }

    public void addResource(CBJarResource resource) {
        int size = this.resourceFiles == null ? 0 : this.resourceFiles.length;
        CBJarResource[] newArray = new CBJarResource[size + 1];
        for (int i = 0; i < size; ++i) {
            newArray[i] = this.resourceFiles[i];
        }
        newArray[size] = resource;
        this.resourceFiles = newArray;
        if (debug) {
            System.out.println("Added CBJarResource: " + resource.toString());
        }
    }

    public InputStream getInputStream(String resourceName) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(resourceName);
        if (resourceFile != null) {
            return resourceFile.getInputStream(resourceName);
        }
        throw new ZipException("File: '" + resourceName + "' not found");
    }

    public Image getImage(String imageName, Toolkit imageCreator) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(imageName);
        if (resourceFile != null) {
            return resourceFile.getImage(imageName, imageCreator);
        }
        throw new ZipException("Image File: '" + imageName + "' not found");
    }

    public byte[] getResource(String resourceName) throws ZipException {
        CBJarResource resourceFile = this.getJarContainingResource(resourceName);
        if (resourceFile != null) {
            return resourceFile.getResource(resourceName);
        }
        throw new ZipException("File: '" + resourceName + "' not found");
    }

    protected CBJarResource getJarContainingResource(String resourceName) {
        if (this.unknownResources.contains(resourceName)) {
            return null;
        }
        for (int i = 0; i < this.resourceFiles.length; ++i) {
            if (!this.resourceFiles[i].hasResource(resourceName)) continue;
            return this.resourceFiles[i];
        }
        this.unknownResources.add(resourceName);
        return null;
    }

    public String[] getPrefixedResources(String prefix) {
        Vector<String> resources = new Vector<String>();
        for (int i = 0; i < this.resourceFiles.length; ++i) {
            resources.addAll(Arrays.asList(this.resourceFiles[i].getPrefixedResources(prefix)));
        }
        if (resources.size() == 0) {
            return new String[0];
        }
        return resources.toArray(new String[resources.size()]);
    }

    public String[] getWildCardResources(String exp) {
        int wildpos = exp.indexOf(42);
        if (wildpos == -1) {
            return new String[]{exp};
        }
        if (wildpos == exp.length() - 1) {
            return this.getPrefixedResources(exp.substring(0, exp.length() - 1));
        }
        String prefix = exp.substring(0, wildpos);
        String suffix = exp.substring(wildpos + 1);
        System.out.println("found prefix: " + prefix + " suffix " + suffix);
        Vector resources = new Vector();
        for (int i = 0; i < this.resourceFiles.length; ++i) {
        }
        if (resources.size() == 0) {
            return new String[0];
        }
        return resources.toArray(new String[resources.size()]);
    }
}

