/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexConstants;
import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.node.DexDebugNode;
import com.googlecode.d2j.node.DexFieldNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.node.TryCatchNode;
import com.googlecode.d2j.node.insn.DexLabelStmtNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.smali.BaksmaliCodeDumper;
import com.googlecode.d2j.smali.BaksmaliDumpOut;
import com.googlecode.d2j.smali.Utils;
import com.googlecode.d2j.util.Out;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class BaksmaliDumper
implements DexConstants {
    private static final int ACCESS_FIELD = Integer.MIN_VALUE;
    private static final String[] accessWords = new String[]{"public", "private", "protected", "static", "final", "synchronized", "bridge", "varargs", "native", "abstract", "strictfp", "synthetic", "constructor", "interface", "enum", "annotation", "volatile", "transient"};
    private final StringBuilder buff = new StringBuilder();
    private boolean useParameterRegisters = true;
    private boolean useLocals = false;

    public BaksmaliDumper() {
    }

    public BaksmaliDumper(boolean useParameterRegisters, boolean useLocals) {
        this.useParameterRegisters = useParameterRegisters;
        this.useLocals = useLocals;
    }

    private static boolean isAccessWords(String name) {
        return Arrays.binarySearch(accessWords, name) >= 0;
    }

    static void escape0(StringBuilder buf, char c) {
        if (c == '\n') {
            buf.append("\\n");
        } else if (c == '\r') {
            buf.append("\\r");
        } else if (c == '\t') {
            buf.append("\\t");
        } else if (c == '\\') {
            buf.append("\\\\");
        } else if (c == '\"') {
            buf.append("\\\"");
        } else if (c < ' ' || c > '\u007f') {
            buf.append("\\u");
            if (c < '\u0010') {
                buf.append("000");
            } else if (c < '\u0100') {
                buf.append("00");
            } else if (c < '\u1000') {
                buf.append('0');
            }
            buf.append(Integer.toString(c, 16));
        } else {
            buf.append(c);
        }
    }

    static String escapeType(String id) {
        StringBuilder escapeBuff = new StringBuilder();
        BaksmaliDumper.escapeType0(escapeBuff, id);
        return escapeBuff.toString();
    }

    static void escapeId0(StringBuilder sb, String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            BaksmaliDumper.escape1(sb, c);
        }
    }

    static String escapeId(String id) {
        StringBuilder escapeBuff = new StringBuilder();
        BaksmaliDumper.escapeId0(escapeBuff, id);
        return escapeBuff.toString();
    }

    static void escape1(StringBuilder buf, char c) {
        if (c == ' ' || c == '-' || c == ':' | c == '=' || c == ',' || c == '{' || c == '}' || c == '(' || c == ')') {
            buf.append(String.format("\\u%04x", c));
        } else {
            BaksmaliDumper.escape0(buf, c);
        }
    }

    static void escapeType0(StringBuilder sb, String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '-') {
                sb.append('-');
                continue;
            }
            BaksmaliDumper.escape1(sb, c);
        }
    }

    static String escapeMethod(Method method) {
        return BaksmaliDumper.escapeType(method.getOwner()) + "->" + BaksmaliDumper.escapeId(method.getName()) + BaksmaliDumper.escapeMethodDesc(method);
    }

    static String escapeMethodDesc(Method m) {
        return BaksmaliDumper.escapeMethodDesc(m.getProto());
    }

    static String escapeMethodDesc(Proto m) {
        StringBuilder escapeBuff = new StringBuilder();
        escapeBuff.append("(");
        for (String t : m.getParameterTypes()) {
            BaksmaliDumper.escapeType0(escapeBuff, t);
        }
        escapeBuff.append(")");
        BaksmaliDumper.escapeType0(escapeBuff, m.getReturnType());
        return escapeBuff.toString();
    }

    static void appendAccess(int access, StringBuilder sb) {
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 0x10) != 0) {
            sb.append("final ");
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x40) != 0) {
            if ((access & Integer.MIN_VALUE) == 0) {
                sb.append("bridge ");
            } else {
                sb.append("volatile ");
            }
        }
        if ((access & 0x80) != 0) {
            if ((access & Integer.MIN_VALUE) == 0) {
                sb.append("varargs ");
            } else {
                sb.append("transient ");
            }
        }
        if ((access & 0x100) != 0) {
            sb.append("native ");
        }
        if ((access & 0x800) != 0) {
            sb.append("strict ");
        }
        if ((access & 0x200) != 0) {
            sb.append("interface ");
        }
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((access & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((access & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((access & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((access & 0x20000) != 0) {
            sb.append("declared-synchronized ");
        }
        if ((access & 0x10000) != 0) {
            sb.append("constructor ");
        }
    }

    static void escape(StringBuilder buf, String s) {
        buf.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            BaksmaliDumper.escape0(buf, s.charAt(i));
        }
        buf.append("\"");
    }

    static String escapeValue(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            StringBuilder buf = new StringBuilder();
            BaksmaliDumper.escape(buf, (String)obj);
            return buf.toString();
        }
        if (obj instanceof DexType) {
            return BaksmaliDumper.escapeType(((DexType)obj).desc);
        }
        if (obj instanceof Proto) {
            return BaksmaliDumper.escapeMethodDesc((Proto)obj);
        }
        if (obj instanceof MethodHandle) {
            return BaksmaliDumper.escapeMethodHandle((MethodHandle)obj);
        }
        if (obj instanceof Field) {
            Field f = (Field)obj;
            String owner = f.getOwner();
            if (owner == null) {
                owner = f.getType();
            }
            return ".enum " + BaksmaliDumper.escapeType(owner) + "->" + f.getName() + ":" + BaksmaliDumper.escapeType(f.getType());
        }
        if (obj instanceof Integer) {
            int i = (Integer)obj;
            if (i == Integer.MIN_VALUE) {
                return "0x" + Integer.toHexString(Integer.MIN_VALUE);
            }
            return obj.toString();
        }
        if (obj instanceof Long) {
            long v = (Long)obj;
            if (v == Long.MIN_VALUE) {
                return "0x" + Long.toHexString(Long.MIN_VALUE) + "L";
            }
            return obj + "L";
        }
        if (obj instanceof Float) {
            return obj + "F";
        }
        if (obj instanceof Double) {
            return obj + "D";
        }
        if (obj instanceof Short) {
            return obj + "S";
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).toString() + 't';
        }
        if (obj instanceof Character) {
            StringBuilder buf = new StringBuilder();
            buf.append("'");
            BaksmaliDumper.escape0(buf, ((Character)obj).charValue());
            buf.append("'");
            return buf.toString();
        }
        if (obj instanceof Boolean) {
            return ((Boolean)obj).toString();
        }
        if (obj instanceof Method) {
            return BaksmaliDumper.escapeMethod((Method)obj);
        }
        return null;
    }

    private static String escapeMethodHandle(MethodHandle obj) {
        switch (obj.getType()) {
            case 3: {
                return "instance-get@" + BaksmaliDumper.escapeField(obj.getField());
            }
            case 2: {
                return "instance-put@" + BaksmaliDumper.escapeField(obj.getField());
            }
            case 1: {
                return "static-get@" + BaksmaliDumper.escapeField(obj.getField());
            }
            case 0: {
                return "static-put@" + BaksmaliDumper.escapeField(obj.getField());
            }
            case 5: {
                return "invoke-instance@" + BaksmaliDumper.escapeMethod(obj.getMethod());
            }
            case 4: {
                return "invoke-static@" + BaksmaliDumper.escapeMethod(obj.getMethod());
            }
            case 6: {
                return "invoke-constructor@" + BaksmaliDumper.escapeMethod(obj.getMethod());
            }
            case 7: {
                return "invoke-direct@" + BaksmaliDumper.escapeMethod(obj.getMethod());
            }
            case 8: {
                return "invoke-interface@" + BaksmaliDumper.escapeMethod(obj.getMethod());
            }
        }
        return "?";
    }

    public static String escapeField(Field f) {
        String owner = f.getOwner();
        if (owner == null) {
            owner = f.getType();
        }
        return BaksmaliDumper.escapeType(owner) + "->" + f.getName() + ":" + BaksmaliDumper.escapeType(f.getType());
    }

    private static void dumpAnns(List<DexAnnotationNode> anns, Out out) {
        for (DexAnnotationNode ann : anns) {
            BaksmaliDumper.dumpAnn(ann, out);
        }
    }

    private static void dumpItem(String name, Object o, Out out, boolean array) {
        if (o instanceof Object[]) {
            Object[] vs = (Object[])o;
            if (name != null) {
                out.s(BaksmaliDumper.escapeId(name) + " = {");
            } else {
                out.s("{");
            }
            out.push();
            for (int i = 0; i < vs.length; ++i) {
                Object v = vs[i];
                BaksmaliDumper.dumpItem(null, v, out, i != vs.length - 1);
            }
            out.pop();
            if (array) {
                out.s("},");
            } else {
                out.s("}");
            }
        } else if (o instanceof DexAnnotationNode) {
            DexAnnotationNode dexAnnotationNode = (DexAnnotationNode)o;
            if (name != null) {
                out.s(BaksmaliDumper.escapeId(name) + " = .subannotation " + BaksmaliDumper.escapeType(dexAnnotationNode.type));
            } else {
                out.s(".subannotation " + BaksmaliDumper.escapeType(dexAnnotationNode.type));
            }
            out.push();
            for (DexAnnotationNode.Item item : dexAnnotationNode.items) {
                BaksmaliDumper.dumpItem(item.name, item.value, out, false);
            }
            out.pop();
            if (array) {
                out.s(".end subannotation,");
            } else {
                out.s(".end subannotation");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            if (name != null) {
                sb.append(BaksmaliDumper.escapeId(name)).append(" = ");
            }
            sb.append(BaksmaliDumper.escapeValue(o));
            if (array) {
                sb.append(",");
            }
            out.s(sb.toString());
        }
    }

    private static void dumpAnn(DexAnnotationNode ann, Out out) {
        out.s(".annotation %s %s", new Object[]{ann.visibility.displayName(), BaksmaliDumper.escapeType(ann.type)});
        out.push();
        for (DexAnnotationNode.Item item : ann.items) {
            BaksmaliDumper.dumpItem(item.name, item.value, out, false);
        }
        out.pop();
        out.s(".end annotation");
    }

    public void baksmaliClass(DexClassNode n, BufferedWriter writer) {
        this.baksmaliClass(n, new BaksmaliDumpOut(writer));
    }

    public void baksmaliClass(DexClassNode n, Out out) {
        this.buff.setLength(0);
        this.buff.append(".class ");
        BaksmaliDumper.appendAccess(n.access, this.buff);
        this.buff.append(BaksmaliDumper.escapeType(n.className));
        out.s(this.buff.toString());
        if (n.superClass != null) {
            out.s(".super %s", new Object[]{BaksmaliDumper.escapeType(n.superClass)});
        }
        if (n.interfaceNames != null && n.interfaceNames.length > 0) {
            for (String itf : n.interfaceNames) {
                out.s(".implements %s", new Object[]{BaksmaliDumper.escapeType(itf)});
            }
        }
        if (n.source != null) {
            out.s(".source " + BaksmaliDumper.escapeValue(n.source));
        }
        if (n.anns != null) {
            out.s("");
            BaksmaliDumper.dumpAnns(n.anns, out);
        }
        if (n.fields != null) {
            for (DexFieldNode f : n.fields) {
                out.s("");
                this.buff.setLength(0);
                this.buff.append(".field ");
                BaksmaliDumper.appendAccess(f.access | Integer.MIN_VALUE, this.buff);
                Field field = f.field;
                this.buff.append(BaksmaliDumper.escapeId(f.field.getName())).append(":").append(BaksmaliDumper.escapeType(field.getType()));
                if (f.cst != null) {
                    this.buff.append(" = ");
                    this.buff.append(BaksmaliDumper.escapeValue(f.cst));
                }
                out.s(this.buff.toString());
                if (f.anns == null) continue;
                out.push();
                BaksmaliDumper.dumpAnns(f.anns, out);
                out.pop();
                out.s(".end field");
            }
        }
        if (n.methods != null) {
            for (DexMethodNode m : n.methods) {
                this.baksmaliMethod(m, out);
            }
        }
    }

    public void baksmaliMethod(DexMethodNode m, BufferedWriter writer) {
        this.baksmaliMethod(m, new BaksmaliDumpOut(writer));
    }

    public void baksmaliMethod(DexMethodNode m, Out out) {
        out.s("");
        this.buff.setLength(0);
        this.buff.append(".method ");
        Method method = m.method;
        BaksmaliDumper.appendAccess(m.access, this.buff);
        this.buff.append(BaksmaliDumper.escapeId(method.getName())).append(BaksmaliDumper.escapeMethodDesc(method));
        out.s(this.buff.toString());
        out.push();
        if (m.anns != null) {
            BaksmaliDumper.dumpAnns(m.anns, out);
        }
        int paramMax = 0;
        List parameterNames = null;
        if (m.codeNode != null && m.codeNode.debugNode != null && (parameterNames = m.codeNode.debugNode.parameterNames) != null) {
            paramMax = parameterNames.size();
        }
        int annoMax = 0;
        if (m.parameterAnns != null) {
            for (int i = 0; i < m.parameterAnns.length; ++i) {
                List ps = m.parameterAnns[i];
                if (ps == null || ps.size() <= 0) continue;
                annoMax = i + 1;
            }
        }
        int max = Math.max(paramMax, annoMax);
        for (int i = 0; i < max; ++i) {
            List ps;
            String debugName;
            String type = method.getParameterTypes()[i];
            String string = parameterNames == null ? null : (debugName = i < parameterNames.size() ? (String)parameterNames.get(i) : null);
            if (debugName != null) {
                out.s(".parameter \"" + BaksmaliDumper.escapeId(debugName) + "\" # " + type);
            } else {
                out.s(".parameter # " + type);
            }
            List list = ps = m.parameterAnns == null ? null : m.parameterAnns[i];
            if (ps == null || ps.size() == 0) continue;
            out.push();
            BaksmaliDumper.dumpAnns(ps, out);
            out.pop();
            out.s(".end parameter");
        }
        if (m.codeNode != null) {
            this.baksmaliCode(m, m.codeNode, out);
        }
        out.pop();
        out.s(".end method");
    }

    public void baksmaliCode(DexMethodNode methodNode, DexCodeNode codeNode, Out out) {
        final ArrayList allLabel = new ArrayList();
        final HashSet<DexLabel> usedLabel = new HashSet<DexLabel>();
        codeNode.accept(new DexCodeVisitor(){

            public void visitJumpStmt(Op op, int a, int b, DexLabel label) {
                usedLabel.add(label);
            }

            public void visitPackedSwitchStmt(Op op, int aA, int first_case, DexLabel[] labels) {
                usedLabel.addAll(Arrays.asList(labels));
            }

            public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handler, String[] type) {
                usedLabel.add(start);
                usedLabel.add(end);
                usedLabel.addAll(Arrays.asList(handler));
            }

            public void visitLabel(DexLabel label) {
                allLabel.add(label);
            }

            public void visitSparseSwitchStmt(Op op, int ra, int[] cases, DexLabel[] labels) {
                usedLabel.addAll(Arrays.asList(labels));
            }
        });
        HashMap<DexLabel, List<DexDebugNode.DexDebugOpNode>> debugLabelMap = new HashMap<DexLabel, List<DexDebugNode.DexDebugOpNode>>();
        if (codeNode.debugNode != null) {
            DexDebugNode debugNode = codeNode.debugNode;
            for (DexDebugNode.DexDebugOpNode opNode : debugNode.debugNodes) {
                ArrayList<DexDebugNode.DexDebugOpNode> list = (ArrayList<DexDebugNode.DexDebugOpNode>)debugLabelMap.get(opNode.label);
                if (list == null) {
                    list = new ArrayList<DexDebugNode.DexDebugOpNode>(3);
                    debugLabelMap.put(opNode.label, list);
                }
                list.add(opNode);
            }
        }
        int nextLabelNumber = 0;
        for (DexLabel label : allLabel) {
            if (!usedLabel.contains(label)) continue;
            label.displayName = "L" + nextLabelNumber++;
        }
        int inRegs = Utils.methodIns(methodNode.method, (methodNode.access & 8) != 0);
        BaksmaliCodeDumper dexCodeVisitor = new BaksmaliCodeDumper(out, this.useParameterRegisters, this.useLocals, nextLabelNumber, codeNode.totalRegister - inRegs, usedLabel, debugLabelMap);
        this.accept(out, codeNode, dexCodeVisitor);
        dexCodeVisitor.visitEnd();
    }

    void accept(Out out, DexCodeNode code, DexCodeVisitor v) {
        DexDebugVisitor ddv;
        if (code.tryStmts != null) {
            for (TryCatchNode n : code.tryStmts) {
                n.accept(v);
            }
        }
        if (code.debugNode != null && (ddv = v.visitDebug()) != null) {
            code.debugNode.accept(ddv);
            ddv.visitEnd();
        }
        if (code.totalRegister >= 0 && code.stmts.size() > 0) {
            v.visitRegister(code.totalRegister);
        }
        for (TryCatchNode n : code.stmts) {
            if (n instanceof DexLabelStmtNode) {
                n.accept(v);
                continue;
            }
            out.push();
            n.accept(v);
            out.pop();
        }
    }

    static {
        Arrays.sort(accessWords);
    }
}

