# SPDX-License-Identifier: GPL-2.0-only
# This file is part of Scapy RPC
# See https://scapy.net/ for more information
# Copyright (C) Gabriel Potter

# [ms-dcom] v25.0 (Mon, 16 Sep 2024)

"""
RPC definitions for the following interfaces:
- IActivation (v0.0): 4d9f4ab8-7d1c-11cf-861e-0020af6e7c57
- IRemoteSCMActivator (v0.0): 000001A0-0000-0000-C000-000000000046
- IObjectExporter (v0.0): 99fcfec4-5260-101b-bbcb-00aa0021347a
- IUnknown (v0.0): 00000000-0000-0000-C000-000000000046
- IRemUnknown (v0.0): 00000131-0000-0000-C000-000000000046
- IRemUnknown2 (v0.0): 00000143-0000-0000-C000-000000000046
This file is auto-generated by midl-to-scapy, do not modify.
"""

from enum import IntEnum
import uuid

from scapy.fields import StrFixedLenField
from scapy.layers.dcerpc import (
    NDRPacket,
    DceRpcOp,
    NDRConfFieldListField,
    NDRConfPacketListField,
    NDRConfStrLenField,
    NDRConfStrLenFieldUtf16,
    NDRConfVarStrNullField,
    NDRConfVarStrNullFieldUtf16,
    NDRFullEmbPointerField,
    NDRFullPointerField,
    NDRInt3264EnumField,
    NDRIntField,
    NDRLongField,
    NDRPacketField,
    NDRShortField,
    NDRSignedIntField,
    register_com_interface,
    register_dcerpc_interface,
)


class COMVERSION(NDRPacket):
    ALIGNMENT = (2, 2)
    fields_desc = [NDRShortField("MajorVersion", 0), NDRShortField("MinorVersion", 0)]


class tagCPFLAGS(IntEnum):
    CPFLAG_PROPAGATE = 1
    CPFLAG_EXPOSE = 2
    CPFLAG_ENVOY = 4


class GUID(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("Data1", 0),
        NDRShortField("Data2", 0),
        NDRShortField("Data3", 0),
        StrFixedLenField("Data4", "", length=8),
    ]


class ORPC_EXTENT(NDRPacket):
    ALIGNMENT = (4, 8)
    DEPORTED_CONFORMANTS = ["data"]
    fields_desc = [
        NDRPacketField("id", GUID(), GUID),
        NDRIntField("size", 0),
        NDRConfStrLenField(
            "data",
            "",
            size_is=lambda pkt: ((pkt.size + 7) & (~7)),
            conformant_in_struct=True,
        ),
    ]


class ORPC_EXTENT_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("size", 0),
        NDRIntField("reserved", 0),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "extent",
                [],
                ORPC_EXTENT,
                size_is=lambda pkt: ((pkt.size + 1) & (~1)),
                ptr_pack=True,
            )
        ),
    ]


class ORPCTHIS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("version", COMVERSION(), COMVERSION),
        NDRInt3264EnumField("flags", 0, tagCPFLAGS),
        NDRIntField("reserved1", 0),
        NDRPacketField("cid", GUID(), GUID),
        NDRFullEmbPointerField(
            NDRPacketField("extensions", ORPC_EXTENT_ARRAY(), ORPC_EXTENT_ARRAY)
        ),
    ]


class MInterfacePointer(NDRPacket):
    ALIGNMENT = (4, 8)
    DEPORTED_CONFORMANTS = ["abData"]
    fields_desc = [
        NDRIntField("ulCntData", None, size_of="abData"),
        NDRConfStrLenField(
            "abData", "", size_is=lambda pkt: pkt.ulCntData, conformant_in_struct=True
        ),
    ]


class ORPCTHAT(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("flags", 0),
        NDRFullEmbPointerField(
            NDRPacketField("extensions", ORPC_EXTENT_ARRAY(), ORPC_EXTENT_ARRAY)
        ),
    ]


class DUALSTRINGARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    DEPORTED_CONFORMANTS = ["aStringArray"]
    fields_desc = [
        NDRShortField("wNumEntries", None, size_of="aStringArray"),
        NDRShortField("wSecurityOffset", 0),
        NDRConfStrLenFieldUtf16(
            "aStringArray",
            "",
            size_is=lambda pkt: pkt.wNumEntries,
            conformant_in_struct=True,
        ),
    ]


class RemoteActivation_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("ORPCthis", ORPCTHIS(), ORPCTHIS),
        NDRPacketField("Clsid", GUID(), GUID),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("pwszObjectName", "")),
        NDRFullPointerField(
            NDRPacketField("pObjectStorage", MInterfacePointer(), MInterfacePointer)
        ),
        NDRIntField("ClientImpLevel", 0),
        NDRIntField("Mode", 0),
        NDRIntField("Interfaces", None, size_of="pIIDs"),
        NDRConfPacketListField("pIIDs", [], GUID, size_is=lambda pkt: pkt.Interfaces),
        NDRShortField("cRequestedProtseqs", None, size_of="aRequestedProtseqs"),
        NDRConfFieldListField(
            "aRequestedProtseqs",
            [],
            NDRShortField("", 0),
            size_is=lambda pkt: pkt.cRequestedProtseqs,
        ),
    ]


class RemoteActivation_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("ORPCthat", ORPCTHAT(), ORPCTHAT),
        NDRLongField("pOxid", 0),
        NDRFullPointerField(
            NDRPacketField("ppdsaOxidBindings", DUALSTRINGARRAY(), DUALSTRINGARRAY)
        ),
        NDRPacketField("pipidRemUnknown", GUID(), GUID),
        NDRIntField("pAuthnHint", 0),
        NDRPacketField("pServerVersion", COMVERSION(), COMVERSION),
        NDRSignedIntField("phr", 0),
        NDRConfPacketListField(
            "ppInterfaceData",
            [],
            MInterfacePointer,
            size_is=lambda pkt: pkt.Interfaces,
            ptr_pack=True,
        ),
        NDRConfFieldListField(
            "pResults", [], NDRSignedIntField("", 0), size_is=lambda pkt: pkt.Interfaces
        ),
        NDRIntField("status", 0),
    ]


IACTIVATION_OPNUMS = {0: DceRpcOp(RemoteActivation_Request, RemoteActivation_Response)}
register_dcerpc_interface(
    name="IActivation",
    uuid=uuid.UUID("4d9f4ab8-7d1c-11cf-861e-0020af6e7c57"),
    version="0.0",
    opnums=IACTIVATION_OPNUMS,
)


class RemoteGetClassObject_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("orpcthis", ORPCTHIS(), ORPCTHIS),
        NDRFullPointerField(
            NDRPacketField("pActProperties", MInterfacePointer(), MInterfacePointer)
        ),
    ]


class RemoteGetClassObject_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("orpcthat", ORPCTHAT(), ORPCTHAT),
        NDRFullPointerField(
            NDRPacketField("ppActProperties", MInterfacePointer(), MInterfacePointer)
        ),
        NDRIntField("status", 0),
    ]


class RemoteCreateInstance_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("orpcthis", ORPCTHIS(), ORPCTHIS),
        NDRFullPointerField(
            NDRPacketField("pUnkOuter", MInterfacePointer(), MInterfacePointer)
        ),
        NDRFullPointerField(
            NDRPacketField("pActProperties", MInterfacePointer(), MInterfacePointer)
        ),
    ]


class RemoteCreateInstance_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("orpcthat", ORPCTHAT(), ORPCTHAT),
        NDRFullPointerField(
            NDRPacketField("ppActProperties", MInterfacePointer(), MInterfacePointer)
        ),
        NDRIntField("status", 0),
    ]


IREMOTESCMACTIVATOR_OPNUMS = {  # 0: Opnum0NotUsedOnWire,
    # 1: Opnum1NotUsedOnWire,
    # 2: Opnum2NotUsedOnWire,
    3: DceRpcOp(RemoteGetClassObject_Request, RemoteGetClassObject_Response),
    4: DceRpcOp(RemoteCreateInstance_Request, RemoteCreateInstance_Response),
}
register_dcerpc_interface(
    name="IRemoteSCMActivator",
    uuid=uuid.UUID("000001A0-0000-0000-C000-000000000046"),
    version="0.0",
    opnums=IREMOTESCMACTIVATOR_OPNUMS,
)


class ResolveOxid_Request(NDRPacket):
    fields_desc = [
        NDRLongField("pOxid", 0),
        NDRShortField("cRequestedProtseqs", None, size_of="arRequestedProtseqs"),
        NDRConfFieldListField(
            "arRequestedProtseqs",
            [],
            NDRShortField("", 0),
            size_is=lambda pkt: pkt.cRequestedProtseqs,
        ),
    ]


class ResolveOxid_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField("ppdsaOxidBindings", DUALSTRINGARRAY(), DUALSTRINGARRAY)
        ),
        NDRPacketField("pipidRemUnknown", GUID(), GUID),
        NDRIntField("pAuthnHint", 0),
        NDRIntField("status", 0),
    ]


class SimplePing_Request(NDRPacket):
    fields_desc = [NDRLongField("pSetId", 0)]


class SimplePing_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


class ComplexPing_Request(NDRPacket):
    fields_desc = [
        NDRLongField("pSetId", 0),
        NDRShortField("SequenceNum", 0),
        NDRShortField("cAddToSet", None, size_of="AddToSet"),
        NDRShortField("cDelFromSet", None, size_of="DelFromSet"),
        NDRConfFieldListField(
            "AddToSet", [], NDRLongField("", 0), size_is=lambda pkt: pkt.cAddToSet
        ),
        NDRConfFieldListField(
            "DelFromSet", [], NDRLongField("", 0), size_is=lambda pkt: pkt.cDelFromSet
        ),
    ]


class ComplexPing_Response(NDRPacket):
    fields_desc = [
        NDRLongField("pSetId", 0),
        NDRShortField("pPingBackoffFactor", 0),
        NDRIntField("status", 0),
    ]


class ServerAlive_Request(NDRPacket):
    fields_desc = []


class ServerAlive_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


class ResolveOxid2_Request(NDRPacket):
    fields_desc = [
        NDRLongField("pOxid", 0),
        NDRShortField("cRequestedProtseqs", None, size_of="arRequestedProtseqs"),
        NDRConfFieldListField(
            "arRequestedProtseqs",
            [],
            NDRShortField("", 0),
            size_is=lambda pkt: pkt.cRequestedProtseqs,
        ),
    ]


class ResolveOxid2_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField("ppdsaOxidBindings", DUALSTRINGARRAY(), DUALSTRINGARRAY)
        ),
        NDRPacketField("pipidRemUnknown", GUID(), GUID),
        NDRIntField("pAuthnHint", 0),
        NDRPacketField("pComVersion", COMVERSION(), COMVERSION),
        NDRIntField("status", 0),
    ]


class ServerAlive2_Request(NDRPacket):
    fields_desc = []


class ServerAlive2_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("pComVersion", COMVERSION(), COMVERSION),
        NDRFullPointerField(
            NDRPacketField("ppdsaOrBindings", DUALSTRINGARRAY(), DUALSTRINGARRAY)
        ),
        NDRIntField("pReserved", 0),
        NDRIntField("status", 0),
    ]


IOBJECTEXPORTER_OPNUMS = {
    0: DceRpcOp(ResolveOxid_Request, ResolveOxid_Response),
    1: DceRpcOp(SimplePing_Request, SimplePing_Response),
    2: DceRpcOp(ComplexPing_Request, ComplexPing_Response),
    3: DceRpcOp(ServerAlive_Request, ServerAlive_Response),
    4: DceRpcOp(ResolveOxid2_Request, ResolveOxid2_Response),
    5: DceRpcOp(ServerAlive2_Request, ServerAlive2_Response),
}
register_dcerpc_interface(
    name="IObjectExporter",
    uuid=uuid.UUID("99fcfec4-5260-101b-bbcb-00aa0021347a"),
    version="0.0",
    opnums=IOBJECTEXPORTER_OPNUMS,
)
IUNKNOWN_OPNUMS = {  # 0: Opnum0NotUsedOnWire,
    # 1: Opnum1NotUsedOnWire,
    # 2: Opnum2NotUsedOnWire
}
register_com_interface(
    name="IUnknown",
    uuid=uuid.UUID("00000000-0000-0000-C000-000000000046"),
    opnums=IUNKNOWN_OPNUMS,
)


class STDOBJREF(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [
        NDRIntField("flags", 0),
        NDRIntField("cPublicRefs", 0),
        NDRLongField("oxid", 0),
        NDRLongField("oid", 0),
        NDRPacketField("ipid", GUID(), GUID),
    ]


class REMQIRESULT(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [
        NDRSignedIntField("hResult", 0),
        NDRPacketField("std", STDOBJREF(), STDOBJREF),
    ]


class RemQueryInterface_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("ripid", GUID(), GUID),
        NDRIntField("cRefs", 0),
        NDRShortField("cIids", None, size_of="iids"),
        NDRConfPacketListField("iids", [], GUID, size_is=lambda pkt: pkt.cIids),
    ]


class RemQueryInterface_Response(NDRPacket):
    fields_desc = [
        NDRConfPacketListField(
            "ppQIResults", [], REMQIRESULT, size_is=lambda pkt: pkt.cIids, ptr_pack=True
        ),
        NDRIntField("status", 0),
    ]


class REMINTERFACEREF(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRPacketField("ipid", GUID(), GUID),
        NDRIntField("cPublicRefs", 0),
        NDRIntField("cPrivateRefs", 0),
    ]


class RemAddRef_Request(NDRPacket):
    fields_desc = [
        NDRShortField("cInterfaceRefs", None, size_of="InterfaceRefs"),
        NDRConfPacketListField(
            "InterfaceRefs", [], REMINTERFACEREF, size_is=lambda pkt: pkt.cInterfaceRefs
        ),
    ]


class RemAddRef_Response(NDRPacket):
    fields_desc = [
        NDRConfFieldListField(
            "pResults",
            [],
            NDRSignedIntField("", 0),
            size_is=lambda pkt: pkt.cInterfaceRefs,
        ),
        NDRIntField("status", 0),
    ]


class RemRelease_Request(NDRPacket):
    fields_desc = [
        NDRShortField("cInterfaceRefs", None, size_of="InterfaceRefs"),
        NDRConfPacketListField(
            "InterfaceRefs", [], REMINTERFACEREF, size_is=lambda pkt: pkt.cInterfaceRefs
        ),
    ]


class RemRelease_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


IREMUNKNOWN_OPNUMS = {  # 0: Opnum0NotUsedOnWire,
    # 1: Opnum1NotUsedOnWire,
    # 2: Opnum2NotUsedOnWire,
    3: DceRpcOp(RemQueryInterface_Request, RemQueryInterface_Response),
    4: DceRpcOp(RemAddRef_Request, RemAddRef_Response),
    5: DceRpcOp(RemRelease_Request, RemRelease_Response),
}
register_com_interface(
    name="IRemUnknown",
    uuid=uuid.UUID("00000131-0000-0000-C000-000000000046"),
    opnums=IREMUNKNOWN_OPNUMS,
)


class RemQueryInterface2_Request(NDRPacket):
    fields_desc = [
        NDRPacketField("ripid", GUID(), GUID),
        NDRShortField("cIids", None, size_of="iids"),
        NDRConfPacketListField("iids", [], GUID, size_is=lambda pkt: pkt.cIids),
    ]


class RemQueryInterface2_Response(NDRPacket):
    fields_desc = [
        NDRConfFieldListField(
            "phr", [], NDRSignedIntField("", 0), size_is=lambda pkt: pkt.cIids
        ),
        NDRConfPacketListField(
            "ppMIF", [], MInterfacePointer, size_is=lambda pkt: pkt.cIids, ptr_pack=True
        ),
        NDRIntField("status", 0),
    ]


IREMUNKNOWN2_OPNUMS = {  # 0: Opnum0NotUsedOnWire,
    # 1: Opnum1NotUsedOnWire,
    # 2: Opnum2NotUsedOnWire,
    3: DceRpcOp(RemQueryInterface_Request, RemQueryInterface_Response),
    4: DceRpcOp(RemAddRef_Request, RemAddRef_Response),
    5: DceRpcOp(RemRelease_Request, RemRelease_Response),
    6: DceRpcOp(RemQueryInterface2_Request, RemQueryInterface2_Response),
}
register_com_interface(
    name="IRemUnknown2",
    uuid=uuid.UUID("00000143-0000-0000-C000-000000000046"),
    opnums=IREMUNKNOWN2_OPNUMS,
)
