<?php
/**
 * InvokableScriptsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * InvokableScriptsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InvokableScriptsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteScriptsID
     *
     * Delete a script
     *
     * @param  string $script_id The ID of the script to delete. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScriptsID($script_id)
    {
        $this->deleteScriptsIDWithHttpInfo($script_id);
    }

    /**
     * Operation deleteScriptsIDWithHttpInfo
     *
     * Delete a script
     *
     * @param  string $script_id The ID of the script to delete. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScriptsIDWithHttpInfo($script_id)
    {
        $request = $this->deleteScriptsIDRequest($script_id);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteScriptsID'
     *
     * @param  string $script_id The ID of the script to delete. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteScriptsIDRequest($script_id)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling deleteScriptsID'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScripts
     *
     * List scripts
     *
     * @param  int $limit Limits the number of scripts returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional, default to 0)
     * @param  string $name The name of the script. (optional)
     * @param  string[] $label_names A list of label names. Only returns scripts that have all these labels. To retrieve a script, each name you pass in &#x60;labelNames&#x60; must exactly match the label for a script. (optional)
     * @param  string $label_contains A part of the label name. Returns scripts that have a label that contains this phrase. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Scripts|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getScripts($limit = 100, $offset = 0, $name = null, $label_names = null, $label_contains = null)
    {
        list($response) = $this->getScriptsWithHttpInfo($limit, $offset, $name, $label_names, $label_contains);
        return $response;
    }

    /**
     * Operation getScriptsWithHttpInfo
     *
     * List scripts
     *
     * @param  int $limit Limits the number of scripts returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional, default to 0)
     * @param  string $name The name of the script. (optional)
     * @param  string[] $label_names A list of label names. Only returns scripts that have all these labels. To retrieve a script, each name you pass in &#x60;labelNames&#x60; must exactly match the label for a script. (optional)
     * @param  string $label_contains A part of the label name. Returns scripts that have a label that contains this phrase. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Scripts|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScriptsWithHttpInfo($limit = 100, $offset = 0, $name = null, $label_names = null, $label_contains = null)
    {
        $request = $this->getScriptsRequest($limit, $offset, $name, $label_names, $label_contains);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Scripts';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScripts'
     *
     * @param  int $limit Limits the number of scripts returned. Default is &#x60;100&#x60;. (optional, default to 100)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional, default to 0)
     * @param  string $name The name of the script. (optional)
     * @param  string[] $label_names A list of label names. Only returns scripts that have all these labels. To retrieve a script, each name you pass in &#x60;labelNames&#x60; must exactly match the label for a script. (optional)
     * @param  string $label_contains A part of the label name. Returns scripts that have a label that contains this phrase. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScriptsRequest($limit = 100, $offset = 0, $name = null, $label_names = null, $label_contains = null)
    {
        if ($limit !== null && $limit > 500) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling InvokableScriptsService.getScripts, must be smaller than or equal to 500.');
        }
        if ($limit !== null && $limit < 0) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling InvokableScriptsService.getScripts, must be bigger than or equal to 0.');
        }

        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling InvokableScriptsService.getScripts, must be bigger than or equal to 0.');
        }


        $resourcePath = '/api/v2/scripts';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if (is_array($label_names)) {
            $label_names = ObjectSerializer::serializeCollection($label_names, 'multi', true);
        }
        if ($label_names !== null) {
            $queryParams['labelNames'] = ObjectSerializer::toQueryValue($label_names);
        }
        // query params
        if ($label_contains !== null) {
            $queryParams['labelContains'] = ObjectSerializer::toQueryValue($label_contains);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScriptsID
     *
     * Retrieve a script
     *
     * @param  string $script_id The script ID. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Script
     */
    public function getScriptsID($script_id)
    {
        list($response) = $this->getScriptsIDWithHttpInfo($script_id);
        return $response;
    }

    /**
     * Operation getScriptsIDWithHttpInfo
     *
     * Retrieve a script
     *
     * @param  string $script_id The script ID. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Script, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScriptsIDWithHttpInfo($script_id)
    {
        $request = $this->getScriptsIDRequest($script_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Script';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScriptsID'
     *
     * @param  string $script_id The script ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScriptsIDRequest($script_id)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling getScriptsID'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchScriptsID
     *
     * Update a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\ScriptUpdateRequest $script_update_request Script update to apply (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Script
     */
    public function patchScriptsID($script_id, $script_update_request)
    {
        list($response) = $this->patchScriptsIDWithHttpInfo($script_id, $script_update_request);
        return $response;
    }

    /**
     * Operation patchScriptsIDWithHttpInfo
     *
     * Update a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\ScriptUpdateRequest $script_update_request Script update to apply (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Script, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchScriptsIDWithHttpInfo($script_id, $script_update_request)
    {
        $request = $this->patchScriptsIDRequest($script_id, $script_update_request);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Script';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchScriptsID'
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\ScriptUpdateRequest $script_update_request Script update to apply (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchScriptsIDRequest($script_id, $script_update_request)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling patchScriptsID'
            );
        }
        // verify the required parameter 'script_update_request' is set
        if ($script_update_request === null || (is_array($script_update_request) && count($script_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_update_request when calling patchScriptsID'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($script_update_request)) {
            $_tempBody = $script_update_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchScriptsIDAddLabels
     *
     * Adds labels to a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to add to the script. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Script|object|\InfluxDB2\Model\Error
     */
    public function patchScriptsIDAddLabels($script_id, $label_mapping)
    {
        list($response) = $this->patchScriptsIDAddLabelsWithHttpInfo($script_id, $label_mapping);
        return $response;
    }

    /**
     * Operation patchScriptsIDAddLabelsWithHttpInfo
     *
     * Adds labels to a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to add to the script. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Script|object|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchScriptsIDAddLabelsWithHttpInfo($script_id, $label_mapping)
    {
        $request = $this->patchScriptsIDAddLabelsRequest($script_id, $label_mapping);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Script';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchScriptsIDAddLabels'
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to add to the script. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchScriptsIDAddLabelsRequest($script_id, $label_mapping)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling patchScriptsIDAddLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling patchScriptsIDAddLabels'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}/labels/add';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchScriptsIDRemoveLabels
     *
     * Removes labels from a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to remove from the script. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Script|object|\InfluxDB2\Model\Error
     */
    public function patchScriptsIDRemoveLabels($script_id, $label_mapping)
    {
        list($response) = $this->patchScriptsIDRemoveLabelsWithHttpInfo($script_id, $label_mapping);
        return $response;
    }

    /**
     * Operation patchScriptsIDRemoveLabelsWithHttpInfo
     *
     * Removes labels from a script
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to remove from the script. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Script|object|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchScriptsIDRemoveLabelsWithHttpInfo($script_id, $label_mapping)
    {
        $request = $this->patchScriptsIDRemoveLabelsRequest($script_id, $label_mapping);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Script';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchScriptsIDRemoveLabels'
     *
     * @param  string $script_id The script ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping The names of labels to remove from the script. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchScriptsIDRemoveLabelsRequest($script_id, $label_mapping)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling patchScriptsIDRemoveLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling patchScriptsIDRemoveLabels'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}/labels/remove';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScripts
     *
     * Create a script
     *
     * @param  \InfluxDB2\Model\ScriptCreateRequest $script_create_request The script to create. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Script|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postScripts($script_create_request)
    {
        list($response) = $this->postScriptsWithHttpInfo($script_create_request);
        return $response;
    }

    /**
     * Operation postScriptsWithHttpInfo
     *
     * Create a script
     *
     * @param  \InfluxDB2\Model\ScriptCreateRequest $script_create_request The script to create. (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Script|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScriptsWithHttpInfo($script_create_request)
    {
        $request = $this->postScriptsRequest($script_create_request);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Script';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScripts'
     *
     * @param  \InfluxDB2\Model\ScriptCreateRequest $script_create_request The script to create. (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScriptsRequest($script_create_request)
    {
        // verify the required parameter 'script_create_request' is set
        if ($script_create_request === null || (is_array($script_create_request) && count($script_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_create_request when calling postScripts'
            );
        }

        $resourcePath = '/api/v2/scripts';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($script_create_request)) {
            $_tempBody = $script_create_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScriptsIDInvoke
     *
     * Invoke a script
     *
     * @param  string $script_id Script ID. Only returns scripts with this ID. (required)
     * @param  \InfluxDB2\Model\ScriptInvocationParams $script_invocation_params script_invocation_params (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postScriptsIDInvoke($script_id, $script_invocation_params = null)
    {
        list($response) = $this->postScriptsIDInvokeWithHttpInfo($script_id, $script_invocation_params);
        return $response;
    }

    /**
     * Operation postScriptsIDInvokeWithHttpInfo
     *
     * Invoke a script
     *
     * @param  string $script_id Script ID. Only returns scripts with this ID. (required)
     * @param  \InfluxDB2\Model\ScriptInvocationParams $script_invocation_params (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScriptsIDInvokeWithHttpInfo($script_id, $script_invocation_params = null)
    {
        $request = $this->postScriptsIDInvokeRequest($script_id, $script_invocation_params);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\SplFileObject';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScriptsIDInvoke'
     *
     * @param  string $script_id Script ID. Only returns scripts with this ID. (required)
     * @param  \InfluxDB2\Model\ScriptInvocationParams $script_invocation_params (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScriptsIDInvokeRequest($script_id, $script_invocation_params = null)
    {
        // verify the required parameter 'script_id' is set
        if ($script_id === null || (is_array($script_id) && count($script_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $script_id when calling postScriptsIDInvoke'
            );
        }

        $resourcePath = '/api/v2/scripts/{scriptID}/invoke';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($script_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scriptID' . '}',
                ObjectSerializer::toPathValue($script_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($script_invocation_params)) {
            $_tempBody = $script_invocation_params;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['text/csv', 'application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['text/csv', 'application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
