/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import org.graalvm.visualvm.jfr.utils.ValuesChecker;

public final class DurationFormatter {
    private static final NumberFormat DECIMAL_LZ_FORMAT = new DecimalFormat("00");
    private static final NumberFormat DECIMAL_NLZ_FORMAT = new DecimalFormat("#0");
    private static final NumberFormat DURATION_MS_FORMAT = NumberFormat.getNumberInstance();

    private DurationFormatter() {
    }

    public static String format(Duration d) {
        return DurationFormatter.format(d, new StringBuffer()).toString();
    }

    public static StringBuffer format(Duration d, StringBuffer b) {
        if (ValuesChecker.isMaxDuration(d)) {
            return b.append("\u221e");
        }
        long s = d.getSeconds();
        if (s > 0L) {
            DurationFormatter.formatSeconds(s, b);
        }
        int n = d.getNano();
        return b.append(DURATION_MS_FORMAT.format((float)n / 1000000.0f)).append(" ms");
    }

    private static StringBuffer formatSeconds(long seconds, StringBuffer b) {
        long minutes;
        long hours = seconds / 3600L;
        if (hours > 0L) {
            b.append(DECIMAL_NLZ_FORMAT.format(hours)).append(" h ");
        }
        if ((minutes = (seconds %= 3600L) / 60L) > 0L || hours > 0L) {
            b.append((hours > 0L ? DECIMAL_LZ_FORMAT : DECIMAL_NLZ_FORMAT).format(minutes)).append(" m ");
        }
        return b.append((minutes > 0L || hours > 0L ? DECIMAL_LZ_FORMAT : DECIMAL_NLZ_FORMAT).format(seconds %= 60L)).append(" s ");
    }

    static {
        DURATION_MS_FORMAT.setMaximumFractionDigits(3);
        DURATION_MS_FORMAT.setMinimumFractionDigits(3);
    }
}

