/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalOnly$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$Update$;
import xsbt.boot.internal.shaded.coursier.credentials.Credentials;
import xsbt.boot.internal.shaded.coursier.credentials.DirectCredentials;
import xsbt.boot.internal.shaded.coursier.credentials.DirectCredentials$;
import xsbt.boot.internal.shaded.coursier.credentials.FileCredentials;
import xsbt.boot.internal.shaded.coursier.credentials.FileCredentials$;
import xsbt.boot.internal.shaded.coursier.credentials.Password;
import xsbt.boot.internal.shaded.coursier.credentials.Password$;
import xsbt.boot.internal.shaded.coursier.parse.CachePolicyParser$;
import xsbt.boot.internal.shaded.coursier.parse.CredentialsParser$;
import xsbt.boot.internal.shaded.coursier.paths.CachePath;
import xsbt.boot.internal.shaded.coursier.paths.CoursierPaths;
import xsbt.boot.internal.shaded.coursier.util.Sync$;
import xsbt.boot.internal.shaded.scala.cli.config.ConfigDb;
import xsbt.boot.internal.shaded.scala.cli.config.ConfigDb$;
import xsbt.boot.internal.shaded.scala.cli.config.Keys$;
import xsbt.boot.internal.shaded.scala.cli.config.PasswordOption;
import xsbt.boot.internal.shaded.scala.cli.config.RepositoryCredentials;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int retryCount;
    private static FiniteDuration retryBackoffInitialDelay;
    private static double retryBackoffMultiplier;
    private static Option<Object> maxRedirections;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private static volatile int bitmap$0;

    static {
        checksums = new $colon$colon<Nothing$>((Nothing$)((Object)new Some<String>("SHA-1")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$));
        bufferSize = 0x100000;
        noEnvCachePolicies = new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalUpdateChanging$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalOnly$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$Update$.MODULE$), Nil$.MODULE$)));
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 1) == 0) {
                location = CachePath.defaultCacheDirectory();
                bitmap$0 |= 1;
            }
        }
        return location;
    }

    public final File location() {
        if ((bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return location;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 4) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.parallel-download-count").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return Try$.MODULE$.apply(() -> {
                        String string;
                        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
                    }).toOption();
                }).getOrElse(() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 |= 4;
            }
        }
        return concurrentDownloadCount;
    }

    public final int concurrentDownloadCount() {
        if ((bitmap$0 & 4) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 8) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 |= 8;
            }
        }
        return pool;
    }

    public final ExecutorService pool() {
        if ((bitmap$0 & 8) == 0) {
            return this.pool$lzycompute();
        }
        return pool;
    }

    /*
     * WARNING - void declaration
     */
    public final Either<Throwable, Duration> parseDuration(String s) {
        void var1_1;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((String)s), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar(x$1))))) {
            return new Right<Throwable, Duration>(Duration$.MODULE$.Zero());
        }
        if ((s = Try$.MODULE$.apply(() -> CacheDefaults$.$anonfun$parseDuration$2((String)s))) instanceof Success) {
            s = (Success)s;
            s = (Duration)((Success)s).value();
            return new Right(s);
        }
        if (s instanceof Failure) {
            s = (Failure)s;
            Throwable t = ((Failure)s).exception();
            return new Left(var1_1);
        }
        throw new MatchError(var1_1);
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x10) == 0) {
                Option option = Option$.MODULE$.apply(System.getenv("COURSIER_TTL")).flatMap((Function1<String, Option> & Serializable)x$2 -> {
                    String string;
                    return MODULE$.parseDuration(string).toOption();
                });
                ttl = option.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0<Some> & Serializable)() -> new Some<FiniteDuration>(CacheDefaults$.default$1()));
                bitmap$0 |= 0x10;
            }
        }
        return ttl;
    }

    public final Option<Duration> ttl() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.ttl$lzycompute();
        }
        return ttl;
    }

    public final Seq<Option<String>> checksums() {
        return checksums;
    }

    public final int defaultRetryCount() {
        return 5;
    }

    private FiniteDuration defaultRetryBackoffInitialDelay() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).milliseconds();
    }

    private double defaultRetryBackoffMultiplier() {
        return 2.0;
    }

    private int retryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x20) == 0) {
                retryCount = BoxesRunTime.unboxToInt(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.exception-retry").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return Try$.MODULE$.apply(() -> {
                        String string;
                        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
                    }).toOption();
                }).filter(x$4 -> x$4 >= 0).getOrElse(() -> MODULE$.defaultRetryCount()));
                bitmap$0 |= 0x20;
            }
        }
        return retryCount;
    }

    public final int retryCount() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.retryCount$lzycompute();
        }
        return retryCount;
    }

    private FiniteDuration retryBackoffInitialDelay$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x40) == 0) {
                retryBackoffInitialDelay = (FiniteDuration)scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.exception-retry-backoff-initial-delay").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return MODULE$.parseDuration(string).toOption();
                }).collect(new Serializable(){

                    /*
                     * WARNING - void declaration
                     */
                    public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var1_1;
                        void var2_2;
                        A1 A1 = x1;
                        if (A1 instanceof FiniteDuration) {
                            x1 = (FiniteDuration)A1;
                            return (B1)x1;
                        }
                        return (B1)var2_2.apply(var1_1);
                    }

                    public final boolean isDefinedAt(Duration x1) {
                        Duration duration = x1;
                        return duration instanceof FiniteDuration;
                    }
                }).getOrElse((Function0<FiniteDuration> & Serializable)() -> MODULE$.defaultRetryBackoffInitialDelay());
                bitmap$0 |= 0x40;
            }
        }
        return retryBackoffInitialDelay;
    }

    public final FiniteDuration retryBackoffInitialDelay() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.retryBackoffInitialDelay$lzycompute();
        }
        return retryBackoffInitialDelay;
    }

    private double retryBackoffMultiplier$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x80) == 0) {
                retryBackoffMultiplier = BoxesRunTime.unboxToDouble(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.exception-retry-backoff-multiplier").flatMap((Function1<String, Option> & Serializable)s -> {
                    String string;
                    return Try$.MODULE$.apply(() -> {
                        String string;
                        return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string));
                    }).toOption();
                }).filter(x$5 -> x$5 > 0.0).getOrElse(() -> MODULE$.defaultRetryBackoffMultiplier()));
                bitmap$0 |= 0x80;
            }
        }
        return retryBackoffMultiplier;
    }

    public final double retryBackoffMultiplier() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.retryBackoffMultiplier$lzycompute();
        }
        return retryBackoffMultiplier;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x100) == 0) {
                maxRedirections = CacheDefaults$.prop$1("xsbt.boot.internal.shaded.coursier.http.maxRedirects").orElse((Function0<Option> & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0<Option> & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 |= 0x100;
            }
        }
        return maxRedirections;
    }

    public final Option<Object> maxRedirections() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return maxRedirections;
    }

    public final int bufferSize() {
        return bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply(System.getenv("COURSIER_CREDENTIALS")).orElse((Function0<Option> & Serializable)() -> scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.credentials")).map((Function1<String, String> & Serializable)s -> {
            String string;
            return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(string), (Function1<Object, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$credentialPropOpt$3(BoxesRunTime.unboxToChar(x$8))));
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPropFile(String s) {
        void var1_1;
        return s.startsWith("/") || var1_1.startsWith("file:");
    }

    /*
     * WARNING - void declaration
     */
    public final Seq<Credentials> credentials() {
        void var1_1;
        Seq<Credentials> seq;
        Seq seq2;
        if (this.credentialPropOpt().isEmpty()) {
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(CoursierPaths.configDirectories()));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> {
                File file;
                return new File(file, "credentials.properties");
            });
            configDirs = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> {
                File file;
                return new File(file, "credentials");
            });
            Seq files = (Seq)configDirs.flatMap((Function1<File, Seq> & Serializable)dir2 -> {
                File[] fileArray;
                File[] listOrNull = dir2.listFiles((dir, name) -> {
                    void var1_1;
                    return !name.startsWith(".") && var1_1.endsWith(".properties");
                });
                Option$ option$ = Option$.MODULE$;
                return (Seq)option$.option2Iterable(option$.apply(fileArray)).toSeq().flatten((Function1<File[], ArraySeq.ofRef> & Serializable)xs -> {
                    File[] fileArray;
                    return Predef$.MODULE$.wrapRefArray((Object[])fileArray);
                });
            });
            Option$ option$ = Option$.MODULE$;
            Seq otherFiles = (Seq)((IterableOps)option$.option2Iterable(option$.apply(files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1<File, FileCredentials> & Serializable)f -> {
                File file;
                return FileCredentials$.MODULE$.apply(file.getAbsolutePath(), true);
            });
            seq2 = (Seq)((IterableOps)mainCredentialsFiles.map((Function1<File, FileCredentials> & Serializable)f -> {
                File file;
                return FileCredentials$.MODULE$.apply(file.getAbsolutePath(), true);
            })).$plus$plus(otherFiles);
        } else {
            seq2 = (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt()).toSeq().flatMap((Function1<String, Seq> & Serializable)x0$1 -> {
                String string;
                if (x0$1 != null) {
                    x0$1.hashCode();
                }
                if (MODULE$.isPropFile((String)x0$1)) {
                    String path0;
                    path0 = x0$1.startsWith("file:") ? new File(new URI((String)x0$1)).getAbsolutePath() : path0;
                    return new $colon$colon<Nothing$>((Nothing$)((Object)FileCredentials$.MODULE$.apply(string, true)), Nil$.MODULE$);
                }
                return (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            });
        }
        Seq legacyCredentials = seq2;
        Path configPath = CoursierPaths.scalaConfigFile();
        seq = this.credentialsFromConfig((Path)((Object)seq));
        return (Seq)seq.$plus$plus(var1_1);
    }

    public final Seq<Credentials> credentialsFromConfig(Path configPath) {
        ConfigDb configDb;
        configDb = (ConfigDb)ConfigDb$.MODULE$.open((Path)((Object)configDb)).fold((Function1<Exception, Nothing$> & Serializable)e -> {
            Exception exception;
            throw new Exception(exception);
        }, (Function1<ConfigDb, ConfigDb> & Serializable)x -> {
            ConfigDb configDb;
            return Predef$.MODULE$.identity(configDb);
        });
        return (Seq)configDb.get(Keys$.MODULE$.repositoryCredentials()).fold((Function1<ConfigDb.ConfigDbFormatError, Nothing$> & Serializable)e -> {
            ConfigDb.ConfigDbFormatError configDbFormatError;
            throw new Exception(configDbFormatError);
        }, (Function1<Option, List> & Serializable)x$9 -> ((List)x$9.getOrElse((Function0<Nil$> & Serializable)() -> Nil$.MODULE$)).map((Function1<RepositoryCredentials, DirectCredentials> & Serializable)c -> {
            RepositoryCredentials repositoryCredentials;
            return DirectCredentials$.MODULE$.apply(c.host(), c.user().map((Function1<PasswordOption, String> & Serializable)x$10 -> x$10.get().value()), c.password().map((Function1<PasswordOption, Password> & Serializable)p -> {
                PasswordOption passwordOption;
                return Password$.MODULE$.apply(passwordOption.get().value());
            }), c.realm(), BoxesRunTime.unboxToBoolean(c.optional().getOrElse(() -> DirectCredentials$.MODULE$.defaultOptional())), BoxesRunTime.unboxToBoolean(c.matchHost().getOrElse(() -> DirectCredentials$.MODULE$.defaultMatchHost())), BoxesRunTime.unboxToBoolean(c.httpsOnly().getOrElse(() -> DirectCredentials$.MODULE$.defaultHttpsOnly())), BoxesRunTime.unboxToBoolean(repositoryCredentials.passOnRedirect().getOrElse(() -> DirectCredentials$.MODULE$.defaultPassOnRedirect())));
        }));
    }

    public final Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public final Seq<CachePolicy> cachePolicies() {
        Option option = CacheDefaults$.fromOption$1(Option$.MODULE$.apply(System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)option.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0<Seq> & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    public static final /* synthetic */ Duration $anonfun$parseDuration$2(String s$2) {
        String string;
        return Duration$.MODULE$.apply(string);
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.ttl").flatMap((Function1<String, Option> & Serializable)x$3 -> {
            String string;
            return MODULE$.parseDuration(string).toOption();
        });
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        String string;
        return scala.sys.package$.MODULE$.props().get(string).flatMap((Function1<String, Option> & Serializable)s -> {
            String string;
            return Try$.MODULE$.apply(() -> {
                String string;
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
            }).toOption();
        }).filter(x$7 -> x$7 >= 0);
    }

    public static final /* synthetic */ boolean $anonfun$credentialPropOpt$3(char x$8) {
        char c;
        return RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(c));
    }

    public static final /* synthetic */ boolean $anonfun$cachePolicies$1(String x$11) {
        String string;
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
    }

    public static final /* synthetic */ Option $anonfun$cachePolicies$2(String description$1, String str) {
        Seq seq;
        Either<$colon$colon<String>, Seq<CachePolicy>> either;
        boolean bl = false;
        Right right = null;
        if ((either = CachePolicyParser$.MODULE$.cachePolicies((String)((Object)either), MODULE$.noEnvCachePolicies()).either()) instanceof Right) {
            bl = true;
            right = (Right)either;
            SeqOps seqOps = (Seq)right.value();
            if (seqOps != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seqOps))) {
                new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                SeqFactory$UnapplySeqWrapper$ seqFactory$UnapplySeqWrapper$ = SeqFactory$UnapplySeqWrapper$.MODULE$;
                if (seqFactory$UnapplySeqWrapper$.lengthCompare$extension(seqFactory$UnapplySeqWrapper$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description$1).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
        }
        if (bl) {
            Seq policies = (Seq)right.value();
            return new Some<Object>(seq);
        }
        if (either instanceof Left) {
            Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append((String)((Object)seq)).append(", ignoring it.").toString());
            return None$.MODULE$;
        }
        throw new MatchError(either);
    }

    /*
     * WARNING - void declaration
     */
    private static final Option fromOption$1(Option value, String description) {
        void var1_1;
        return value.filter((Function1<String, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$cachePolicies$1(x$11))).flatMap(arg_0 -> CacheDefaults$.$anonfun$cachePolicies$2((String)var1_1, arg_0));
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(scala.sys.package$.MODULE$.props().get("xsbt.boot.internal.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
    }
}

