/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rdclient.requests.BackendResponse;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorHelper;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.RequestStatus;
import com.jetbrains.rdclient.requests.SpeculativeRequestWrapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/requests/SuccessResponseWrapper;", "Lcom/jetbrains/rdclient/requests/BackendResponse$Success;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "Lcom/jetbrains/rdclient/requests/SpeculativeRequestWrapper;", "requestId", "", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "response", "Lcom/jetbrains/rd/ide/model/RdResponse;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(JLcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/RdResponse;Lcom/intellij/openapi/client/ClientAppSession;)V", "getRequestId", "()J", "getPatch", "()Lcom/jetbrains/rd/ide/model/RdPatch;", "getResponse", "()Lcom/jetbrains/rd/ide/model/RdResponse;", "compare", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "req", "context", "apply", "", "virtually", "", "complete", "executed", "intellij.rd.client"})
public final class SuccessResponseWrapper
implements BackendResponse.Success<FrontendRebaseSession, SpeculativeRequestWrapper> {
    private final long requestId;
    @Nullable
    private final RdPatch patch;
    @NotNull
    private final RdResponse response;
    @NotNull
    private final ClientAppSession session;

    public SuccessResponseWrapper(long requestId, @Nullable RdPatch patch, @NotNull RdResponse response, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.requestId = requestId;
        this.patch = patch;
        this.response = response;
        this.session = session;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public final RdPatch getPatch() {
        return this.patch;
    }

    @NotNull
    public final RdResponse getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public SpeculativelyEqualsResult compare(@NotNull SpeculativeRequestWrapper req, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FrontendAsyncRequest originalRequest = req.getRequest();
        if (originalRequest instanceof FrontendAsyncRequestWithImmediateResult) {
            return FrontendAsyncRequestExecutorHelper.INSTANCE.speculativelyEquals(((FrontendAsyncRequestWithImmediateResult)originalRequest).getPatch(), this.patch, (FrontendAsyncRequestWithImmediateResult)originalRequest, true);
        }
        return this.patch == null || this.patch.getChanges().isEmpty() ? SpeculativelyEqualsResult.Equals : SpeculativelyEqualsResult.Different;
    }

    @Override
    public void apply(boolean virtually, @NotNull SpeculativeRequestWrapper req, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.patch != null) {
            FrontendAsyncRequestExecutorHelper.INSTANCE.applyBackendChangesOnly(this.patch, virtually, context, req.getRequest(), this.session);
        }
    }

    @Override
    public void complete(@NotNull SpeculativeRequestWrapper req, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.patch != null) {
            FrontendAsyncRequestExecutorHelper.INSTANCE.applyBackendFeaturesOnlyAndUpdate(this.patch, context, req.getRequest(), this.session);
        }
        req.getRequest().setStatus(RequestStatus.Companion.getCOMPLETED());
        FrontendAsyncRequestExecutorHelper.INSTANCE.fireRequestCompleted(this.session, req.getRequest(), this.response);
    }

    @Override
    public void executed() {
        FrontendAsyncRequestExecutorHelper.INSTANCE.fireResponsesExecuted(this.session, CollectionsKt.listOf((Object)this.response));
    }
}

