/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Optional;
import java.util.Set;

public final class DatabaseKindDialectBuildItem
extends MultiBuildItem {
    private final String dbKind;
    private final Optional<String> databaseProductName;
    private final Optional<String> dialect;
    private final Set<String> matchingDialects;
    private final Optional<String> defaultDatabaseProductVersion;

    public static DatabaseKindDialectBuildItem forCoreDialect(String dbKind, String databaseProductName, Set<String> dialects) {
        return new DatabaseKindDialectBuildItem(dbKind, Optional.empty(), Optional.of(databaseProductName), dialects, Optional.empty());
    }

    public static DatabaseKindDialectBuildItem forCoreDialect(String dbKind, String databaseProductName, Set<String> dialects, String defaultDatabaseProductVersion) {
        return new DatabaseKindDialectBuildItem(dbKind, Optional.empty(), Optional.of(databaseProductName), dialects, Optional.of(defaultDatabaseProductVersion));
    }

    public static DatabaseKindDialectBuildItem forThirdPartyDialect(String dbKind, String dialect) {
        return new DatabaseKindDialectBuildItem(dbKind, Optional.of(dialect), Optional.empty(), Set.of(dialect), Optional.empty());
    }

    public static DatabaseKindDialectBuildItem forThirdPartyDialect(String dbKind, String dialect, String defaultDatabaseProductVersion) {
        return new DatabaseKindDialectBuildItem(dbKind, Optional.of(dialect), Optional.empty(), Set.of(dialect), Optional.of(defaultDatabaseProductVersion));
    }

    @Deprecated
    public DatabaseKindDialectBuildItem(String dbKind, String dialect) {
        this(dbKind, Optional.of(dialect), Optional.empty(), Set.of(dialect), Optional.empty());
    }

    @Deprecated
    public DatabaseKindDialectBuildItem(String dbKind, String dialect, String defaultDatabaseProductVersion) {
        this(dbKind, Optional.of(dialect), Optional.empty(), Set.of(dialect), Optional.of(defaultDatabaseProductVersion));
    }

    private DatabaseKindDialectBuildItem(String dbKind, Optional<String> dialect, Optional<String> databaseProductName, Set<String> matchingDialects, Optional<String> defaultDatabaseProductVersion) {
        this.dbKind = dbKind;
        this.dialect = dialect;
        this.matchingDialects = matchingDialects;
        this.databaseProductName = databaseProductName;
        this.defaultDatabaseProductVersion = defaultDatabaseProductVersion;
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public String getDialect() {
        return this.dialect.get();
    }

    public Optional<String> getDialectOptional() {
        return this.dialect;
    }

    public Set<String> getMatchingDialects() {
        return this.matchingDialects;
    }

    public Optional<String> getDatabaseProductName() {
        return this.databaseProductName;
    }

    public Optional<String> getDefaultDatabaseProductVersion() {
        return this.defaultDatabaseProductVersion;
    }
}

