/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import java.util.Iterator;
import java.util.function.Consumer;

public abstract class AbstractKeywordValidator
implements KeywordValidator {
    private final String keyword;
    protected final JsonNode schemaNode;
    protected final SchemaLocation schemaLocation;

    public AbstractKeywordValidator(String keyword, JsonNode schemaNode, SchemaLocation schemaLocation) {
        this.keyword = keyword;
        this.schemaNode = schemaNode;
        this.schemaLocation = schemaLocation;
    }

    public AbstractKeywordValidator(Keyword keyword, JsonNode schemaNode, SchemaLocation schemaLocation) {
        this(keyword.getValue(), schemaNode, schemaLocation);
    }

    @Override
    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public String toString() {
        return this.getKeyword();
    }

    protected boolean collectAnnotations(ExecutionContext executionContext) {
        return this.collectAnnotations(executionContext, this.getKeyword());
    }

    protected boolean collectAnnotations(ExecutionContext executionContext, String keyword) {
        return executionContext.getExecutionConfig().isAnnotationCollectionEnabled() && executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(keyword);
    }

    protected void putAnnotation(ExecutionContext executionContext, Consumer<Annotation.Builder> customizer) {
        Annotation.Builder builder = Annotation.builder().evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword());
        customizer.accept(builder);
        executionContext.getAnnotations().put(builder.build());
    }

    protected boolean hasAdjacentKeywordInEvaluationPath(ExecutionContext executionContext, String keyword) {
        Iterator<Object> evaluationSchemaPathIterator = executionContext.getEvaluationSchemaPath().descendingIterator();
        Iterator<Schema> evaluationSchemaIterator = executionContext.getEvaluationSchema().descendingIterator();
        boolean stop = false;
        if (evaluationSchemaPathIterator.hasNext()) {
            evaluationSchemaPathIterator.next();
        }
        while (evaluationSchemaIterator.hasNext()) {
            Object evaluationPath;
            Schema schema = evaluationSchemaIterator.next();
            boolean hasKeyword = schema.getSchemaNode().has(keyword);
            if (hasKeyword) {
                return true;
            }
            if (stop) {
                return false;
            }
            if (!evaluationSchemaPathIterator.hasNext() || !"properties".equals(evaluationPath = evaluationSchemaPathIterator.next()) && !"items".equals(evaluationPath)) continue;
            stop = true;
        }
        return false;
    }

    protected boolean hasUnevaluatedItemsInEvaluationPath(ExecutionContext executionContext) {
        return executionContext.isUnevaluatedItemsPresent() && this.hasAdjacentKeywordInEvaluationPath(executionContext, "unevaluatedItems");
    }

    protected boolean hasUnevaluatedPropertiesInEvaluationPath(ExecutionContext executionContext) {
        return executionContext.isUnevaluatedPropertiesPresent() && this.hasAdjacentKeywordInEvaluationPath(executionContext, "unevaluatedProperties");
    }
}

