/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.StringOps$;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class BitmapIndexedSetNode<A>
extends SetNode<A> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public BitmapIndexedSetNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.content = content;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
    }

    public int dataMap() {
        return this.dataMap;
    }

    public void dataMap_$eq(int x$1) {
        this.dataMap = x$1;
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    public void nodeMap_$eq(int x$1) {
        this.nodeMap = x$1;
    }

    public Object[] content() {
        return this.content;
    }

    public void content_$eq(Object[] x$1) {
        this.content = x$1;
    }

    public int[] originalHashes() {
        return this.originalHashes;
    }

    public void originalHashes_$eq(int[] x$1) {
        this.originalHashes = x$1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    public void cachedJavaKeySetHashCode_$eq(int x$1) {
        this.cachedJavaKeySetHashCode = x$1;
    }

    @Override
    public A getPayload(int index) {
        return (A)this.content()[index];
    }

    @Override
    public int getHash(int index) {
        return this.originalHashes()[index];
    }

    @Override
    public SetNode<A> getNode(int index) {
        return (SetNode)this.content()[this.content().length - 1 - index];
    }

    @Override
    public boolean contains(A element, int originalHash, int elementHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(elementHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(element, this.getPayload(index));
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((SetNode)this.getNode(index)).contains(element, originalHash, elementHash, shift + 5);
        }
        return false;
    }

    @Override
    public BitmapIndexedSetNode<A> updated(A element, int originalHash, int elementHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(elementHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            A element0 = this.getPayload(index);
            if (element0 == element) {
                return this;
            }
            int element0UnimprovedHash = this.getHash(index);
            int element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
            if (originalHash == element0UnimprovedHash && BoxesRunTime.equals(element0, element)) {
                return this;
            }
            SetNode<A> subNodeNew = this.mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(bitpos, element0Hash, subNodeNew);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            SetNode<A> subNodeNew;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            if (subNode == (subNodeNew = ((SetNode)subNode).updated(element, originalHash, elementHash, shift + 5))) {
                return this;
            }
            return this.copyAndSetNode(bitpos, (SetNode<A>)subNode, subNodeNew);
        }
        return this.copyAndInsertValue(bitpos, element, originalHash, elementHash);
    }

    /*
     * Unable to fully structure code
     */
    public int updateWithShallowMutations(A element, int originalHash, int elementHash, int shift, int shallowlyMutableNodeMap) {
        block5: {
            mask = Node$.MODULE$.maskFrom(elementHash, shift);
            bitpos = Node$.MODULE$.bitposFrom(mask);
            if ((this.dataMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
                element0 = this.getPayload(index);
                element0UnimprovedHash = this.getHash(index);
                if (element0UnimprovedHash == originalHash && BoxesRunTime.equals(element0, element)) {
                    return shallowlyMutableNodeMap;
                }
                element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
                subNodeNew = this.mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
                this.migrateFromInlineToNodeInPlace(bitpos, element0Hash, subNodeNew);
                return shallowlyMutableNodeMap | bitpos;
            }
            if ((this.nodeMap() & bitpos) == 0) break block5;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            subNode = this.getNode(index);
            subNodeSize = subNode.size();
            subNodeCachedJavaKeySetHashCode = subNode.cachedJavaKeySetHashCode();
            returnNodeMap = shallowlyMutableNodeMap;
            var19_18 = subNode;
            if (!(var19_18 instanceof BitmapIndexedSetNode)) ** GOTO lbl-1000
            subNodeBm = var20_19 = (BitmapIndexedSetNode)var19_18;
            if ((bitpos & shallowlyMutableNodeMap) != 0) {
                subNodeBm.updateWithShallowMutations(element, originalHash, elementHash, shift + 5, 0);
                v0 = subNodeBm;
            } else lbl-1000:
            // 2 sources

            {
                if ((subNodeNew = subNode.updated(element, originalHash, elementHash, shift + 5)) != subNode) {
                    returnNodeMap |= bitpos;
                }
                v0 = subNodeNew;
            }
            subNodeNew = v0;
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew;
            this.size_$eq(this.size() - subNodeSize + subNodeNew.size());
            this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - subNodeCachedJavaKeySetHashCode + subNodeNew.cachedJavaKeySetHashCode());
            return returnNodeMap;
        }
        idx = dataIx = this.dataIndex(bitpos);
        src = this.content();
        dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = element;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        this.dataMap_$eq(this.dataMap() | bitpos);
        this.content_$eq(dst);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() + 1);
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() + elementHash);
        return shallowlyMutableNodeMap;
    }

    @Override
    public BitmapIndexedSetNode<A> removed(A element, int originalHash, int elementHash, int shift) {
        int mask = Node$.MODULE$.maskFrom(elementHash, shift);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            A element0 = this.getPayload(index);
            if (BoxesRunTime.equals(element0, element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n = newDataMap = shift == 0 ? this.dataMap() ^ bitpos : Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(elementHash, 0));
                    if (index == 0) {
                        return new BitmapIndexedSetNode<A>(newDataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getPayload(1)}), ClassTag$.MODULE$.Any()), new int[]{this.originalHashes()[1]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[1]));
                    }
                    return new BitmapIndexedSetNode<A>(newDataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getPayload(0)}), ClassTag$.MODULE$.Any()), new int[]{this.originalHashes()[0]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[0]));
                }
                return this.copyAndRemoveValue(bitpos, elementHash);
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            SetNode<A> subNodeNew = ((SetNode)subNode).removed(element, originalHash, elementHash, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            int n = subNodeNew.size();
            if (1 == n) {
                if (this.size() == ((SetNode)subNode).size()) {
                    return (BitmapIndexedSetNode)subNodeNew;
                }
                return this.copyAndMigrateFromNodeToInline(bitpos, elementHash, (SetNode<A>)subNode, subNodeNew);
            }
            int subNodeNewSize = n;
            if (subNodeNewSize > 1) {
                return this.copyAndSetNode(bitpos, (SetNode<A>)subNode, subNodeNew);
            }
            return this;
        }
        return this;
    }

    public BitmapIndexedSetNode<A> removeWithShallowMutations(A element, int originalHash, int elementHash) {
        int mask = Node$.MODULE$.maskFrom(elementHash, 0);
        int bitpos = Node$.MODULE$.bitposFrom(mask);
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            A element0 = this.getPayload(index);
            if (BoxesRunTime.equals(element0, element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap = this.dataMap() ^ bitpos;
                    if (index == 0) {
                        Object[] newContent = (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getPayload(1)}), ClassTag$.MODULE$.Any());
                        int[] newOriginalHashes = new int[]{this.originalHashes()[1]};
                        int newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.getHash(1));
                        this.content_$eq(newContent);
                        this.originalHashes_$eq(newOriginalHashes);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    } else {
                        Object[] newContent = (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.getPayload(0)}), ClassTag$.MODULE$.Any());
                        int[] newOriginalHashes = new int[]{this.originalHashes()[0]};
                        int newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.getHash(0));
                        this.content_$eq(newContent);
                        this.originalHashes_$eq(newOriginalHashes);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    }
                    this.dataMap_$eq(newDataMap);
                    this.nodeMap_$eq(0);
                    this.size_$eq(1);
                    return this;
                }
                int dataIx = this.dataIndex(bitpos);
                int idx = 1 * dataIx;
                Object[] src = this.content();
                Object[] dst = new Object[src.length - 1];
                System.arraycopy(src, 0, dst, 0, idx);
                System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
                int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
                this.dataMap_$eq(this.dataMap() ^ bitpos);
                this.content_$eq(dst);
                this.originalHashes_$eq(dstHashes);
                this.size_$eq(this.size() - 1);
                this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - elementHash);
                return this;
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index);
            BitmapIndexedSetNode subNodeNew = (BitmapIndexedSetNode)((SetNode)subNode).removed(element, originalHash, elementHash, 5);
            if (subNodeNew == subNode) {
                return this;
            }
            if (subNodeNew.size() == 1) {
                if (this.payloadArity() == 0 && this.nodeArity() == 1) {
                    this.dataMap_$eq(subNodeNew.dataMap());
                    this.nodeMap_$eq(subNodeNew.nodeMap());
                    this.content_$eq(subNodeNew.content());
                    this.originalHashes_$eq(subNodeNew.originalHashes());
                    this.size_$eq(subNodeNew.size());
                    this.cachedJavaKeySetHashCode_$eq(subNodeNew.cachedJavaKeySetHashCode());
                    return this;
                }
                this.migrateFromNodeToInlineInPlace(bitpos, originalHash, elementHash, (SetNode<A>)subNode, subNodeNew);
                return this;
            }
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew;
            this.size_$eq(this.size() - 1);
            this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - subNode.cachedJavaKeySetHashCode() + subNodeNew.cachedJavaKeySetHashCode());
            return this;
        }
        return this;
    }

    public SetNode<A> mergeTwoKeyValPairs(A key0, int originalKeyHash0, int keyHash0, A key1, int originalKeyHash1, int keyHash1, int shift) {
        int mask1;
        if (shift >= 32) {
            return new HashCollisionSetNode(originalKeyHash0, keyHash0, (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key0, key1})));
        }
        int mask0 = Node$.MODULE$.maskFrom(keyHash0, shift);
        if (mask0 != (mask1 = Node$.MODULE$.maskFrom(keyHash1, shift))) {
            int dataMap = Node$.MODULE$.bitposFrom(mask0) | Node$.MODULE$.bitposFrom(mask1);
            int newCachedHashCode = keyHash0 + keyHash1;
            if (mask0 < mask1) {
                return new BitmapIndexedSetNode<A>(dataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key0, key1}), ClassTag$.MODULE$.Any()), new int[]{originalKeyHash0, originalKeyHash1}, 2, newCachedHashCode);
            }
            return new BitmapIndexedSetNode<A>(dataMap, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key1, key0}), ClassTag$.MODULE$.Any()), new int[]{originalKeyHash1, originalKeyHash0}, 2, newCachedHashCode);
        }
        int nodeMap = Node$.MODULE$.bitposFrom(mask0);
        SetNode<A> node = this.mergeTwoKeyValPairs(key0, originalKeyHash0, keyHash0, key1, originalKeyHash1, keyHash1, shift + 5);
        return new BitmapIndexedSetNode<A>(0, nodeMap, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{node}), ClassTag$.MODULE$.Any()), Array$.MODULE$.emptyIntArray(), node.size(), node.cachedJavaKeySetHashCode());
    }

    @Override
    public boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    @Override
    public boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    public int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap() & bitpos - 1);
    }

    public int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap() & bitpos - 1);
    }

    public BitmapIndexedSetNode<A> copyAndSetNode(int bitpos, SetNode<A> oldNode, SetNode<A> newNode) {
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx] = newNode;
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + newNode.cachedJavaKeySetHashCode());
    }

    public BitmapIndexedSetNode<A> copyAndInsertValue(int bitpos, A key, int originalHash, int elementHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap(), dst, dstHashes, this.size() + 1, this.cachedJavaKeySetHashCode() + elementHash);
    }

    public BitmapIndexedSetNode<A> copyAndSetValue(int bitpos, A key, int originalHash, int elementHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx] = key;
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap(), dst, this.originalHashes(), this.size(), this.cachedJavaKeySetHashCode());
    }

    public BitmapIndexedSetNode<A> copyAndRemoveValue(int bitpos, int elementHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ bitpos, this.nodeMap(), dst, dstHashes, this.size() - 1, this.cachedJavaKeySetHashCode() - elementHash);
    }

    public BitmapIndexedSetNode<A> copyAndMigrateFromInlineToNode(int bitpos, int elementHash, SetNode<A> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ bitpos, this.nodeMap() | bitpos, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - elementHash + node.cachedJavaKeySetHashCode());
    }

    public BitmapIndexedSetNode<A> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, SetNode<A> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        System.arraycopy(this.content(), idxOld + 1, this.content(), idxOld, idxNew - idxOld);
        this.content()[idxNew] = node;
        this.dataMap_$eq(this.dataMap() ^ bitpos);
        this.nodeMap_$eq(this.nodeMap() | bitpos);
        this.originalHashes_$eq(this.removeElement(this.originalHashes(), dataIx));
        this.size_$eq(this.size() - 1 + node.size());
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
        return this;
    }

    public BitmapIndexedSetNode<A> copyAndMigrateFromNodeToInline(int bitpos, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 1 * dataIxNew;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = node.getPayload(0);
        System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap() ^ bitpos, dst, dstHashes, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    public void migrateFromNodeToInlineInPlace(int bitpos, int originalHash, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        A element = node.getPayload(0);
        System.arraycopy(this.content(), dataIxNew, this.content(), dataIxNew + 1, idxOld - dataIxNew);
        this.content()[dataIxNew] = element;
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        this.dataMap_$eq(this.dataMap() | bitpos);
        this.nodeMap_$eq(this.nodeMap() ^ bitpos);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() - oldNode.size() + 1);
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        int thisPayloadArity = this.payloadArity();
        for (int i = 0; i < thisPayloadArity; ++i) {
            f.apply(this.getPayload(i));
        }
        int thisNodeArity = this.nodeArity();
        for (int j = 0; j < thisNodeArity; ++j) {
            ((SetNode)this.getNode(j)).foreach(f);
        }
    }

    @Override
    public boolean subsetOf(SetNode<A> that, int shift) {
        if (this == that) {
            return true;
        }
        SetNode<A> setNode = that;
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            return false;
        }
        if (setNode instanceof BitmapIndexedSetNode) {
            int nodeBitmap;
            BitmapIndexedSetNode bitmapIndexedSetNode;
            BitmapIndexedSetNode node = bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            int thisBitmap = this.dataMap() | this.nodeMap();
            if ((thisBitmap | (nodeBitmap = node.dataMap() | node.nodeMap())) != nodeBitmap) {
                return false;
            }
            int bitmap = thisBitmap & nodeBitmap;
            int bitsToSkip = Integer.numberOfTrailingZeros(bitmap);
            boolean isValidSubset = true;
            while (isValidSubset && bitsToSkip < 32) {
                int newBitmap;
                boolean bl;
                int bitpos = Node$.MODULE$.bitposFrom(bitsToSkip);
                if ((this.dataMap() & bitpos) != 0) {
                    if ((node.dataMap() & bitpos) != 0) {
                        A payload1;
                        A payload0 = this.getPayload(Node$.MODULE$.indexFrom(this.dataMap(), bitpos));
                        bl = BoxesRunTime.equals(payload0, payload1 = node.getPayload(Node$.MODULE$.indexFrom(node.dataMap(), bitpos)));
                    } else {
                        int thisDataIndex = Node$.MODULE$.indexFrom(this.dataMap(), bitpos);
                        A payload = this.getPayload(thisDataIndex);
                        SetNode<A> subNode = that.getNode(Node$.MODULE$.indexFrom(node.nodeMap(), bitpos));
                        int elementUnimprovedHash = this.getHash(thisDataIndex);
                        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
                        bl = subNode.contains(payload, elementUnimprovedHash, elementHash, shift + 5);
                    }
                } else {
                    Node subNode1;
                    Node subNode0;
                    bl = (node.dataMap() & bitpos) == 0 && ((SetNode)(subNode0 = this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), bitpos)))).subsetOf(subNode1 = node.getNode(Node$.MODULE$.indexFrom(node.nodeMap(), bitpos)), shift + 5);
                }
                isValidSubset = bl;
                bitmap = newBitmap = bitmap ^ bitpos;
                bitsToSkip = Integer.numberOfTrailingZeros(newBitmap);
            }
            return isValidSubset;
        }
        throw new MatchError(setNode);
    }

    @Override
    public BitmapIndexedSetNode<A> filterImpl(Function1<A, Object> pred, boolean flipped) {
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            if (BoxesRunTime.unboxToBoolean(pred.apply(this.getPayload(0))) != flipped) {
                return this;
            }
            return SetNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                boolean passed;
                int bitpos = Node$.MODULE$.bitposFrom(i);
                if ((bitpos & this.dataMap()) == 0) continue;
                A payload = this.getPayload(dataIndex);
                boolean bl = passed = BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped;
                if (passed) {
                    newDataMap |= bitpos;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.getHash(dataIndex));
                }
                ++dataIndex;
            }
            if (newDataMap == 0) {
                return SetNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize];
            int[] newOriginalHashCodes = new int[newSize];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int bitpos = Node$.MODULE$.bitposFrom(j);
                if ((bitpos & newDataMap) == 0) continue;
                int oldIndex = Node$.MODULE$.indexFrom(this.dataMap(), bitpos);
                newContent[newDataIndex] = this.content()[oldIndex];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[oldIndex];
                ++newDataIndex;
            }
            return new BitmapIndexedSetNode<A>(newDataMap, 0, newContent, newOriginalHashCodes, newSize, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        Object nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            int bitpos = Node$.MODULE$.bitposFrom(i);
            if ((bitpos & this.dataMap()) != 0) {
                boolean passed;
                A payload = this.getPayload(dataIndex);
                boolean bl = passed = BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped;
                if (passed) {
                    newDataMap |= bitpos;
                    oldDataPassThrough |= bitpos;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.getHash(dataIndex));
                }
                ++dataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            SetNode<A> newSubNode = ((SetNode)oldSubNode).filterImpl(pred, flipped);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= bitpos;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= bitpos;
                } else {
                    mapOfNewNodes |= bitpos;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= bitpos;
                nodeMigrateToDataTargetMap |= bitpos;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = Queue$.MODULE$.empty();
                }
                ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        return this.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
    }

    @Override
    public BitmapIndexedSetNode<A> diff(SetNode<A> that, int shift) {
        SetNode<A> setNode = that;
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode;
            BitmapIndexedSetNode bm = bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            if (this.size() == 0) {
                return this;
            }
            if (this.size() == 1) {
                int h = this.getHash(0);
                if (that.contains(this.getPayload(0), h, Hashing$.MODULE$.improve(h), shift)) {
                    return SetNode$.MODULE$.empty();
                }
                return this;
            }
            int allMap = this.dataMap() | this.nodeMap();
            int minimumIndex = Integer.numberOfTrailingZeros(allMap);
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
            int oldDataPassThrough = 0;
            int nodeMigrateToDataTargetMap = 0;
            Object nodesToMigrateToData = null;
            int nodesToPassThroughMap = 0;
            int mapOfNewNodes = 0;
            Object newNodes = null;
            int newDataMap = 0;
            int newNodeMap = 0;
            int newSize = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            int nodeIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                SetNode<A> setNode2;
                int bitpos = Node$.MODULE$.bitposFrom(i);
                if ((bitpos & this.dataMap()) != 0) {
                    int hash;
                    int originalHash;
                    A payload = this.getPayload(dataIndex);
                    if (!bm.contains(payload, originalHash = this.getHash(dataIndex), hash = Hashing$.MODULE$.improve(originalHash), shift)) {
                        newDataMap |= bitpos;
                        oldDataPassThrough |= bitpos;
                        ++newSize;
                        newCachedHashCode += hash;
                    }
                    ++dataIndex;
                    continue;
                }
                if ((bitpos & this.nodeMap()) == 0) continue;
                SetNode<A> oldSubNode = this.getNode(nodeIndex);
                if ((bitpos & bm.dataMap()) != 0) {
                    int thatDataIndex = Node$.MODULE$.indexFrom(bm.dataMap(), bitpos);
                    A thatPayload = bm.getPayload(thatDataIndex);
                    int thatOriginalHash = bm.getHash(thatDataIndex);
                    int thatHash = Hashing$.MODULE$.improve(thatOriginalHash);
                    setNode2 = oldSubNode.removed(thatPayload, thatOriginalHash, thatHash, shift + 5);
                } else {
                    setNode2 = (bitpos & bm.nodeMap()) != 0 ? oldSubNode.diff((SetNode<A>)bm.getNode(Node$.MODULE$.indexFrom(bm.nodeMap(), bitpos)), shift + 5) : oldSubNode;
                }
                SetNode<A> newSubNode = setNode2;
                newSize += newSubNode.size();
                newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
                if (newSubNode.size() > 1) {
                    newNodeMap |= bitpos;
                    if (oldSubNode == newSubNode) {
                        nodesToPassThroughMap |= bitpos;
                    } else {
                        mapOfNewNodes |= bitpos;
                        if (newNodes == null) {
                            newNodes = Queue$.MODULE$.empty();
                        }
                        ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                    }
                } else if (newSubNode.size() == 1) {
                    newDataMap |= bitpos;
                    nodeMigrateToDataTargetMap |= bitpos;
                    if (nodesToMigrateToData == null) {
                        nodesToMigrateToData = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
                }
                ++nodeIndex;
            }
            return this.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
        }
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            throw new RuntimeException("BitmapIndexedSetNode diff HashCollisionSetNode");
        }
        throw new MatchError(setNode);
    }

    private BitmapIndexedSetNode<A> newNodeFrom(int newSize, int newDataMap, int newNodeMap, int minimumIndex, int oldDataPassThrough, int nodesToPassThroughMap, int nodeMigrateToDataTargetMap, Queue<SetNode<A>> nodesToMigrateToData, int mapOfNewNodes, Queue<SetNode<A>> newNodes, int newCachedHashCode) {
        if (newSize == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            int bitpos = Node$.MODULE$.bitposFrom(i);
            if ((bitpos & oldDataPassThrough) != 0) {
                newContent[newDataIndex] = this.getPayload(oldDataIndex);
                newOriginalHashes[newDataIndex] = this.getHash(oldDataIndex);
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & nodeMigrateToDataTargetMap) != 0) {
                if (nodesToMigrateToData == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                SetNode<A> node = nodesToMigrateToData.dequeue();
                newContent[newDataIndex] = node.getPayload(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & mapOfNewNodes) != 0) {
                if (newNodes == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                newContent[newContentSize - newNodeIndex - 1] = newNodes.dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedSetNode<A>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)object;
            BitmapIndexedSetNode node = bitmapIndexedSetNode;
            return this == node || this.cachedJavaKeySetHashCode() == node.cachedJavaKeySetHashCode() && this.nodeMap() == node.nodeMap() && this.dataMap() == node.dataMap() && this.size() == node.size() && Arrays.equals(this.originalHashes(), node.originalHashes()) && this.deepContentEquality(this.content(), node.content(), this.content().length);
        }
        return false;
    }

    private boolean deepContentEquality(Object[] a1, Object[] a2, int length) {
        if (a1 == a2) {
            return true;
        }
        boolean isEqual = true;
        for (int i = 0; isEqual && i < length; ++i) {
            isEqual = BoxesRunTime.equals(a1[i], a2[i]);
        }
        return isEqual;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension("BitmapIndexedSetNode(size=%s, dataMap=%x, nodeMap=%x)", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.size()), BoxesRunTime.boxToInteger(this.dataMap()), BoxesRunTime.boxToInteger(this.nodeMap())}));
    }

    @Override
    public BitmapIndexedSetNode<A> copy() {
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()); i < contentLength; ++i) {
            contentClone[i] = ((SetNode)contentClone[i]).copy();
        }
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), contentClone, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    @Override
    public BitmapIndexedSetNode<A> concat(SetNode<A> that, int shift) {
        SetNode<A> setNode = that;
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode;
            BitmapIndexedSetNode bm = bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            if (this.size() == 0) {
                return bm;
            }
            if (bm.size() == 0 || bm == this) {
                return this;
            }
            if (bm.size() == 1) {
                int originalHash = bm.getHash(0);
                return this.updated((Object)bm.getPayload(0), originalHash, Hashing$.MODULE$.improve(originalHash), shift);
            }
            boolean anyChangesMadeSoFar = false;
            int allMap = this.dataMap() | bm.dataMap() | this.nodeMap() | bm.nodeMap();
            int minimumBitPos = Node$.MODULE$.bitposFrom(Integer.numberOfTrailingZeros(allMap));
            int maximumBitPos = Node$.MODULE$.bitposFrom(32 - Integer.numberOfLeadingZeros(allMap) - 1);
            int leftNodeRightNode = 0;
            int leftDataRightNode = 0;
            int leftNodeRightData = 0;
            int leftDataOnly = 0;
            int rightDataOnly = 0;
            int leftNodeOnly = 0;
            int rightNodeOnly = 0;
            int leftDataRightDataMigrateToNode = 0;
            int leftDataRightDataLeftOverwrites = 0;
            int dataToNodeMigrationTargets = 0;
            int bitpos = minimumBitPos;
            int leftIdx = 0;
            int rightIdx = 0;
            boolean finished = false;
            while (!finished) {
                if ((bitpos & this.dataMap()) != 0) {
                    if ((bitpos & bm.dataMap()) != 0) {
                        if (this.getHash(leftIdx) == bm.getHash(rightIdx) && BoxesRunTime.equals(this.getPayload(leftIdx), bm.getPayload(rightIdx))) {
                            leftDataRightDataLeftOverwrites |= bitpos;
                        } else {
                            leftDataRightDataMigrateToNode |= bitpos;
                            dataToNodeMigrationTargets |= Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(Hashing$.MODULE$.improve(this.getHash(leftIdx)), shift));
                        }
                        ++rightIdx;
                    } else if ((bitpos & bm.nodeMap()) != 0) {
                        leftDataRightNode |= bitpos;
                    } else {
                        leftDataOnly |= bitpos;
                    }
                    ++leftIdx;
                } else if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bm.dataMap()) != 0) {
                        leftNodeRightData |= bitpos;
                        ++rightIdx;
                    } else if ((bitpos & bm.nodeMap()) != 0) {
                        leftNodeRightNode |= bitpos;
                    } else {
                        leftNodeOnly |= bitpos;
                    }
                } else if ((bitpos & bm.dataMap()) != 0) {
                    rightDataOnly |= bitpos;
                    ++rightIdx;
                } else if ((bitpos & bm.nodeMap()) != 0) {
                    rightNodeOnly |= bitpos;
                }
                if (bitpos == maximumBitPos) {
                    finished = true;
                    continue;
                }
                bitpos <<= 1;
            }
            int newDataMap = leftDataOnly | rightDataOnly | leftDataRightDataLeftOverwrites;
            int newNodeMap = leftNodeRightNode | leftDataRightNode | leftNodeRightData | leftNodeOnly | rightNodeOnly | dataToNodeMigrationTargets;
            if (newDataMap == (leftDataOnly | leftDataRightDataLeftOverwrites) && newNodeMap == leftNodeOnly) {
                return this;
            }
            int newDataSize = Integer.bitCount(newDataMap);
            int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
            Object[] newContent = new Object[newContentSize];
            int[] newOriginalHashes = new int[newDataSize];
            int newSize = 0;
            int newCachedHashCode = 0;
            int leftDataIdx = 0;
            int rightDataIdx = 0;
            int leftNodeIdx = 0;
            int rightNodeIdx = 0;
            int nextShift = shift + 5;
            int compressedDataIdx = 0;
            int compressedNodeIdx = 0;
            int bitpos2 = minimumBitPos;
            boolean finished2 = false;
            while (!finished2) {
                if ((bitpos2 & leftNodeRightNode) != 0) {
                    SetNode newNode;
                    Node leftNode = this.getNode(leftNodeIdx);
                    if (leftNode != (newNode = ((SetNode)leftNode).concat(bm.getNode(rightNodeIdx), nextShift))) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftNodeIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    Node n = bm.getNode(rightNodeIdx);
                    A leftPayload = this.getPayload(leftDataIdx);
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int leftImproved = Hashing$.MODULE$.improve(leftOriginalHash);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = ((SetNode)n).updated(leftPayload, leftOriginalHash, leftImproved, nextShift);
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftNodeRightData) != 0) {
                    SetNode<A> newNode;
                    int rightOriginalHash = bm.getHash(rightDataIdx);
                    Node leftNode = this.getNode(leftNodeIdx);
                    SetNode<A> updated = ((SetNode)leftNode).updated(bm.getPayload(rightDataIdx), bm.getHash(rightDataIdx), Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    if (updated != leftNode) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = updated;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataOnly) != 0) {
                    int originalHash = this.originalHashes()[leftDataIdx];
                    newContent[compressedDataIdx] = this.getPayload(leftDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++leftDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & rightDataOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    int originalHash = bm.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bm.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & leftNodeOnly) != 0) {
                    Node newNode = this.getNode(leftNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & rightNodeOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    Node newNode = bm.getNode(rightNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataMigrateToNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int rightOriginalHash = bm.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = bm.mergeTwoKeyValPairs(this.getPayload(leftDataIdx), leftOriginalHash, Hashing$.MODULE$.improve(leftOriginalHash), bm.getPayload(rightDataIdx), rightOriginalHash, Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    ++compressedNodeIdx;
                    ++leftDataIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataLeftOverwrites) != 0) {
                    int originalHash = bm.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bm.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                    ++leftDataIdx;
                }
                if (bitpos2 == maximumBitPos) {
                    finished2 = true;
                    continue;
                }
                bitpos2 <<= 1;
            }
            if (anyChangesMadeSoFar) {
                return new BitmapIndexedSetNode<A>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
            }
            return this;
        }
        throw new UnsupportedOperationException("Cannot concatenate a HashCollisionSetNode with a BitmapIndexedSetNode");
    }

    @Override
    public void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.getPayload(i), BoxesRunTime.boxToInteger(this.getHash(i)));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((SetNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    @Override
    public boolean foreachWithHashWhile(Function2<A, Object, Object> f) {
        int thisPayloadArity = this.payloadArity();
        boolean pass = true;
        for (int i = 0; i < thisPayloadArity && pass; ++i) {
            pass = pass && BoxesRunTime.unboxToBoolean(f.apply(this.getPayload(i), BoxesRunTime.boxToInteger(this.getHash(i))));
        }
        int thisNodeArity = this.nodeArity();
        for (int j = 0; j < thisNodeArity && pass; ++j) {
            pass = pass && ((SetNode)this.getNode(j)).foreachWithHashWhile(f);
        }
        return pass;
    }
}

