/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File$;
import dotty.tools.io.Path;
import dotty.tools.io.Streamable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class File
extends Path
implements Streamable.Bytes,
Streamable.Chars {
    private final Codec creationCodec;

    public static File apply(java.nio.file.Path path, Codec codec) {
        return File$.MODULE$.apply(path, codec);
    }

    public static File apply(String string, Codec codec) {
        return File$.MODULE$.apply(string, codec);
    }

    public static String pathSeparator() {
        return File$.MODULE$.pathSeparator();
    }

    public File(java.nio.file.Path jpath, Codec constructorCodec) {
        super(jpath);
        this.creationCodec = constructorCodec;
    }

    @Override
    public BufferedInputStream bufferedInput() {
        return Streamable.Bytes.bufferedInput$(this);
    }

    @Override
    public Iterator<Object> bytes() {
        return Streamable.Bytes.bytes$(this);
    }

    @Override
    public Iterator<Object> bytesAsInts() {
        return Streamable.Bytes.bytesAsInts$(this);
    }

    @Override
    public byte[] toByteArray() {
        return Streamable.Bytes.toByteArray$(this);
    }

    @Override
    public BufferedSource chars(Codec codec) {
        return Streamable.Chars.chars$(this, codec);
    }

    @Override
    public Iterator<String> lines() {
        return Streamable.Chars.lines$(this);
    }

    @Override
    public Iterator<String> lines(Codec codec) {
        return Streamable.Chars.lines$(this, codec);
    }

    @Override
    public InputStreamReader reader(Codec codec) {
        return Streamable.Chars.reader$(this, codec);
    }

    @Override
    public BufferedReader bufferedReader() {
        return Streamable.Chars.bufferedReader$(this);
    }

    @Override
    public BufferedReader bufferedReader(Codec codec) {
        return Streamable.Chars.bufferedReader$(this, codec);
    }

    @Override
    public <T> T applyReader(Function1<BufferedReader, T> f) {
        return (T)Streamable.Chars.applyReader$(this, f);
    }

    @Override
    public String slurp() {
        return Streamable.Chars.slurp$(this);
    }

    @Override
    public String slurp(Codec codec) {
        return Streamable.Chars.slurp$(this, codec);
    }

    private java.nio.file.Path jpath$accessor() {
        return super.jpath();
    }

    @Override
    public Codec creationCodec() {
        return this.creationCodec;
    }

    @Override
    public File toAbsolute() {
        if (this.isAbsolute()) {
            return this;
        }
        return super.toAbsolute().toFile();
    }

    @Override
    public Directory toDirectory() {
        return new Directory(this.jpath$accessor());
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public File normalize() {
        return super.normalize().toFile();
    }

    @Override
    public long length() {
        return super.length();
    }

    @Override
    public Iterator<Path> walkFilter(Function1<Path, Object> cond) {
        if (BoxesRunTime.unboxToBoolean((Object)cond.apply((Object)this))) {
            return package$.MODULE$.Iterator().single((Object)this);
        }
        return package$.MODULE$.Iterator().empty();
    }

    @Override
    public InputStream inputStream() {
        return Files.newInputStream(this.jpath$accessor(), new OpenOption[0]);
    }

    public OutputStream outputStream(boolean append) {
        if (append) {
            return Files.newOutputStream(this.jpath$accessor(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.jpath$accessor(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean outputStream$default$1() {
        return false;
    }

    public BufferedOutputStream bufferedOutput(boolean append) {
        return new BufferedOutputStream(this.outputStream(append));
    }

    public boolean bufferedOutput$default$1() {
        return false;
    }

    public OutputStreamWriter writer(boolean append, Codec codec) {
        return new OutputStreamWriter(this.outputStream(append), codec.charSet());
    }

    public BufferedWriter bufferedWriter() {
        return this.bufferedWriter(false);
    }

    public BufferedWriter bufferedWriter(boolean append) {
        return this.bufferedWriter(append, this.creationCodec());
    }

    public BufferedWriter bufferedWriter(boolean append, Codec codec) {
        return new BufferedWriter(this.writer(append, codec));
    }

    public PrintWriter printWriter() {
        return new PrintWriter((Writer)this.bufferedWriter(), true);
    }

    public void writeAll(Seq<String> strings) {
        try (BufferedWriter out = this.bufferedWriter();){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$1 -> out.write((String)_$1));
        }
    }

    public void appendAll(Seq<String> strings) {
        try (BufferedWriter out = this.bufferedWriter(true);){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$2 -> out.write((String)_$2));
        }
    }

    public void printlnAll(Seq<String> strings) {
        try (PrintWriter out = this.printWriter();){
            strings.foreach((Function1)(JProcedure1 & Serializable)_$3 -> out.println((String)_$3));
        }
    }

    public Option<String> safeSlurp() {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)this.slurp());
        }
        catch (IOException iOException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        boolean bl;
        Method method;
        try {
            method = java.io.File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        Method method2 = method;
        try {
            bl = (Boolean)method2.invoke((Object)this.jpath$accessor().toFile(), Predef$.MODULE$.boolean2Boolean(executable), Predef$.MODULE$.boolean2Boolean(ownerOnly));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean setExecutable$default$2() {
        return true;
    }
}

