/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.scheduledJob;

import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.ScheduledJobsDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ScheduledJob;
import org.opensearch.searchrelevance.transport.scheduledJob.PostScheduledExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class PostScheduledExperimentTransportAction
extends HandledTransportAction<PostScheduledExperimentRequest, IndexResponse> {
    private final ClusterService clusterService;
    private final ScheduledJobsDao scheduledJobsDao;
    private final ExperimentDao experimentDao;
    private static final Logger LOGGER = LogManager.getLogger(PostScheduledExperimentTransportAction.class);

    @Inject
    public PostScheduledExperimentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ScheduledJobsDao scheduledJobsDao, ExperimentDao experimentDao) {
        super("cluster:admin/opensearch/search_relevance/scheduledexperiment/create", transportService, actionFilters, PostScheduledExperimentRequest::new);
        this.clusterService = clusterService;
        this.scheduledJobsDao = scheduledJobsDao;
        this.experimentDao = experimentDao;
    }

    protected void doExecute(Task task, PostScheduledExperimentRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            String experimentId = request.getExperimentId();
            String cronExpression = request.getCronExpression();
            CronSchedule schedule = new CronSchedule(cronExpression, ZoneId.systemDefault());
            String id = experimentId;
            Instant now = Instant.now();
            ScheduledJob job = new ScheduledJob(id, now, now, true, (Schedule)schedule, TimeUtils.getTimestamp());
            this.experimentDao.getExperiment(experimentId, (ActionListener<SearchResponse>)ActionListener.wrap(experimentResponse -> {
                Experiment updatedExperiment = this.convertToExperiment((SearchResponse)experimentResponse);
                Experiment finalUpdatedExperiment = new Experiment(updatedExperiment, true, job.getId());
                this.scheduledJobsDao.putScheduledJob(job, ActionListener.wrap(indexResponse -> this.experimentDao.updateExperiment(finalUpdatedExperiment, ActionListener.wrap(experimentIndexResponse -> listener.onResponse((Object)((IndexResponse)indexResponse)), e -> {
                    LOGGER.error("Failed to update experiment to scheduled");
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to update experiment to scheduled", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
                })), e -> {
                    LOGGER.error("Failed to index job", (Throwable)e);
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to index job", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
                }));
            }, e -> {
                LOGGER.error("No experiment underlying experiment provided with id {}", (Object)experimentId);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to find experiment", RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (Exception e2) {
            LOGGER.error("Failed to process job request", (Throwable)e2);
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to process job request", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    private Experiment convertToExperiment(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("QuerySet not found", RestStatus.NOT_FOUND);
        }
        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
        return new Experiment((String)sourceMap.get("id"), TimeUtils.getTimestamp(), ExperimentType.valueOf((String)sourceMap.get("type")), AsyncStatus.valueOf((String)sourceMap.get("status")), (String)sourceMap.get("querySetId"), (List)sourceMap.get("searchConfigurationList"), (List)sourceMap.get("judgmentList"), (Integer)sourceMap.get("size"), (List)sourceMap.get("results"));
    }
}

