/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.query;

import com.o19s.es.ltr.feature.PrebuiltFeature;
import com.o19s.es.ltr.feature.PrebuiltFeatureSet;
import com.o19s.es.ltr.feature.PrebuiltLtrModel;
import com.o19s.es.ltr.query.RankerQuery;
import com.o19s.es.ltr.ranker.LtrRanker;
import com.o19s.es.ltr.ranker.ranklib.RankLibScriptEngine;
import com.o19s.es.ltr.utils.AbstractQueryBuilderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;
import org.opensearch.script.Script;

public class LtrQueryBuilder
extends AbstractQueryBuilder<LtrQueryBuilder> {
    public static final String NAME = "ltr";
    private static final ObjectParser<LtrQueryBuilder, Void> PARSER = new ObjectParser("ltr", LtrQueryBuilder::new);
    private static final String DEFAULT_SCRIPT_LANG = "ranklib";
    private Script _rankLibScript;
    private List<QueryBuilder> _features;
    private LTRStats _ltrStats;

    public LtrQueryBuilder() {
    }

    public LtrQueryBuilder(Script _rankLibScript, List<QueryBuilder> features, LTRStats ltrStats) {
        this._rankLibScript = _rankLibScript;
        this._features = features;
        this._ltrStats = ltrStats;
    }

    public LtrQueryBuilder(StreamInput in, LTRStats ltrStats) throws IOException {
        super(in);
        this._features = AbstractQueryBuilderUtils.readQueries(in);
        this._rankLibScript = new Script(in);
        this._ltrStats = ltrStats;
    }

    private static void doXArrayContent(String field, List<QueryBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        builder.startArray(field);
        for (QueryBuilder clause : clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
    }

    public static LtrQueryBuilder fromXContent(XContentParser parser, LTRStats ltrStats) throws IOException {
        LtrQueryBuilder builder;
        try {
            builder = (LtrQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
        if (builder._rankLibScript == null) {
            throw new ParsingException(parser.getTokenLocation(), "[ltr] query requires a model, none specified", new Object[0]);
        }
        builder.ltrStats(ltrStats);
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        AbstractQueryBuilderUtils.writeQueries(out, this._features);
        this._rankLibScript.writeTo(out);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        this.printBoostAndQueryName(builder);
        LtrQueryBuilder.doXArrayContent("features", this._features, builder, params);
        builder.field("model", (ToXContent)this._rankLibScript);
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        this._ltrStats.getStat(StatName.LTR_REQUEST_TOTAL_COUNT.getName()).increment();
        try {
            return this._doToQuery(context);
        }
        catch (Exception e) {
            this._ltrStats.getStat(StatName.LTR_REQUEST_ERROR_COUNT.getName()).increment();
            throw e;
        }
    }

    private Query _doToQuery(QueryShardContext context) throws IOException {
        List<PrebuiltFeature> features = new ArrayList(this._features.size());
        for (QueryBuilder builder : this._features) {
            features.add(new PrebuiltFeature(builder.queryName(), builder.toQuery(context)));
        }
        features = Collections.unmodifiableList(features);
        RankLibScriptEngine.RankLibModelContainer.Factory factory = (RankLibScriptEngine.RankLibModelContainer.Factory)context.compile(this._rankLibScript, RankLibScriptEngine.CONTEXT);
        RankLibScriptEngine.RankLibModelContainer executableScript = factory.newInstance();
        LtrRanker ranker = (LtrRanker)executableScript.run();
        PrebuiltFeatureSet featureSet = new PrebuiltFeatureSet(this.queryName(), features);
        PrebuiltLtrModel model = new PrebuiltLtrModel(ranker.name(), ranker, featureSet);
        return RankerQuery.build(model, this._ltrStats);
    }

    public QueryBuilder doRewrite(QueryRewriteContext ctx) throws IOException {
        if (this._features == null || this._rankLibScript == null || this._features.isEmpty()) {
            return new MatchAllQueryBuilder();
        }
        ArrayList<QueryBuilder> newFeatures = null;
        boolean changed = false;
        int i = 0;
        for (QueryBuilder qb : this._features) {
            QueryBuilder newQuery = (QueryBuilder)Rewriteable.rewrite((Rewriteable)qb, (QueryRewriteContext)ctx);
            if (changed |= newQuery != qb) {
                if (newFeatures == null) {
                    newFeatures = new ArrayList<QueryBuilder>(this._features.size());
                    newFeatures.addAll(this._features.subList(0, i));
                }
                newFeatures.add(newQuery);
            }
            ++i;
        }
        if (changed) {
            assert (newFeatures.size() == this._features.size());
            return new LtrQueryBuilder(this._rankLibScript, (List<QueryBuilder>)newFeatures, this._ltrStats);
        }
        return this;
    }

    protected int doHashCode() {
        return Objects.hash(this._rankLibScript, this._features);
    }

    protected boolean doEquals(LtrQueryBuilder other) {
        return Objects.equals(this._rankLibScript, other._rankLibScript) && Objects.equals(this._features, other._features);
    }

    public String getWriteableName() {
        return NAME;
    }

    public final Script rankerScript() {
        return this._rankLibScript;
    }

    public final LtrQueryBuilder rankerScript(Script rankLibModel) {
        this._rankLibScript = rankLibModel;
        return this;
    }

    public final LtrQueryBuilder ltrStats(LTRStats ltrStats) {
        this._ltrStats = ltrStats;
        return this;
    }

    public List<QueryBuilder> features() {
        return this._features;
    }

    public final LtrQueryBuilder features(List<QueryBuilder> features) {
        this._features = features;
        return this;
    }

    static {
        LtrQueryBuilder.declareStandardFields(PARSER);
        PARSER.declareObjectArray(LtrQueryBuilder::features, (parser, context) -> LtrQueryBuilder.parseInnerQueryBuilder((XContentParser)parser), new ParseField("features", new String[0]));
        PARSER.declareField((parser, ltr, context) -> ltr.rankerScript(Script.parse((XContentParser)parser, (String)DEFAULT_SCRIPT_LANG)), new ParseField("model", new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
    }
}

