/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr;

import ciir.umass.edu.learning.RankerFactory;
import com.o19s.es.explore.ExplorerQueryBuilder;
import com.o19s.es.ltr.action.AddFeaturesToSetAction;
import com.o19s.es.ltr.action.CachesStatsAction;
import com.o19s.es.ltr.action.ClearCachesAction;
import com.o19s.es.ltr.action.CreateModelFromSetAction;
import com.o19s.es.ltr.action.FeatureStoreAction;
import com.o19s.es.ltr.action.ListStoresAction;
import com.o19s.es.ltr.action.TransportAddFeatureToSetAction;
import com.o19s.es.ltr.action.TransportCacheStatsAction;
import com.o19s.es.ltr.action.TransportClearCachesAction;
import com.o19s.es.ltr.action.TransportCreateModelFromSetAction;
import com.o19s.es.ltr.action.TransportFeatureStoreAction;
import com.o19s.es.ltr.action.TransportListStoresAction;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.feature.store.index.CachedFeatureStore;
import com.o19s.es.ltr.feature.store.index.Caches;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import com.o19s.es.ltr.logging.LoggingFetchSubPhase;
import com.o19s.es.ltr.logging.LoggingSearchExtBuilder;
import com.o19s.es.ltr.query.LtrQueryBuilder;
import com.o19s.es.ltr.query.StoredLtrQueryBuilder;
import com.o19s.es.ltr.query.ValidatingLtrQueryBuilder;
import com.o19s.es.ltr.ranker.parser.LinearRankerParser;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import com.o19s.es.ltr.ranker.parser.XGBoostJsonParser;
import com.o19s.es.ltr.ranker.parser.XGBoostRawJsonParser;
import com.o19s.es.ltr.ranker.ranklib.RankLibScriptEngine;
import com.o19s.es.ltr.ranker.ranklib.RanklibModelParser;
import com.o19s.es.ltr.rest.RestAddFeatureToSet;
import com.o19s.es.ltr.rest.RestCreateModelFromSet;
import com.o19s.es.ltr.rest.RestFeatureManager;
import com.o19s.es.ltr.rest.RestFeatureStoreCaches;
import com.o19s.es.ltr.rest.RestSearchStoreElements;
import com.o19s.es.ltr.rest.RestStoreManager;
import com.o19s.es.ltr.utils.FeatureStoreLoader;
import com.o19s.es.ltr.utils.Suppliers;
import com.o19s.es.termstat.TermStatQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.analysis.PreConfiguredTokenFilter;
import org.opensearch.index.analysis.PreConfiguredTokenizer;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.ltr.breaker.LTRCircuitBreakerService;
import org.opensearch.ltr.rest.RestStatsLTRAction;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.ltr.stats.LTRStat;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;
import org.opensearch.ltr.stats.suppliers.CacheStatsOnNodeSupplier;
import org.opensearch.ltr.stats.suppliers.CounterSupplier;
import org.opensearch.ltr.stats.suppliers.PluginHealthStatusSupplier;
import org.opensearch.ltr.stats.suppliers.StoreStatsSupplier;
import org.opensearch.ltr.transport.LTRStatsAction;
import org.opensearch.ltr.transport.TransportLTRStatsAction;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class LtrQueryParserPlugin
extends Plugin
implements SearchPlugin,
ScriptPlugin,
ActionPlugin,
AnalysisPlugin,
SystemIndexPlugin {
    public static final String LTR_BASE_URI = "/_plugins/_ltr";
    public static final String LTR_LEGACY_BASE_URI = "/_opendistro/_ltr";
    private final LtrRankerParserFactory parserFactory;
    private final Caches caches;
    private final LTRStats ltrStats;
    private static final int STORABLE_ELEMENT_MAX_NAME_SIZE = 512;

    public LtrQueryParserPlugin(Settings settings) {
        this.caches = new Caches(settings);
        Supplier<RankerFactory> ranklib = Suppliers.memoize(RankerFactory::new);
        this.parserFactory = new LtrRankerParserFactory.Builder().register("model/ranklib", () -> new RanklibModelParser((RankerFactory)ranklib.get())).register("model/linear", LinearRankerParser::new).register("model/xgboost+json", XGBoostJsonParser::new).register("model/xgboost+json+raw", XGBoostRawJsonParser::new).build();
        this.ltrStats = this.getInitialStats();
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Arrays.asList(new SearchPlugin.QuerySpec("match_explorer", input -> new ExplorerQueryBuilder(input, this.ltrStats), ctx -> ExplorerQueryBuilder.fromXContent(ctx, this.ltrStats)), new SearchPlugin.QuerySpec("ltr", input -> new LtrQueryBuilder(input, this.ltrStats), ctx -> LtrQueryBuilder.fromXContent(ctx, this.ltrStats)), new SearchPlugin.QuerySpec("sltr", input -> new StoredLtrQueryBuilder(this.getFeatureStoreLoader(), input, this.ltrStats), ctx -> StoredLtrQueryBuilder.fromXContent(this.getFeatureStoreLoader(), ctx, this.ltrStats)), new SearchPlugin.QuerySpec("term_stat", TermStatQueryBuilder::new, TermStatQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("validating_ltr_query", input -> new ValidatingLtrQueryBuilder(input, this.parserFactory, this.ltrStats), ctx -> ValidatingLtrQueryBuilder.fromXContent(ctx, this.parserFactory, this.ltrStats)));
    }

    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Collections.singletonList(new LoggingFetchSubPhase());
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        return Collections.singletonList(new SearchPlugin.SearchExtSpec("ltr_log", LoggingSearchExtBuilder::new, LoggingSearchExtBuilder::parse));
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new RankLibScriptEngine(this.parserFactory);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<BaseRestHandler> list = new ArrayList<BaseRestHandler>();
        for (String type : ValidatingLtrQueryBuilder.SUPPORTED_TYPES) {
            list.add(new RestFeatureManager(type));
            list.add(new RestSearchStoreElements(type));
        }
        list.add(new RestStoreManager());
        list.add(new RestFeatureStoreCaches());
        list.add(new RestCreateModelFromSet());
        list.add(new RestAddFeatureToSet());
        list.add(new RestStatsLTRAction(this.ltrStats));
        return Collections.unmodifiableList(list);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.unmodifiableList(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)FeatureStoreAction.INSTANCE, TransportFeatureStoreAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CachesStatsAction.INSTANCE, TransportCacheStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearCachesAction.INSTANCE, TransportClearCachesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AddFeaturesToSetAction.INSTANCE, TransportAddFeatureToSetAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateModelFromSetAction.INSTANCE, TransportCreateModelFromSetAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ListStoresAction.INSTANCE, TransportListStoresAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)LTRStatsAction.INSTANCE, TransportLTRStatsAction.class, new Class[0])));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.unmodifiableList(Arrays.asList(new NamedWriteableRegistry.Entry(StorableElement.class, "feature", StoredFeature::new), new NamedWriteableRegistry.Entry(StorableElement.class, "featureset", StoredFeatureSet::new), new NamedWriteableRegistry.Entry(StorableElement.class, "model", StoredLtrModel::new)));
    }

    public List<ScriptContext<?>> getContexts() {
        ScriptContext<RankLibScriptEngine.RankLibModelContainer.Factory> contexts = RankLibScriptEngine.CONTEXT;
        return Collections.singletonList(contexts);
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Collections.unmodifiableList(Arrays.asList(new NamedXContentRegistry.Entry(StorableElement.class, new ParseField("feature", new String[0]), StoredFeature::parse), new NamedXContentRegistry.Entry(StorableElement.class, new ParseField("featureset", new String[0]), StoredFeatureSet::parse), new NamedXContentRegistry.Entry(StorableElement.class, new ParseField("model", new String[0]), StoredLtrModel::parse)));
    }

    public List<Setting<?>> getSettings() {
        List<Setting<?>> list1 = LTRSettings.getInstance().getSettings();
        List<Setting> list2 = Arrays.asList(IndexFeatureStore.STORE_VERSION_PROP, Caches.LTR_CACHE_MEM_SETTING, Caches.LTR_CACHE_EXPIRE_AFTER_READ, Caches.LTR_CACHE_EXPIRE_AFTER_WRITE);
        return Collections.unmodifiableList(Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList()));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        clusterService.addListener(event -> {
            for (Index i : event.indicesDeleted()) {
                if (!IndexFeatureStore.isIndexStore(i.getName())) continue;
                this.caches.evict(i.getName());
            }
        });
        LTRSettings.getInstance().init(clusterService);
        JvmService jvmService = new JvmService(environment.settings());
        LTRCircuitBreakerService ltrCircuitBreakerService = new LTRCircuitBreakerService(jvmService).init();
        this.addStats(client, clusterService, ltrCircuitBreakerService);
        return Arrays.asList(this.caches, this.parserFactory, ltrCircuitBreakerService, this.ltrStats);
    }

    private void addStats(Client client, ClusterService clusterService, LTRCircuitBreakerService ltrCircuitBreakerService) {
        StoreStatsSupplier storeStatsSupplier = StoreStatsSupplier.create(client, clusterService);
        this.ltrStats.addStats(StatName.LTR_STORES_STATS.getName(), new LTRStat<Map<String, Map<String, Object>>>(true, storeStatsSupplier));
        PluginHealthStatusSupplier pluginHealthStatusSupplier = PluginHealthStatusSupplier.create(client, clusterService, ltrCircuitBreakerService);
        this.ltrStats.addStats(StatName.LTR_PLUGIN_STATUS.getName(), new LTRStat<String>(true, pluginHealthStatusSupplier));
    }

    private LTRStats getInitialStats() {
        HashMap stats = new HashMap();
        stats.put(StatName.LTR_CACHE_STATS.getName(), new LTRStat<Map<String, Map<String, Object>>>(false, new CacheStatsOnNodeSupplier(this.caches)));
        stats.put(StatName.LTR_REQUEST_TOTAL_COUNT.getName(), new LTRStat<Long>(false, new CounterSupplier()));
        stats.put(StatName.LTR_REQUEST_ERROR_COUNT.getName(), new LTRStat<Long>(false, new CounterSupplier()));
        return new LTRStats(stats);
    }

    protected FeatureStoreLoader getFeatureStoreLoader() {
        return (storeName, clientSupplier) -> new CachedFeatureStore(new IndexFeatureStore(storeName, clientSupplier, this.parserFactory), this.caches);
    }

    public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        return Arrays.asList(PreConfiguredTokenFilter.singleton((String)"ltr_edge_ngram", (boolean)true, ts -> new EdgeNGramTokenFilter(ts, 1, 512, false)), PreConfiguredTokenFilter.singleton((String)"ltr_length", (boolean)true, ts -> new LengthFilter(ts, 0, 512)));
    }

    public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        return Collections.singletonList(PreConfiguredTokenizer.singleton((String)"ltr_keyword", () -> new KeywordTokenizer(256)));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        ArrayList<SystemIndexDescriptor> systemIndexDescriptors = new ArrayList<SystemIndexDescriptor>();
        systemIndexDescriptors.add(new SystemIndexDescriptor(".ltrstore*", "Indices for LTR stores"));
        return systemIndexDescriptors;
    }
}

