/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.grok;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.opensearch.sql.common.grok.Converter;
import org.opensearch.sql.common.grok.Grok;
import org.opensearch.sql.common.grok.GrokUtils;
import org.opensearch.sql.common.grok.exception.GrokException;

public class Match {
    private final CharSequence subject;
    private final Grok grok;
    private final Matcher match;
    private final int start;
    private final int end;
    private boolean keepEmptyCaptures = true;
    private Map<String, Object> capture = Collections.emptyMap();
    public static final Match EMPTY = new Match("", null, null, 0, 0);

    public Match(CharSequence subject, Grok grok, Matcher match, int start, int end) {
        this.subject = subject;
        this.grok = grok;
        this.match = match;
        this.start = start;
        this.end = end;
    }

    public Matcher getMatch() {
        return this.match;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setKeepEmptyCaptures(boolean ignore) {
        if (this.capture.size() > 0) {
            this.capture = new LinkedHashMap<String, Object>();
        }
        this.keepEmptyCaptures = ignore;
    }

    public boolean isKeepEmptyCaptures() {
        return this.keepEmptyCaptures;
    }

    public CharSequence getSubject() {
        return this.subject;
    }

    public Map<String, Object> capture() {
        return this.capture(false);
    }

    private Map<String, Object> capture(boolean flattened) throws GrokException {
        if (this.match == null) {
            return Collections.emptyMap();
        }
        if (!this.capture.isEmpty()) {
            return this.capture;
        }
        this.capture = new LinkedHashMap<String, Object>();
        Map<String, String> mappedw = GrokUtils.namedGroups(this.match, this.grok.namedGroups);
        mappedw.forEach((key, valueString) -> {
            String id = this.grok.getNamedRegexCollectionById((String)key);
            if (id != null && !id.isEmpty()) {
                key = id;
            }
            if ("UNWANTED".equals(key)) {
                return;
            }
            Object value = valueString;
            if (valueString != null) {
                Converter.IConverter<? extends Object> converter = this.grok.converters.get(key);
                if (converter != null) {
                    key = Converter.extractKey(key);
                    try {
                        value = converter.convert((String)valueString);
                    }
                    catch (Exception e) {
                        this.capture.put(key + "_grokfailure", e.toString());
                    }
                    if (value instanceof String) {
                        value = this.cleanString((String)value);
                    }
                } else {
                    value = this.cleanString((String)valueString);
                }
            } else if (!this.isKeepEmptyCaptures()) {
                return;
            }
            if (this.capture.containsKey(key)) {
                Object currentValue = this.capture.get(key);
                if (flattened) {
                    if (currentValue == null && value != null) {
                        this.capture.put((String)key, value);
                    }
                    if (currentValue != null && value != null) {
                        throw new GrokException(String.format("key '%s' has multiple non-null values, this is not allowed in flattened mode, values:'%s', '%s'", key, currentValue, value));
                    }
                } else if (currentValue instanceof List) {
                    List cvl = (List)currentValue;
                    cvl.add(value);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(currentValue);
                    list.add(value);
                    this.capture.put((String)key, list);
                }
            } else {
                this.capture.put((String)key, value);
            }
        });
        this.capture = Collections.unmodifiableMap(this.capture);
        return this.capture;
    }

    public Map<String, Object> captureFlattened() throws GrokException {
        return this.capture(true);
    }

    private String cleanString(String value) {
        char lastChar;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar == (lastChar = value.charAt(value.length() - 1)) && (firstChar == '\"' || firstChar == '\'')) {
            if (value.length() <= 2) {
                return "";
            }
            int found = 0;
            for (int i = 1; i < value.length() - 1; ++i) {
                if (value.charAt(i) != firstChar) continue;
                ++found;
            }
            if (found == 0) {
                return value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public Boolean isNull() {
        return this.match == null;
    }
}

