/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.Streams;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.securityanalytics.commons.model.IOC;
import org.opensearch.securityanalytics.commons.model.UpdateAction;
import org.opensearch.securityanalytics.commons.store.FeedStore;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.services.STIX2IOCFetchService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.common.StashedThreadContext;
import org.opensearch.securityanalytics.threatIntel.model.DefaultIocStoreConfig;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;

public class STIX2IOCFeedStore
implements FeedStore {
    public static final String IOC_INDEX_NAME_BASE = ".opensearch-sap-iocs";
    public static final String IOC_ALL_INDEX_PATTERN = ".opensearch-sap-iocs-*";
    public static final String IOC_FEED_ID_PLACEHOLDER = "FEED_ID";
    public static final String IOC_INDEX_NAME_TEMPLATE = ".opensearch-sap-iocs-FEED_ID";
    public static final String IOC_ALL_INDEX_PATTERN_BY_ID = ".opensearch-sap-iocs-FEED_ID-*";
    public static final String IOC_TIME_PLACEHOLDER = "TIME";
    public static final String IOC_INDEX_PATTERN = ".opensearch-sap-iocs-FEED_ID-TIME";
    private final Logger log = LogManager.getLogger(STIX2IOCFeedStore.class);
    private final String newActiveIndex;
    Instant startTime = Instant.now();
    private Client client;
    private ClusterService clusterService;
    private SATIFSourceConfig saTifSourceConfig;
    private ActionListener<STIX2IOCFetchService.STIX2IOCFetchResponse> baseListener;
    private Integer batchSize;

    public STIX2IOCFeedStore(Client client, ClusterService clusterService, SATIFSourceConfig saTifSourceConfig, ActionListener<STIX2IOCFetchService.STIX2IOCFetchResponse> listener) {
        this.client = client;
        this.clusterService = clusterService;
        this.saTifSourceConfig = saTifSourceConfig;
        this.baseListener = listener;
        this.batchSize = (Integer)clusterService.getClusterSettings().get(SecurityAnalyticsSettings.BATCH_SIZE);
        this.newActiveIndex = STIX2IOCFeedStore.getNewActiveIndex(saTifSourceConfig.getId());
    }

    public void storeIOCs(Map<IOC, UpdateAction> actionToIOCs) {
        HashMap iocsSortedByAction = new HashMap();
        actionToIOCs.forEach((key, value) -> {
            if (key.getClass() != STIX2IOC.class) {
                throw new IllegalArgumentException("Only supports STIX2-formatted IOCs.");
            }
            iocsSortedByAction.putIfAbsent(value, new ArrayList());
            ((List)iocsSortedByAction.get(value)).add((STIX2IOC)((Object)key));
        });
        block6: for (Map.Entry entry : iocsSortedByAction.entrySet()) {
            switch ((UpdateAction)entry.getKey()) {
                case DELETE: {
                    continue block6;
                }
                case UPSERT: {
                    try {
                        this.indexIocs((List)entry.getValue());
                    }
                    catch (IOException e) {
                        this.baseListener.onFailure((Exception)new RuntimeException(e));
                    }
                    continue block6;
                }
            }
            this.baseListener.onFailure((Exception)new IllegalArgumentException("Unsupported action."));
        }
    }

    public void indexIocs(List<STIX2IOC> iocs) throws IOException {
        StepListener initSourceConfigIndexesListener = new StepListener();
        this.initSourceConfigIndexes((StepListener<Void>)initSourceConfigIndexesListener);
        initSourceConfigIndexesListener.whenComplete(r -> this.bulkIndexIocs(iocs, this.newActiveIndex), e -> {
            this.log.error("Failed to init source config indexes");
            this.baseListener.onFailure(e);
        });
    }

    private void bulkIndexIocs(List<STIX2IOC> iocs, String activeIndex) throws IOException {
        if (iocs.isEmpty()) {
            long duration = Duration.between(this.startTime, Instant.now()).toMillis();
            STIX2IOCFetchService.STIX2IOCFetchResponse output = new STIX2IOCFetchService.STIX2IOCFetchResponse(Collections.emptyList(), duration);
            this.baseListener.onResponse((Object)output);
        }
        ArrayList<BulkRequest> bulkRequestList = new ArrayList<BulkRequest>();
        BulkRequest bulkRequest = new BulkRequest();
        for (STIX2IOC ioc : iocs) {
            IndexRequest indexRequest = new IndexRequest(activeIndex).id(StringUtils.isBlank((CharSequence)ioc.getId()) ? UUID.randomUUID().toString() : ioc.getId()).opType(DocWriteRequest.OpType.INDEX).source(ioc.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            bulkRequest.add(indexRequest);
            if (bulkRequest.requests().size() != this.batchSize.intValue()) continue;
            bulkRequestList.add(bulkRequest);
            bulkRequest = new BulkRequest();
        }
        if (!bulkRequest.requests().isEmpty()) {
            bulkRequestList.add(bulkRequest);
        }
        if (!bulkRequestList.isEmpty()) {
            ((BulkRequest)bulkRequestList.get(bulkRequestList.size() - 1)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        GroupedActionListener bulkResponseListener = new GroupedActionListener(ActionListener.wrap(bulkResponses -> {
            int idx = 0;
            for (BulkResponse response : bulkResponses) {
                BulkRequest request = (BulkRequest)bulkRequestList.get(idx);
                if (response.hasFailures()) {
                    throw new OpenSearchException("Error occurred while ingesting IOCs to {} with an error {}", new Object[]{StringUtils.join((Object[])new Set[]{request.getIndices()}), response.buildFailureMessage()});
                }
                ++idx;
            }
            long duration = Duration.between(this.startTime, Instant.now()).toMillis();
            STIX2IOCFetchService.STIX2IOCFetchResponse output = new STIX2IOCFetchService.STIX2IOCFetchResponse(iocs, duration);
            this.baseListener.onResponse((Object)output);
        }, e -> {
            this.log.error("Failed to index IOCs for config {}", (Object)this.saTifSourceConfig.getId(), e);
            this.baseListener.onFailure(e);
        }), bulkRequestList.size());
        for (BulkRequest req : bulkRequestList) {
            try {
                StashedThreadContext.run(this.client, () -> this.client.bulk(req, (ActionListener)bulkResponseListener));
            }
            catch (OpenSearchException e2) {
                this.log.error("Failed to save IOCs for config {}", (Object)this.saTifSourceConfig.getId(), (Object)e2);
                this.baseListener.onFailure((Exception)((Object)e2));
            }
        }
    }

    public static String getAllIocIndexPatternById(String sourceConfigId) {
        return IOC_ALL_INDEX_PATTERN_BY_ID.replace(IOC_FEED_ID_PLACEHOLDER, sourceConfigId.toLowerCase(Locale.ROOT));
    }

    public static String getNewActiveIndex(String sourceConfigId) {
        return IOC_INDEX_PATTERN.replace(IOC_FEED_ID_PLACEHOLDER, sourceConfigId.toLowerCase(Locale.ROOT)).replace(IOC_TIME_PLACEHOLDER, Long.toString(Instant.now().toEpochMilli()));
    }

    public String iocIndexMapping() {
        String string;
        block8: {
            String iocMappingFile = "mappings/stix2_ioc_mapping.json";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(iocMappingFile);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)is, (OutputStream)out);
                string = out.toString(StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load stix2_ioc_mapping.json file [" + iocMappingFile + "]", e);
                }
            }
            is.close();
        }
        return string;
    }

    public SATIFSourceConfig getSaTifSourceConfig() {
        return this.saTifSourceConfig;
    }

    private void initSourceConfigIndexes(StepListener<Void> stepListener) {
        String iocIndexPattern = STIX2IOCFeedStore.getAllIocIndexPatternById(this.saTifSourceConfig.getId());
        this.initFeedIndex(this.newActiveIndex, (ActionListener<CreateIndexResponse>)ActionListener.wrap(r -> {
            if (this.saTifSourceConfig.getIocStoreConfig() instanceof DefaultIocStoreConfig) {
                ((DefaultIocStoreConfig)this.saTifSourceConfig.getIocStoreConfig()).getIocToIndexDetails().clear();
            }
            this.saTifSourceConfig.getIocTypes().forEach(type -> {
                if (this.saTifSourceConfig.getIocStoreConfig() instanceof DefaultIocStoreConfig) {
                    DefaultIocStoreConfig.IocToIndexDetails iocToIndexDetails = new DefaultIocStoreConfig.IocToIndexDetails((String)type, iocIndexPattern, this.newActiveIndex);
                    ((DefaultIocStoreConfig)this.saTifSourceConfig.getIocStoreConfig()).getIocToIndexDetails().add(iocToIndexDetails);
                }
            });
            stepListener.onResponse(null);
        }, e -> {
            this.log.error("Failed to initialize the IOC index and save the IOCs", (Throwable)e);
            stepListener.onFailure(e);
        }));
    }

    private void initFeedIndex(String feedIndexName, ActionListener<CreateIndexResponse> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(this.newActiveIndex)) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(feedIndexName).mapping(this.iocIndexMapping()).settings(Settings.builder().put("index.hidden", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20").build());
            this.client.admin().indices().create(indexRequest, ActionListener.wrap(r -> {
                this.log.info("Created system index {}", (Object)feedIndexName);
                listener.onResponse(r);
            }, e -> {
                if (e instanceof ResourceAlreadyExistsException || e instanceof RemoteTransportException && e.getCause() instanceof ResourceAlreadyExistsException) {
                    this.log.debug("index {} already exist", (Object)feedIndexName);
                    listener.onResponse(null);
                    return;
                }
                this.log.error("Failed to create system index {}", (Object)feedIndexName);
                listener.onFailure(e);
            }));
        } else {
            listener.onResponse(null);
        }
    }
}

