/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;
import org.opensearch.ml.engine.processor.ProcessorChain;

@Processor(value=MLProcessorType.FOR_EACH)
public class MLForEachProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLForEachProcessor.class);
    private final String path;
    private final List<MLProcessor> processors;

    public MLForEachProcessor(Map<String, Object> config) {
        super(config);
        this.path = (String)config.get("path");
        Object processorsConfig = config.get("processors");
        this.processors = ProcessorChain.parseProcessorConfigs(processorsConfig);
        if (this.processors.isEmpty()) {
            throw new IllegalArgumentException("'processors' list cannot be empty for for_each processor");
        }
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("path")) {
            throw new IllegalArgumentException("'path' is required for for_each processor");
        }
        String pathValue = (String)this.config.get("path");
        if (pathValue == null || pathValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty for for_each processor");
        }
        if (!this.config.containsKey("processors")) {
            throw new IllegalArgumentException("'processors' is required for for_each processor");
        }
    }

    @Override
    public Object process(Object input) {
        try {
            Object arrayObj;
            String jsonStr = StringUtils.toJson((Object)input);
            DocumentContext context = JsonPath.parse((String)jsonStr);
            try {
                arrayObj = context.read(this.path, new Predicate[0]);
            }
            catch (Exception e) {
                log.warn("Path '{}' does not exist in input: {}", (Object)this.path, (Object)e.getMessage());
                return input;
            }
            if (!(arrayObj instanceof List)) {
                log.warn("Path '{}' does not point to an array, found type: {}", (Object)this.path, (Object)arrayObj.getClass().getSimpleName());
                return input;
            }
            List array = (List)arrayObj;
            if (array.isEmpty()) {
                log.debug("Array at path '{}' is empty, nothing to process", (Object)this.path);
                return input;
            }
            ArrayList<Object> processedArray = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                Object element = array.get(i);
                try {
                    Object processed = ProcessorChain.applyProcessors(element, this.processors);
                    processedArray.add(processed);
                    continue;
                }
                catch (Exception e) {
                    log.warn("Failed to process element at index {} in path '{}': {}", (Object)i, (Object)this.path, (Object)e.getMessage());
                    processedArray.add(element);
                }
            }
            String setPath = this.path.replaceAll("\\[\\*\\]$", "");
            context.set(setPath, processedArray, new Predicate[0]);
            return context.json();
        }
        catch (Exception e) {
            log.warn("Failed to process for_each at path '{}': {}", (Object)this.path, (Object)e.getMessage());
            return input;
        }
    }
}

