/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.utilities.RankLibError;

public class DenseDataPoint
extends DataPoint {
    public DenseDataPoint(String text) {
        super(text);
    }

    public DenseDataPoint(DenseDataPoint dp) {
        this.label = dp.label;
        this.id = dp.id;
        this.description = dp.description;
        this.cached = dp.cached;
        this.fVals = new float[dp.fVals.length];
        System.arraycopy(dp.fVals, 0, this.fVals, 0, dp.fVals.length);
    }

    @Override
    public float getFeatureValue(int fid) {
        if (fid <= 0 || fid >= this.fVals.length) {
            throw RankLibError.create("Error in DenseDataPoint::getFeatureValue(): requesting unspecified feature, fid=" + fid);
        }
        if (DenseDataPoint.isUnknown(this.fVals[fid])) {
            return 0.0f;
        }
        return this.fVals[fid];
    }

    @Override
    public void setFeatureValue(int fid, float fval) {
        if (fid <= 0 || fid >= this.fVals.length) {
            throw RankLibError.create("Error in DenseDataPoint::setFeatureValue(): feature (id=" + fid + ") not found.");
        }
        this.fVals[fid] = fval;
    }

    @Override
    public void setFeatureVector(float[] dfVals) {
        this.fVals = dfVals;
    }

    @Override
    public float[] getFeatureVector() {
        return this.fVals;
    }
}

