/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.internal.compat.java.beans;

import java.util.concurrent.CopyOnWriteArrayList;
import org.jupnp.internal.compat.java.beans.PropertyChangeEvent;
import org.jupnp.internal.compat.java.beans.PropertyChangeListener;

public class PropertyChangeSupport {
    private CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    private Object source;

    public PropertyChangeSupport(Object source) {
        this.source = source;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(event);
            }
        }
    }
}

