/**
This Web Storage API interface provides access to a particular domain's session or local storage. It allows, for example, the addition, modification, or deletion of stored data items.

@returns {Storage}
*/
Storage = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Number}
**/
Storage.prototype.length = new Number();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes all key/value pairs, if there are any.

Dispatches a storage event on Window objects holding an equivalent Storage object.

@returns {undefined}
**/
Storage.prototype.clear = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the current value associated with the given key, or null if the given key does not exist.

@param {String} key
@returns {(String | null)} string | null
**/
Storage.prototype.getItem = function(key) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Returns the name of the nth key, or null if n is greater than or equal to the number of key/value pairs.

@param {Number} index
@returns {(String | null)} string | null
**/
Storage.prototype.key = function(index) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the key/value pair with the given key, if a key/value pair with the given key exists.

Dispatches a storage event on Window objects holding an equivalent Storage object.

@param {String} key
@returns {undefined}
**/
Storage.prototype.removeItem = function(key) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Sets the value of the pair identified by key to value, creating a new key/value pair if none existed for key previously.

Throws a "QuotaExceededError" DOMException exception if the new value couldn't be set. (Setting could fail if, e.g., the user has disabled storage for the site, or if the quota has been exceeded.)

Dispatches a storage event on Window objects holding an equivalent Storage object.

@param {String} key
@param {String} value
@returns {undefined}
**/
Storage.prototype.setItem = function(key, value) {};

