/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public class PutObjectRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private Long contentLength;
    private InputStream putObjectBody;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private String expect;
    private String contentMD5;
    private String contentType;
    private String contentLanguage;
    private String contentEncoding;
    private String contentDisposition;
    private String cacheControl;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private String opcSseKmsKeyId;
    private StorageTier storageTier;
    private Map<String, String> opcMeta;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getPutObjectBody() {
        return this.putObjectBody;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public String getOpcSseKmsKeyId() {
        return this.opcSseKmsKeyId;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public Map<String, String> getOpcMeta() {
        return this.opcMeta;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.putObjectBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).contentLength(this.contentLength).putObjectBody(this.putObjectBody).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).opcClientRequestId(this.opcClientRequestId).expect(this.expect).contentMD5(this.contentMD5).contentType(this.contentType).contentLanguage(this.contentLanguage).contentEncoding(this.contentEncoding).contentDisposition(this.contentDisposition).cacheControl(this.cacheControl).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256).opcSseKmsKeyId(this.opcSseKmsKeyId).storageTier(this.storageTier).opcMeta(this.opcMeta);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",putObjectBody=").append(String.valueOf(this.putObjectBody));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(",contentMD5=").append(String.valueOf(this.contentMD5));
        sb.append(",contentType=").append(String.valueOf(this.contentType));
        sb.append(",contentLanguage=").append(String.valueOf(this.contentLanguage));
        sb.append(",contentEncoding=").append(String.valueOf(this.contentEncoding));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(",cacheControl=").append(String.valueOf(this.cacheControl));
        sb.append(",opcSseCustomerAlgorithm=").append(String.valueOf(this.opcSseCustomerAlgorithm));
        sb.append(",opcSseCustomerKey=").append(String.valueOf(this.opcSseCustomerKey));
        sb.append(",opcSseCustomerKeySha256=").append(String.valueOf(this.opcSseCustomerKeySha256));
        sb.append(",opcSseKmsKeyId=").append(String.valueOf(this.opcSseKmsKeyId));
        sb.append(",storageTier=").append(String.valueOf((Object)this.storageTier));
        sb.append(",opcMeta=").append(String.valueOf(this.opcMeta));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.putObjectBody, other.putObjectBody) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.expect, other.expect) && Objects.equals(this.contentMD5, other.contentMD5) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.contentLanguage, other.contentLanguage) && Objects.equals(this.contentEncoding, other.contentEncoding) && Objects.equals(this.contentDisposition, other.contentDisposition) && Objects.equals(this.cacheControl, other.cacheControl) && Objects.equals(this.opcSseCustomerAlgorithm, other.opcSseCustomerAlgorithm) && Objects.equals(this.opcSseCustomerKey, other.opcSseCustomerKey) && Objects.equals(this.opcSseCustomerKeySha256, other.opcSseCustomerKeySha256) && Objects.equals(this.opcSseKmsKeyId, other.opcSseKmsKeyId) && Objects.equals((Object)this.storageTier, (Object)other.storageTier) && Objects.equals(this.opcMeta, other.opcMeta);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.putObjectBody == null ? 43 : this.putObjectBody.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        result = result * 59 + (this.contentMD5 == null ? 43 : this.contentMD5.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.contentLanguage == null ? 43 : this.contentLanguage.hashCode());
        result = result * 59 + (this.contentEncoding == null ? 43 : this.contentEncoding.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        result = result * 59 + (this.cacheControl == null ? 43 : this.cacheControl.hashCode());
        result = result * 59 + (this.opcSseCustomerAlgorithm == null ? 43 : this.opcSseCustomerAlgorithm.hashCode());
        result = result * 59 + (this.opcSseCustomerKey == null ? 43 : this.opcSseCustomerKey.hashCode());
        result = result * 59 + (this.opcSseCustomerKeySha256 == null ? 43 : this.opcSseCustomerKeySha256.hashCode());
        result = result * 59 + (this.opcSseKmsKeyId == null ? 43 : this.opcSseKmsKeyId.hashCode());
        result = result * 59 + (this.storageTier == null ? 43 : this.storageTier.hashCode());
        result = result * 59 + (this.opcMeta == null ? 43 : this.opcMeta.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutObjectRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String objectName = null;
        private Long contentLength = null;
        private InputStream putObjectBody = null;
        private String ifMatch = null;
        private String ifNoneMatch = null;
        private String opcClientRequestId = null;
        private String expect = null;
        private String contentMD5 = null;
        private String contentType = null;
        private String contentLanguage = null;
        private String contentEncoding = null;
        private String contentDisposition = null;
        private String cacheControl = null;
        private String opcSseCustomerAlgorithm = null;
        private String opcSseCustomerKey = null;
        private String opcSseCustomerKeySha256 = null;
        private String opcSseKmsKeyId = null;
        private StorageTier storageTier = null;
        private Map<String, String> opcMeta = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder putObjectBody(InputStream putObjectBody) {
            this.putObjectBody = putObjectBody;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder opcSseKmsKeyId(String opcSseKmsKeyId) {
            this.opcSseKmsKeyId = opcSseKmsKeyId;
            return this;
        }

        public Builder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        public Builder opcMeta(Map<String, String> opcMeta) {
            this.opcMeta = opcMeta;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.contentLength(o.getContentLength());
            this.putObjectBody(o.getPutObjectBody());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.expect(o.getExpect());
            this.contentMD5(o.getContentMD5());
            this.contentType(o.getContentType());
            this.contentLanguage(o.getContentLanguage());
            this.contentEncoding(o.getContentEncoding());
            this.contentDisposition(o.getContentDisposition());
            this.cacheControl(o.getCacheControl());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.opcSseKmsKeyId(o.getOpcSseKmsKeyId());
            this.storageTier(o.getStorageTier());
            this.opcMeta(o.getOpcMeta());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutObjectRequest build() {
            PutObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.putObjectBody(body);
            return this;
        }

        public PutObjectRequest buildWithoutInvocationCallback() {
            PutObjectRequest request = new PutObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.contentLength = this.contentLength;
            request.putObjectBody = this.putObjectBody;
            request.ifMatch = this.ifMatch;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcClientRequestId = this.opcClientRequestId;
            request.expect = this.expect;
            request.contentMD5 = this.contentMD5;
            request.contentType = this.contentType;
            request.contentLanguage = this.contentLanguage;
            request.contentEncoding = this.contentEncoding;
            request.contentDisposition = this.contentDisposition;
            request.cacheControl = this.cacheControl;
            request.opcSseCustomerAlgorithm = this.opcSseCustomerAlgorithm;
            request.opcSseCustomerKey = this.opcSseCustomerKey;
            request.opcSseCustomerKeySha256 = this.opcSseCustomerKeySha256;
            request.opcSseKmsKeyId = this.opcSseKmsKeyId;
            request.storageTier = this.storageTier;
            request.opcMeta = this.opcMeta;
            return request;
        }
    }
}

