/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorMessDetectorParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListCellRenderer;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListModel;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MessDetectorCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -1536063097951347093L;
    public static final String ENABLED = "messDetector.enabled";
    public static final String PATH = "messDetector.path";
    public static final String RULE_SETS = "messDetector.ruleSets";
    public static final String RULE_SET_FILE = "messDetector.ruleSetFile";
    public static final String OPTIONS = "messDetector.options";
    private static final RequestProcessor RP = new RequestProcessor(MessDetectorCustomizerPanel.class);
    private final MessDetectorRuleSetsListModel ruleSetsListModel = new MessDetectorRuleSetsListModel();
    final Analyzer.CustomizerContext<Void, MessDetectorCustomizerPanel> context;
    final Preferences settings;
    private JButton browseButton;
    private JCheckBox enabledCheckBox;
    private JLabel messDetectorLabel;
    private JTextField messDetectorTextField;
    private JLabel optionsLabel;
    private JTextField optionsTextField;
    private JButton ruleSetFileBrowseButton;
    private JLabel ruleSetFileLabel;
    private JTextField ruleSetFileTextField;
    private JLabel ruleSetsLabel;
    private JList<String> ruleSetsList;
    private JScrollPane ruleSetsScrollPane;
    private JButton searchButton;

    public MessDetectorCustomizerPanel(Analyzer.CustomizerContext<Void, MessDetectorCustomizerPanel> context) {
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    @CheckForNull
    public static List<String> getRuleSets(Preferences settings) {
        if (settings == null) {
            return null;
        }
        String ruleSets = settings.get(RULE_SETS, null);
        if (ruleSets == null) {
            return null;
        }
        return AnalysisUtils.deserialize(ruleSets);
    }

    private void init() {
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.validateAndSetData());
        this.initEnabledCheckBox();
        this.initMessDetectorTextField(defaultDocumentListener);
        this.initRuleSetsList();
        this.initRuleSetFileTextField(defaultDocumentListener);
        this.initOptionsTextField(defaultDocumentListener);
        RP.schedule(() -> EventQueue.invokeLater(() -> {
            this.context.setError(null);
            if (this.enabledCheckBox.isSelected()) {
                this.validateData();
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private void initEnabledCheckBox() {
        this.enabledCheckBox.addItemListener(e -> {
            this.setMessDetectorEnabled();
            this.setAllComponentsEnabled(this.enabledCheckBox.isSelected());
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.enabledCheckBox.setSelected(isEnabled);
        this.setAllComponentsEnabled(isEnabled);
        this.enabledCheckBox.addItemListener(e -> {
            if (!this.enabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
    }

    private void initMessDetectorTextField(DocumentListener documentListener) {
        this.messDetectorTextField.setText(this.settings.get(PATH, AnalysisOptions.getInstance().getMessDetectorPath()));
        this.messDetectorTextField.getDocument().addDocumentListener(documentListener);
    }

    private void initRuleSetsList() {
        this.ruleSetsList.setModel(this.ruleSetsListModel);
        this.ruleSetsList.setCellRenderer(new MessDetectorRuleSetsListCellRenderer(this.ruleSetsList.getCellRenderer()));
        List<String> ruleSets = MessDetectorCustomizerPanel.getRuleSets(this.settings);
        if (ruleSets == null) {
            ruleSets = AnalysisOptions.getInstance().getMessDetectorRuleSets();
        }
        this.selectRuleSets(ruleSets);
        this.ruleSetsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MessDetectorCustomizerPanel.this.validateAndSetData();
            }
        });
    }

    private void initRuleSetFileTextField(DocumentListener documentListener) {
        String ruleSetFile = this.settings.get(RULE_SET_FILE, AnalysisOptions.getInstance().getMessDetectorRuleSetFilePath());
        this.ruleSetFileTextField.setText(ruleSetFile);
        this.ruleSetFileTextField.getDocument().addDocumentListener(documentListener);
    }

    private void initOptionsTextField(DocumentListener documentListener) {
        String options = this.settings.get(OPTIONS, AnalysisOptions.getInstance().getMessDetectorOptions());
        this.optionsTextField.setText(options);
        this.optionsTextField.getDocument().addDocumentListener(documentListener);
    }

    public String getMessDetectorPath() {
        return this.messDetectorTextField.getText().trim();
    }

    @CheckForNull
    public String getValidMessDetectorPath() {
        if (StringUtils.hasText((String)this.getMessDetectorPath())) {
            return this.getMessDetectorPath();
        }
        return AnalysisOptions.getInstance().getMessDetectorPath();
    }

    public List<String> getSelectedRuleSets() {
        return this.ruleSetsList.getSelectedValuesList();
    }

    public String getRuleSetFile() {
        return this.ruleSetFileTextField.getText().trim();
    }

    public String getOptions() {
        return this.optionsTextField.getText().trim();
    }

    void selectRuleSets(List<String> ruleSets) {
        this.ruleSetsList.clearSelection();
        for (String ruleSet : ruleSets) {
            int indexOf = MessDetectorRuleSetsListModel.getAllRuleSets().indexOf(ruleSet);
            assert (indexOf != -1) : "Rule set not found: " + ruleSet;
            this.ruleSetsList.addSelectionInterval(indexOf, indexOf);
        }
    }

    void validateAndSetData() {
        if (this.validateData()) {
            this.setData();
        }
    }

    private boolean validateData() {
        ValidationResult result = new AnalysisOptionsValidator().validateMessDetector(ValidatorMessDetectorParameter.create(this)).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setData() {
        this.settings.put(PATH, this.getMessDetectorPath());
        this.settings.put(RULE_SETS, AnalysisUtils.serialize(this.getSelectedRuleSets()));
        this.settings.put(RULE_SET_FILE, this.getRuleSetFile());
        this.settings.put(OPTIONS, this.getOptions());
    }

    private void setMessDetectorEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setAllComponentsEnabled(boolean isEnabled) {
        for (Component component : this.getAllComponentsForEnabling()) {
            component.setEnabled(isEnabled);
        }
    }

    private List<Component> getAllComponentsForEnabling() {
        return Arrays.asList(this.messDetectorLabel, this.messDetectorTextField, this.browseButton, this.searchButton, this.ruleSetsLabel, this.ruleSetsList, this.ruleSetsScrollPane, this.ruleSetFileLabel, this.ruleSetFileTextField, this.ruleSetFileBrowseButton, this.optionsLabel, this.optionsTextField);
    }

    private void initComponents() {
        this.ruleSetsLabel = new JLabel();
        this.ruleSetsScrollPane = new JScrollPane();
        this.ruleSetsList = new JList();
        this.enabledCheckBox = new JCheckBox();
        this.ruleSetFileTextField = new JTextField();
        this.ruleSetFileLabel = new JLabel();
        this.ruleSetFileBrowseButton = new JButton();
        this.optionsTextField = new JTextField();
        this.optionsLabel = new JLabel();
        this.messDetectorLabel = new JLabel();
        this.messDetectorTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.ruleSetsLabel.setLabelFor(this.ruleSetsList);
        Mnemonics.setLocalizedText((JLabel)this.ruleSetsLabel, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.ruleSetsLabel.text"));
        this.ruleSetsScrollPane.setViewportView(this.ruleSetsList);
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.enabledCheckBox.text"));
        this.ruleSetFileLabel.setLabelFor(this.ruleSetFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.ruleSetFileLabel, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.ruleSetFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ruleSetFileBrowseButton, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.ruleSetFileBrowseButton.text"));
        this.ruleSetFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorCustomizerPanel.this.ruleSetFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.optionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.messDetectorLabel, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.messDetectorLabel.text"));
        this.messDetectorTextField.setText(NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.messDetectorTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorCustomizerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorCustomizerPanel.this.searchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messDetectorLabel).addComponent(this.ruleSetsLabel).addComponent(this.ruleSetFileLabel).addComponent(this.optionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ruleSetFileTextField).addComponent(this.optionsTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ruleSetFileBrowseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ruleSetsScrollPane).addComponent(this.messDetectorTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messDetectorLabel).addComponent(this.messDetectorTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.searchButton)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ruleSetsLabel).addComponent(this.ruleSetsScrollPane, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ruleSetFileTextField, -2, -1, -2).addComponent(this.ruleSetFileLabel).addComponent(this.ruleSetFileBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsTextField, -2, -1, -2).addComponent(this.optionsLabel))));
    }

    private void ruleSetFileBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseMessDetectorRuleSet();
        if (file != null) {
            this.ruleSetFileTextField.setText(file.getAbsolutePath());
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browseMessDetector();
        if (file != null) {
            this.messDetectorTextField.setText(file.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String messDetector = AnalysisUiUtils.searchMessDetector();
        if (messDetector != null) {
            this.messDetectorTextField.setText(messDetector);
        }
    }
}

